/*
 Paros and its related class files.
 Paros is an HTTP/HTTPS proxy for assessing web application security.
 Copyright (C) 2003-2004 www.proofsecure.com

 This program is free software; you can redistribute it and/or
 modify it under the terms of the Clarified Artistic License
 as published by the Free Software Foundation.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 Clarified Artistic License for more details.

 You should have received a copy of the Clarified Artistic License
 along with this program; if not, write to the Free Software
 Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package com.proofsecure.paros.scan;

import java.io.IOException;
import java.util.regex.Pattern;

import com.proofsecure.paros.network.HttpStatusCode;

class TestServerSideInclude extends TestAbstractParam {

	private static final String SSI_UNIX = "<!--#EXEC%20cmd=\"ls%20/\"-->";
	private static final String SSI_UNIX2 = "\">" +SSI_UNIX + "<";
	private static final String SSI_WIN = "<!--#EXEC%20cmd=\"dir%20\\\"-->";
	private static final String SSI_WIN2 = "\">" +SSI_WIN + "<";
	
	
	private static Pattern patternSSIUnix = Pattern.compile("\\broot\\b.*\\busr\\b", PATTERN_PARAM);
	private static Pattern patternSSIWin = Pattern.compile("\\bprogram files\\b", PATTERN_PARAM);
	
	private String mResBodyNormal 	= "";		// normal response for comparison
	
	TestServerSideInclude() {
	}

	public String toString() {
		return "TestServerSideInclude";
	}
	
	public String getTestName() {
		return "Server Side Include";
	}	
	
	protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {

		String bingoQuery = null;

		String newQuery = null;
		
		String resBodyAND = null;
		String resBodyANDErr = null;
		
		int pos = 0;
		long defaultTimeUsed = 0;
		long timeUsed = 0;
		long lastTime = 0;
		
		// always try normal query first
		newQuery = insertQuery(query, insertPos, paramKey + "=" + paramValue);
		createMessage(isBody, newQuery);
		lastTime = System.currentTimeMillis();
		sendAndReceive();
		defaultTimeUsed = System.currentTimeMillis() - lastTime;
		if (getResponseHeader().getStatusCode() != HttpStatusCode.OK) {
			return;
		}

		mResBodyNormal = getResponseBody().toString();
		
		// try SSI Unix
		if (checkEachPattern(isBody, paramKey, paramValue, query, insertPos, SSI_UNIX, patternSSIUnix)){
			bingo(20004, AlertItem.RISK_HIGH, AlertItem.WARNING, getRequestHeader().getURIHostPathQuery(), bingoQuery, "");
			return;
		}

		// try SSI Unix 2
		if (checkEachPattern(isBody, paramKey, paramValue, query, insertPos, SSI_UNIX2, patternSSIUnix)){
			bingo(20004, AlertItem.RISK_HIGH, AlertItem.WARNING, getRequestHeader().getURIHostPathQuery(), bingoQuery, "");
			return;
		}
		
		// try SSI Window
		if (checkEachPattern(isBody, paramKey, paramValue, query, insertPos, SSI_WIN, patternSSIWin)){
			bingo(20004, AlertItem.RISK_HIGH, AlertItem.WARNING, getRequestHeader().getURIHostPathQuery(), bingoQuery, "");
			return;
		}
		
		// try SSI Window 2
		if (checkEachPattern(isBody, paramKey, paramValue, query, insertPos, SSI_WIN2, patternSSIWin)){
			bingo(20004, AlertItem.RISK_HIGH, AlertItem.WARNING, getRequestHeader().getURIHostPathQuery(), bingoQuery, "");
			return;
		}
		
		

	}



	
	protected void scan() throws Exception {
		boolean skip = (getEntity().mState == ParsedEntity.DO_NOT_SCAN);
		
		writeStatus("Server Side Include: " + (skip? "(skipped) " : "") + getRequestHeader().getURIHostPath());
		if (skip) {
			return;
		}
		init();
		checkUrlOrBody(false, myQuery);
		checkUrlOrBody(true, myReqBody.toString());
	}

}