/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.spider; 

import java.net.*;
import java.util.Vector;

/* This class control the HTTP connections, sessions & authentication
 */
class HttpControl{
	URI mStartpoint = null;
	URI mURI;

	HttpControl(URI uri){
		mStartpoint = uri;
		init();
	}

	HttpControl(String s){
		try{
			mStartpoint = new URI(s);
		}catch(Exception e){
			logError(e.getMessage());			
		}		
		init();
	}

	void init(){
		try{
			if (!mStartpoint.isAbsolute()){
				// use default
				mStartpoint = (new URI("http://localhost/bbbb/aaaa/index.asp")).resolve(mStartpoint);				
			}
		}catch(Exception e){
			logError(e.getMessage());			
		}
	}	
			
	public void setLink(URL url){
//		init();
		try{
			mURI = new URI(url.toExternalForm());
			if (!mURI.isAbsolute()){
				mURI = mStartpoint.resolve(mURI);
			}			
			showURLComponents(mURI.toURL());
		}catch(URISyntaxException e){
			logError(e.getMessage());
		}catch(MalformedURLException e){
			logError(e.getMessage());
		}
	}

	public String getLinkDirectory(URI uri){
		String s = uri.toString();
		int i=-1;
		if ((i=s.lastIndexOf("/"))!=-1)
			return s.substring(0,i+1);
		else
			return null;
	}

	public String getLinkDirectory(){
		String s = mURI.toString();
		int i=-1;
		if ((i=s.lastIndexOf("/"))!=-1)
			return s.substring(0,i+1);
		else
			return null;
	}
	
	public void setLink(URI uri){
//		init();		
		if (!uri.isAbsolute()){
			uri = mStartpoint.resolve(uri);
		}
		mURI = uri;
		
		try{
			showURLComponents(mURI.toURL());
		}catch(MalformedURLException e){
			logError(e.getMessage());
		}
	}

	public void logError(String s){		
		System.out.println(s);
	}
	

	public void showURLComponents(URL url){	
		System.out.println(url.getProtocol());	
		System.out.println(url.getAuthority());
		System.out.println(url.getHost());
		System.out.println(url.getPort());
		System.out.println(url.getFile());
		System.out.println(url.getPath());
		System.out.println(url.getQuery());
		System.out.println(url.getRef());
		System.out.println(url.getUserInfo());
	}
		
	public String toString(){		
		return mURI.toString();
	}
	
  public static void main(String[] args) {
		// [scheme:][//authority][path][?query][#fragment] 
		// getProtocol, getAuthority(=getHost()+getPort()), getFile()(=getPath()+getQuery()), getRef()
		// getUserInfo() = ???
  
  	Vector vector = new Vector();
  	
  	try{
	  	vector.add(new URL("http://www.abc.com:80/abc/abcde?a=b&c=123#abc"));
	  	vector.add(new URL("http://archive.ncsa.uiuc.edu:8080/SDG/Software/Mosaic/Demo/url-primer.html#abc"));
	  	vector.add(new URI("../abc?a=b"));

  	HttpControl control= new HttpControl("http://www.a.com/a111/b11/index.asp");
  	for (int i=0;i< vector.size();i++){
  		/*
  		if (vector.elementAt(i) instanceof URI){
  			// relative URI => absolute URI => URL 
  			URI u = (URI)(vector.elementAt(i));
  			if (!u.isAbsolute()){
  					URI site = new URI("http://www.coo.com:8080/");
  					u = site.resolve(u);
  			}
  			control = new HttpControl(u.toURL());
  			
  		}
  		else
  			control = new HttpControl((URL)(vector.elementAt(i)));
  			*/
  		if (vector.elementAt(i) instanceof URI)
	 			control.setLink((URI)(vector.elementAt(i)));
  		else
 				control.setLink((URL)(vector.elementAt(i)));
  		System.out.println(control);
  		System.out.println(control.getLinkDirectory());
  		
  	}

		}catch(Exception e){
			System.out.println(e.getMessage());
		}  	
  	

  }


	class Cookie{
	  String id;
	  String value;
	  String parameters;
	  
	  public void setCookie(String header){
	   // parse cookie format
	   int i;
	   if ((i=header.indexOf(";"))!=-1){     
	   } 
	  }
	}

	class Authentication{
		Vector mAuth;	
		Authentication(){
		}						
	}

}


/*
class Cookie{
  String id;
  String value;
  String parameters;
  
  public setCookie(String header){
   // parse cookie format
   int i;
   if ((i=header.indexOf(";"))!=-1){     
   } 
  }
}

class Authentication{
}

// header -> Cookie -> CookieManager

class Spider{
  startpoint,
  Website site
}
class Website
  sitename, port
  List cookies;  // url/cookie
  List auth // url/auth(user/passwd)
  List urlHistory/ContentType  // url
  List raw // can be skipped
  List serverType
  TreeGUI hierarchy
  getHeader()

*/