/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import javax.swing.JScrollPane;

import com.proofsecure.paros.Global;

public final class EncodeDialog extends javax.swing.JDialog {

	private final static String CODEPAGE = "8859_1";

    private javax.swing.JButton btnSHA1;
    private javax.swing.JButton btnMD5;
    private javax.swing.JButton btnBase64Encode;
    private javax.swing.JButton btnBase64Decode;
    private javax.swing.JButton btnURLEncode;
    private javax.swing.JButton btnURLDecode;
    private javax.swing.JButton btnCancel;

    private javax.swing.JTextArea txtEncode;
    private javax.swing.JTextArea txtDecode;
    private javax.swing.JLabel jLabelEncode;
    private javax.swing.JLabel jLabelDecode;
  	private JScrollPane jScrollEncode = new JScrollPane();
  	private JScrollPane jScrollDecode = new JScrollPane();


    /** Creates new form MenuOptions */
    public EncodeDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();
    }

    private void initComponents() {//GEN-BEGIN:initComponents

        btnSHA1 = new javax.swing.JButton("SHA1 hash");
        btnMD5 = new javax.swing.JButton("MD5 hash");
        btnBase64Encode = new javax.swing.JButton("Base64 encode");
        btnBase64Decode = new javax.swing.JButton("Base64 decode");
        btnURLEncode	= new javax.swing.JButton("URL encode");
        btnURLDecode	= new javax.swing.JButton("URL deccode");

        jLabelEncode = new javax.swing.JLabel("Enter plain text below for hashing/encoding:");
        jLabelDecode = new javax.swing.JLabel("Enter encoded text below for decoding:");
        
        txtEncode = new javax.swing.JTextArea();
        txtEncode.setLineWrap(true);
		txtEncode.setColumns(32);
		txtEncode.setRows(5);
        txtDecode = new javax.swing.JTextArea();
        txtDecode.setLineWrap(true);
        txtDecode.setColumns(32);
        txtDecode.setRows(5);
  		
  		jScrollEncode.getViewport().add(txtEncode, null);
  		jScrollDecode.getViewport().add(txtDecode, null);
        
        getContentPane().setLayout(new java.awt.GridBagLayout());
        java.awt.GridBagConstraints gridBagConstraints1;
        
        setTitle(Global.APP_TITLE);

        //setResizable(false);
        setBackground(java.awt.Color.lightGray);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });
        
        btnSHA1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnSHA1ActionPerformed(evt);
            }
        });

        btnMD5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnMD5ActionPerformed(evt);
            }
        });
        
        btnBase64Encode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnBase64EncodeActionPerformed(evt);
            }
        });

        btnBase64Decode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnBase64DecodeActionPerformed(evt);
            }
        });

        btnURLDecode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnURLDecodeActionPerformed(evt);
            }
        });

        btnURLEncode.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                btnURLEncodeActionPerformed(evt);
            }
        });
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.ipadx = 18;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnSHA1, gridBagConstraints1);
        
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 2;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnMD5, gridBagConstraints1);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 3;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnBase64Encode, gridBagConstraints1);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 4;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnURLEncode, gridBagConstraints1);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnBase64Decode, gridBagConstraints1);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 3;
        gridBagConstraints1.gridy = 7;
        gridBagConstraints1.gridwidth = 1;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(btnURLDecode, gridBagConstraints1);


        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 0;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        //gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabelEncode, gridBagConstraints1);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 5;
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        //gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jLabelDecode, gridBagConstraints1);
        
        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 1;
        gridBagConstraints1.gridwidth = 3;	//java.awt.GridBagConstraints.REMAINDER;
		gridBagConstraints1.gridheight = 3;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.7;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jScrollEncode, gridBagConstraints1);

        gridBagConstraints1 = new java.awt.GridBagConstraints();
        gridBagConstraints1.gridx = 0;
        gridBagConstraints1.gridy = 6;
        gridBagConstraints1.gridwidth = 3;	//java.awt.GridBagConstraints.REMAINDER;
		gridBagConstraints1.gridheight = 3;
        gridBagConstraints1.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints1.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints1.weightx = 0.7;
        gridBagConstraints1.weighty = 0.5;
        gridBagConstraints1.insets = new java.awt.Insets(5, 5, 5, 5);
        getContentPane().add(jScrollDecode, gridBagConstraints1);

        
        pack();
    }//GEN-END:initComponents

    private void btnMD5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnCancelActionPerformed

		byte[] md5 = null;
		txtDecode.setText("");
		try {
			md5 = getHashMD5(txtEncode.getText().getBytes(CODEPAGE));
			txtDecode.setText(getHexString(md5));
		} catch (Exception e) {
		}

    }//GEN-LAST:event_btnCancelActionPerformed

    private void btnSHA1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed

		byte[] sha = null;
		txtDecode.setText("");
		try {
			sha = getHashSHA1(txtEncode.getText().getBytes(CODEPAGE));
			txtDecode.setText(getHexString(sha));
		} catch (Exception e) {
		}	

    }//GEN-LAST:event_btnOKActionPerformed

    private void btnBase64EncodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed

		String result = "";
		try {
			result = com.proofsecure.paros.util.Base64.encodeBytes(getBytes(txtEncode.getText()));
		} catch (Exception e) {
		}
		txtDecode.setText(result);
		
    }
    
    private void btnBase64DecodeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_btnOKActionPerformed

		byte[] result = null;
		txtEncode.setText("");
		if (!isValidBase64(txtDecode.getText())) {
			return;
		}
		try {
			result = com.proofsecure.paros.util.Base64.decode(txtDecode.getText());
			txtEncode.setText(new String(result, CODEPAGE));
		} catch (Exception e) {
		}

    }
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        txtEncode.setText("");
        txtDecode.setText("");
    }//GEN-LAST:event_closeDialog

	
	private byte[] getHashSHA1(byte[] buf) throws NoSuchAlgorithmException {
				
		MessageDigest sha = MessageDigest.getInstance("SHA-1");
		sha.update(buf);
		return sha.digest();
	}
	
	private byte[] getHashMD5(byte[] buf) throws NoSuchAlgorithmException {
		MessageDigest md5 = MessageDigest.getInstance("MD5") ;
		md5.update(buf);
		return md5.digest();
	}

	private String getHexString(byte[] buf) {
		StringBuffer sb = new StringBuffer(20);
		for (int i=0; i<buf.length; i++) {
			int digit = ((int) buf[i]) & 0xFF;
			String hexDigit = Integer.toHexString(digit).toUpperCase();
			if (hexDigit.length() == 1) {
				sb.append('0');
			}
			sb.append(hexDigit);
		}
		return sb.toString();			
			
	}

	private byte[] getBytes(String buf) throws UnsupportedEncodingException {
		return buf.getBytes(CODEPAGE);
	}		
	
	/**
	The Base64 decoder perform Base64 decode even if the string is incorrect.
	This method is used to check if the code is correct.
	*/
	private boolean isValidBase64(String buf) {
		String result = com.proofsecure.paros.util.Base64.encodeBytes(com.proofsecure.paros.util.Base64.decode(buf));
		if (buf.equals(result)) {
			return true;
		} else {
			return false;
		}
	}

    private void btnURLDecodeActionPerformed(java.awt.event.ActionEvent evt) {
		String result;
		txtEncode.setText("");

		try {
			result = URLDecoder.decode(txtDecode.getText(), "UTF8");
			txtEncode.setText(result);
		} catch (Exception e) {
		}

    }

    private void btnURLEncodeActionPerformed(java.awt.event.ActionEvent evt) {
		String result;

		txtDecode.setText("");

		try {
			result = URLEncoder.encode(txtEncode.getText(), "UTF8");
			txtDecode.setText(result);
		} catch (Exception e) {
		}

    }


}