/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;

import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingConstants;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

import com.proofsecure.paros.Global;

public class FilterPanel extends JPanel{
  private DefaultTableModel dm ;
  private JTable jTable1 = null;
  private JScrollPane jScrollPane3 = new JScrollPane();

  private JButton loadButton = new JButton();
  private JButton saveButton = new JButton();
  private JScrollPane btntScrollPane = new JScrollPane();
  private Box buttons;

  // private data
  private Vector header = new Vector(); 
  private Vector data;  // point to the enablelist of FilterManager
  
  public FilterPanel(){
    super();    
    init();

  }
  
  public void createTable(){
     dm = new DefaultTableModel() {
              public boolean isCellEditable(int row, int col) {
                  //Note that the data/cell address is constant,
                  //no matter where the cell appears onscreen.
                  if (col > 1 ) {
                      return false;
                  } else {
                      return true;
                  }
              }
              public Class getColumnClass(int col) { 
                   if (col == 0) {
                        return Boolean.class;
                   }/*
                   else if (col == 1) {
                        return JDialog.class;
                   }*/
                    else {
                        return String.class;
                   }
              }
              
              // Update 
/*              
              public void setValueAt(Object value, int row, int col) {
                  super.setValueAt(value,row,col);
//                  System.out.println((String)(this.getValueAt(row, 0)));
                  Global.filterManager.setEnabled((String)(this.getValueAt(row, 0)), ((Boolean)value).booleanValue());
              }
*/                
         };   
                    
    dm.setDataVector(data,header);

    // set JTable componene=t         
    jTable1 = new JTable() {        
        public Component prepareRenderer(TableCellRenderer renderer,
                                         int rowIndex, int vColIndex) {
            Component c = super.prepareRenderer(renderer, rowIndex, vColIndex);
            if (vColIndex != 0 && !isCellSelected(rowIndex, vColIndex)) {
//                c.setForeground(Color.WHITE);
                c.setBackground(SystemColor.activeCaptionBorder);
            } else {
                // If not shaded, match the table's background
//                c.setBackground(Color.LIGHT_GRAY);
            }
            return c;
        }
    };

    jTable1.setModel(dm);
    jTable1.setColumnSelectionAllowed(false);
    jTable1.setRowSelectionAllowed(false);
    jTable1.getTableHeader().setReorderingAllowed(false);

    setUpFilterEditor(jTable1);

    int width = 60;
    int vColIndex = 0;
    TableColumn col = jTable1.getColumnModel().getColumn(vColIndex);
    col.setMinWidth(width);
    col.setMaxWidth(width);    
    col.setPreferredWidth(width);
    col.setCellRenderer(new CheckBoxRenderer());

    width = 100;
    vColIndex = 1;
    col = jTable1.getColumnModel().getColumn(vColIndex);
    col.setMinWidth(width);
    col.setMaxWidth(width+width+width);    
    col.setPreferredWidth(width);
  }

  private void init(){

    // init data
    if (Global.filterManager!=null){
        data = Global.filterManager.getDataModel();
        if (data.size() == 0){
//          System.out.println("no filters");
          // no filters 
        }
    }
    header.add(new String("Enable"));
    header.add(new String("Functions"));
//    header.add(new String("Filters"));
    header.add(new String("Description"));

    createTable();


    this.setLayout(new BorderLayout());
    jScrollPane3.getViewport().add(jTable1, null);

    // set buttons
    buttons = Box.createHorizontalBox();
    buttons.add(loadButton, null);
    buttons.add(saveButton, null);
    btntScrollPane.setVerticalScrollBarPolicy(JScrollPane.VERTICAL_SCROLLBAR_NEVER);
    btntScrollPane.setHorizontalScrollBarPolicy(JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
    btntScrollPane.getViewport().add(buttons, null);

    loadButton.setText("Enable All");
    loadButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
			int i ;			
			for (i=0; i< jTable1.getRowCount();i++){
				jTable1.setValueAt(Boolean.TRUE, i, 0);
			}			
      }
    });
    saveButton.setText("Disable All");
    saveButton.addActionListener(new java.awt.event.ActionListener() {
      public void actionPerformed(ActionEvent e) {
        try{
/*
            Global.filterManager.addFilter("LogFieldFilter");
            data = Global.filterManager.getDataModel();
            System.out.println(((Vector)(data.elementAt(3))).elementAt(2));

            createTable();
            jTable1.doLayout();
            jTable1.revalidate();
            jTable1.repaint();

*/
			int i ;			
			for (i=0; i< jTable1.getRowCount();i++){
				jTable1.setValueAt(Boolean.FALSE, i, 0);
			}


		 }catch(Exception e1){ e1.printStackTrace();}
      }
    });

    this.add(jScrollPane3, BorderLayout.CENTER);  
    this.add(btntScrollPane, BorderLayout.SOUTH);
    JTextField uppertext = new JTextField();
    uppertext.setBackground(SystemColor.activeCaptionBorder);
    uppertext.setText("Filters are run automatically after being enabled.");
    this.add(uppertext, BorderLayout.NORTH);

    if (data.size() == 0){
      saveButton.setEnabled(false);      
      loadButton.setEnabled(false);      
      //this.setEnabled(false);
//      jTable1.setEnabled(false);
    }
    else{    
      saveButton.setEnabled(true);      
      loadButton.setEnabled(true);      
//      jTable1.setEnabled(true);
      //this.setEnabled(true);
    }   
   
  }



  public class CheckBoxRenderer extends JCheckBox implements TableCellRenderer{ 
        public CheckBoxRenderer(){
         super();
         this.setHorizontalAlignment(SwingConstants.CENTER);
        }
        public Component getTableCellRendererComponent(JTable table,
               Object value, boolean isSelected, 
               boolean hasFocus, int row, int column) { 
                       setSelected(((Boolean)value).booleanValue()); 
                       return this; 
                 }        
                
        

    // override the following functions for better performace                 
    public void validate() {}
    public void revalidate() {}
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {}
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {}
           
  }

    //Set up the editor for the Color cells.
    private void setUpFilterEditor(JTable table) {
        //First, set up the button that brings up the dialog.
        JButton button = new JButton();

        //Now create an editor to encapsulate the button, and
        //set it up as the editor for all Color cells.
        FilterEditor filterEditor = new FilterEditor(button);
        table.setDefaultEditor(JDialog.class, filterEditor);
    }


           
    class FilterEditor extends DefaultCellEditor {
//        Color currentColor = null;
		JDialog current = null;

        public FilterEditor(JButton b) {
                super(new JCheckBox()); //Unfortunately, the constructor
                                        //expects a check box, combo box,
                                        //or text field.
//			current = b.getText();                                        
            editorComponent = b;
            setClickCountToStart(1); //This is usually 1 or 2.

            //Must do this so that editing stops when appropriate.
            b.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {
                    fireEditingStopped();
                }
            });
        }

        protected void fireEditingStopped() {
            super.fireEditingStopped();
        }

        public Object getCellEditorValue() {
        	// show dialog after clicked button
			current.show();
            return current;// currentColor;
        }

        public Component getTableCellEditorComponent(JTable table, 
                                                     Object value,
                                                     boolean isSelected,
                                                     int row,
                                                     int column) {
       		if (value != null){
       			// display text when clicked
            	((JButton)editorComponent).setText(value.toString());
	       		current = (JDialog)value; //XXXDoublecheck this is OK
            }
            else{
            	((JButton)editorComponent).setText("");            
            }
            return editorComponent;
        }
    }

  
}

