/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.ManualTester;
import com.proofsecure.paros.log.OpenFileDialog;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.spider.SpiderGUI;
import com.proofsecure.paros.util.Util;
import com.proofsecure.paros.scan.Report;
import com.proofsecure.paros.scan.ScannerStress;


public class ParosMenu extends JMenuBar{
	private SpiderGUI spider = null;

	
  // for menu
  private JMenu jMenuFile = new JMenu();
  private JMenuItem jMenuFileExit = new JMenuItem();
  private JMenu jMenuEdit = new JMenu();
  private JMenuItem jMenuEditFind = new JMenuItem();
  
  private JMenu jMenuView = new JMenu();
  private JMenuItem jMenuSessionDump = new JMenuItem();
  private JMenuItem jMenuSessionDumpFile = new JMenuItem();
  private JMenuItem jMenuSessionDumpClear = new JMenuItem();
  private JMenuItem jMenuSessionDumpClearAll = new JMenuItem();
  private JMenuItem jMenuViewTrap = new JMenuItem();
  private JMenuItem jMenuViewOptions = new JMenuItem();
  private JMenuItem jMenuViewFilters = new JMenuItem();
  private JMenuItem jMenuViewScan = new JMenuItem();
  private JCheckBoxMenuItem jMenuViewImage = new JCheckBoxMenuItem();
  private JMenu jMenuHelp = new JMenu();
  private JMenuItem jMenuHelpAbout = new JMenuItem();

  private JMenu jMenuScan = new JMenu();
  private JMenuItem jMenuScanSelected = new JMenuItem();
  private JMenuItem jMenuScanAll = new JMenuItem();
  private JMenuItem jMenuScanStress = new JMenuItem();
  private JMenuItem jMenuScanStop = new JMenuItem();
  private JCheckBoxMenuItem jMenuScanSkipNode = new JCheckBoxMenuItem();
  private JMenuItem jMenuScanDeleteTree = new JMenuItem();
  
  private JMenu		jMenuReport		= new JMenu();
  private JMenuItem jMenuReportScan = new JMenuItem();

  private JMenu jMenuSession = new JMenu();
  private JMenu jMenuTools = new JMenu();
  private JMenuItem jMenuToolsEnableCert = new JMenuItem();
  private JMenuItem jMenuToolsDisableCert = new JMenuItem();
  private JMenuItem jMenuToolsEncode = new JMenuItem();
  private JMenuItem jMenuToolsSpider = new JMenuItem();
  private JMenuItem jMenuToolsSendHTTP = new JMenuItem();
  //  private JMenuItem jMenuToolsSpiderStop = new JMenuItem();


  private JFrame frame;
 
  public ParosMenu(JFrame f){
    super();
    frame = f;
    init();
  }
  

  private void init(){
    // menu creation
    jMenuFile.setText("File");
	jMenuFile.setMnemonic(KeyEvent.VK_F);
    jMenuFileExit.setText("Exit");
    jMenuFileExit.setMnemonic(KeyEvent.VK_E);
    jMenuFileExit.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuFileExit_actionPerformed(e);
      }
    });
    
    jMenuEdit.setText("Edit");
	jMenuEdit.setMnemonic(KeyEvent.VK_E);
    jMenuEditFind.setText("Find...");
    jMenuEditFind.setMnemonic(KeyEvent.VK_F);
    jMenuEditFind.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, KeyEvent.CTRL_MASK));
    jMenuEditFind.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuEditFind_actionPerformed(e);
      }
    });
    
    jMenuHelp.setText("Help");
    jMenuHelp.setMnemonic(KeyEvent.VK_H);
    jMenuHelpAbout.setText("About " + com.proofsecure.paros.Global.APP_NAME);
    jMenuHelpAbout.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuHelpAbout_actionPerformed(e);
      }
    });


    jMenuView.setText("View");
    jMenuView.setMnemonic(KeyEvent.VK_V);
    jMenuViewTrap.setText(ParosFrame.TRAP_PANEL);
    jMenuViewTrap.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuView_actionPerformed(e);
      }
    });
    jMenuViewFilters.setText(ParosFrame.FILTER_PANEL);
    jMenuViewFilters.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuView_actionPerformed(e);
      }
    });
    jMenuViewScan.setText(ParosFrame.SCAN_PANEL);
    jMenuViewScan.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuView_actionPerformed(e);
      }
    });

    jMenuViewOptions.setText(ParosFrame.OPTION_PANEL);
    jMenuViewOptions.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
        jMenuView_actionPerformed(e);
      }
    });

    jMenuViewImage.setText("Show Image Request in Log");
    jMenuViewImage.setState(Global.isViewImage);
    jMenuViewImage.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
		jMenuViewImage_actionPerformed(e);
      }
    });

	jMenuScan.setText("Tree");
	jMenuScan.setMnemonic(KeyEvent.VK_R);
    jMenuScanSelected.setText("Scan Selected Node");
	jMenuScanSelected.setMnemonic(KeyEvent.VK_S);
    jMenuScanSelected.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {

			Global.parosFrame.requestLogFocus(ParosFrame.OUTPUT_LOG);
        	if (Global.treePanel.getSelectedParsedEntity().isRoot()) {
				scanAll();
				return;
			}
			
        	if (Global.treePanel.getSelectedParsedEntity() != null) {
          		Global.scanner.startScan(Global.treePanel.getSelectedParsedEntity());
        	} else {
        		Util.showMessageDialog("Please select a site or folder.");
        	}
        	


      	}
    });

    jMenuScanAll.setText("Scan All");
    jMenuScanAll.setMnemonic(KeyEvent.VK_A);
    jMenuScanAll.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
			Global.parosFrame.requestLogFocus(ParosFrame.OUTPUT_LOG);
			scanAll();
      	}
    });

	String ST = "Scan ST One Node";
    jMenuScanStress.setText(ST);
    jMenuScanStress.setMnemonic(KeyEvent.VK_O);
    jMenuScanStress.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
			Global.parosFrame.requestLogFocus(ParosFrame.OUTPUT_LOG);

      		if (Global.treePanel.getSelectedParsedEntity() != null) {
          		scanStress(Global.treePanel.getSelectedParsedEntity());
        	} else {
        		Util.showMessageDialog("Please select a site or folder.");
        	}
      	}
    });


    jMenuScanStop.setText("Scan Stop");
    jMenuScanStop.setMnemonic(KeyEvent.VK_S);
    jMenuScanStop.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
			if (Global.currentScanner == null || !Global.currentScanner.isStarted()) {
        		Util.showMessageDialog("Scanner not started yet.");
        	} else {
        		Global.currentScanner.stopScan();
        	}
      	}
    });


    jMenuScanSkipNode.setText("Mark Node as NOT SCAN");
	jMenuScanSkipNode.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
			setMenuScanSkipValue(Global.treePanel.getSelectedParsedEntity(), jMenuScanSkipNode);
      	}
    });

	
	jMenuScanDeleteTree.setText("Delete Selected Node");
	jMenuScanDeleteTree.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {   
    		
        	ParsedEntity entity = null;
        	
        	//entity = Global.treePanel.getSelectedParsedEntity();
        	//Global.treePanel.getTree().removeSelectionPath(Global.treePanel.getTree().getSelectionPath());
        	
        	
        	ParsedEntity parent = null;
        	entity = Global.treePanel.getSelectedParsedEntity();

        	if (entity == null) {
        		Util.showMessageDialog("Please select a site or folder.");
				return;
        	}

			parent = (ParsedEntity) entity.getParent();
			if (parent != null) {
                Global.treePanel.getTreeModel().removeNodeFromParent(entity);
                Global.treePanel.getTree().setModel(Global.treePanel.getTreeModel());
            }
			
       	
		}
    });
    

	jMenuReport.setText("Report");
	jMenuReport.setMnemonic(KeyEvent.VK_R);
	jMenuReportScan.setText("Last Scan Alert Report");
	jMenuReportScan.setMnemonic(KeyEvent.VK_S);
	jMenuReportScan.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			Report.openBrowser(Global.fileReportScan.getAbsolutePath());
		}
	});
	
    
	jMenuSession.setText("Session");
	jMenuSessionDump.setText("Advanced Analyzer (Current session)...");
	jMenuSessionDump.setMnemonic(KeyEvent.VK_F4);
	jMenuSessionDump.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F4, 0));
	jMenuSessionDump.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {			
			jMenuSessionDump_actionPerformed(e);
		}
	});

	jMenuSessionDumpFile.setText("Other session log files...");
	jMenuSessionDumpFile.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {			
			jMenuSessionDumpFile_actionPerformed(e);
		}
	});

	jMenuSessionDumpClearAll.setText("Clear Current Session");
	jMenuSessionDumpClearAll.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F3,0));
	jMenuSessionDumpClearAll.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			Global.dumpLog.resetCurDate();
			Global.dumpAnalyzer.refresh();
			Global.urlLog.clear();
			Global.parosFrame.clearTree();
			Global.parosFrame.clearAllPanel();
			Global.filterManager.clearFilterStatus("LogCookie");
		}
	});

	jMenuSessionDumpClear.setText("Clear URLs");
	jMenuSessionDumpClear.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			int answer = JOptionPane.showConfirmDialog(null, "Clear the list?\r\n(this only affects the list display. Messages are still in session file)","Warning",JOptionPane.YES_NO_OPTION);
			if (answer != JOptionPane.YES_OPTION) {        
			  // User clicked no
			  return;
			}			
			Global.dumpLog.resetCurDate();
			Global.dumpAnalyzer.refresh();
			Global.urlLog.clear();
		}
	});

    jMenuTools.setText("Tools");
    jMenuTools.setMnemonic(KeyEvent.VK_T);


    jMenuToolsEnableCert.setText("Enable client cert...");
    jMenuToolsEnableCert.setMnemonic(KeyEvent.VK_E);
    jMenuToolsEnableCert.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
      		jMenuToolsEnableCert_actionPerformed(e);
      	}
    });

    jMenuToolsDisableCert.setText("Disable client cert");
    jMenuToolsDisableCert.setMnemonic(KeyEvent.VK_D);
    jMenuToolsDisableCert.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
      		jMenuToolsDisableCert_actionPerformed(e);
      	}
    });
    jMenuToolsDisableCert.setEnabled(false);

	jMenuToolsEncode.setText("Hash/Encoding...");
    jMenuToolsEncode.setMnemonic(KeyEvent.VK_C);
    jMenuToolsEncode.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
      		if (Global.encodeDialog == null) {
      			Global.encodeDialog = new EncodeDialog(Global.parosFrame, false);
				Global.encodeDialog.pack();
			}
			Util.centreChild(frame, Global.encodeDialog);
   			Global.encodeDialog.show();
      	}
    });

	jMenuToolsSpider.setText("Spider...");
  jMenuToolsSpider.setMnemonic(KeyEvent.VK_P);
    jMenuToolsSpider.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
      		if (spider!=null && spider.isAlive())
      			return; // a spider is already running
      			//spider.interrupt(); // kill spider complusory
      		spider = new SpiderGUI();
      		if (spider.init())
					Global.parosFrame.requestLogFocus(ParosFrame.OUTPUT_LOG);
      				spider.start();

      	}
    });

	jMenuToolsSendHTTP.setText("Send HTTP(S) Requests");
		jMenuToolsSendHTTP.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				ManualTester tester = new ManualTester(); 
				tester.show();
			}
		});


/*
	jMenuToolsSpiderStop.setText("Stop Spider");
  jMenuToolsSpiderStop.setMnemonic(KeyEvent.VK_O);
    jMenuToolsSpiderStop.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {
      		if (spider==null){
      			JOptionPane.showMessageDialog(Global.parosFrame, "Spider stopped."); 
      			return;
      		}
      		spider.setStop();
      		//try{
      			while (spider.isAlive())
      				Util.sleep(100);
      				
      			spider = null;
      			//spider.join();
      		//}catch(InterruptedException ie){
      		//}
      		JOptionPane.showMessageDialog(Global.parosFrame, "Spider stopped."); 
      		

      	}
    });
*/
    jMenuFile.add(jMenuFileExit);
    jMenuEdit.add(jMenuEditFind);
    jMenuHelp.add(jMenuHelpAbout);

    
    jMenuView.add(jMenuViewTrap);
    jMenuView.add(jMenuViewFilters);
    jMenuView.add(jMenuViewScan);
    jMenuView.add(jMenuViewOptions);
	jMenuView.addSeparator();
    jMenuView.add(jMenuViewImage);

	jMenuScan.add(jMenuScanSelected);	
    jMenuScan.add(jMenuScanAll);
	if (Global.isST) {
    	jMenuScan.add(jMenuScanStress);
    }

    jMenuScan.add(jMenuScanStop);
    jMenuScan.addSeparator();
    jMenuScan.add(jMenuScanSkipNode);
    jMenuScan.add(jMenuScanDeleteTree);

	jMenuReport.add(jMenuReportScan);
    
	if (Global.isDumpLog){
		jMenuSession.add(jMenuSessionDump);
		jMenuSession.add(jMenuSessionDumpFile);
		jMenuSession.addSeparator();
		jMenuSession.add(jMenuSessionDumpClearAll);
		jMenuSession.addSeparator();
		jMenuSession.add(jMenuSessionDumpClear);

	}
//    jMenuTools.addSeparator();
    jMenuTools.add(jMenuToolsEnableCert);
    jMenuTools.add(jMenuToolsDisableCert);
	jMenuTools.addSeparator();
    jMenuTools.add(jMenuToolsEncode);
  jMenuTools.addSeparator();
    jMenuTools.add(jMenuToolsSpider);
	jMenuTools.add(jMenuToolsSendHTTP);

//    jMenuTools.add(jMenuToolsSpiderStop);

    this.add(jMenuFile);
    this.add(jMenuEdit);
    this.add(jMenuView);
    this.add(jMenuScan);
    if (Global.isReportEnabled) {
    	this.add(jMenuReport);
    }
	this.add(jMenuSession);
    this.add(jMenuTools);
    this.add(jMenuHelp);
    frame.setJMenuBar(this);
    
  }

  private void jMenuSessionDumpFile_actionPerformed(ActionEvent e) {
	OpenFileDialog d = new OpenFileDialog();
	Util.centreChild(frame, d);		
	d.show();

  }
  public void jMenuSessionDump_actionPerformed(ActionEvent e) {
//	Global.dumpAnalyzer.setCurSession(false);
//	Global.dumpAnalyzer.getDump().setDumpPrefix("session_1072152471015");
	Global.dumpAnalyzer.setCurSession(true);
	Global.dumpAnalyzer.setTitle("Current Session");
	Global.dumpAnalyzer.show();

//	if (Global.dumpAnalyzer.openFile()){
//		Global.dumpAnalyzer.test();
//	}
//	ScannerOffline s = new ScannerOffline();
//	s.startScan(new ParsedEntity()); 
  	
  }
  
  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  //Edit | Find action performed
  public void jMenuEditFind_actionPerformed(ActionEvent e) {
	Global.findDialog = new FindDialog(Global.parosFrame, false);
  	Dialog dialog = Global.findDialog;
	Util.centreChild(Global.parosFrame, dialog);
	/*
    Dimension frmSize = Global.parosFrame.getSize();
    Dimension dlgSize = dlg.getPreferredSize();
    Point loc = Global.parosFrame.getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.pack();

	*/
    dialog.show();

  }


  //View | Trap action performed
  public void jMenuView_actionPerformed(ActionEvent e) {

	Component c = (Component)e.getSource();
        if (c instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)c;
            String label = mi.getText();
            ((ParosFrame)frame).showPanel(ParosFrame.RIGHT_PANE, label);            
        }
    

  }

  	public void jMenuViewImage_actionPerformed(ActionEvent e) {
  		Global.isViewImage = !Global.isViewImage;
  		jMenuViewImage.setState(Global.isViewImage);
  	}

  // Tools | enable cert action performed
	public void jMenuToolsEnableCert_actionPerformed(ActionEvent e) {
		Util.showMessageDialog("Press OK to start choosing client certificate file (PKCS#12).");
	
		JFileChooser chooser = new JFileChooser();
	    int rc = chooser.showOpenDialog(Global.parosFrame);
	    if(rc == JFileChooser.APPROVE_OPTION) {
			try {
	    		File keyFile = chooser.getSelectedFile();
	    		if (keyFile == null) {
	    			return;
	    		}
	    		
	    		JPasswordField pwd = new JPasswordField("");
	    		String label = "Please input passphrase for the PKCS#12 certificate:"; 
	    		Object[] objArray = {label, pwd};
	    		JOptionPane pane = new JOptionPane(objArray, JOptionPane.QUESTION_MESSAGE, JOptionPane.OK_CANCEL_OPTION);
	    		JDialog dialog = pane.createDialog(Global.parosFrame, Global.APP_TITLE);
				dialog.show();
				int result = ((Integer) pane.getValue()).intValue();
				if (result != JOptionPane.OK_OPTION) {
					return;
				}
				char[] passPhrase = pwd.getPassword();
				if (passPhrase == null) {
					return;
				}
				
				Global.ssl.setClientCert(keyFile, passPhrase);
				// clean up passphrase asap
				for (int i=0; i<passPhrase.length; i++) {
					passPhrase[i] = ' ';
				}
				jMenuToolsDisableCert.setEnabled(true);
				Global.isUseClientCert = true;
			} catch (Exception ex) {
				Util.showMessageDialog("Error reading PKCS#12 certificate.  Please use correct passphrase \r\nand use certificate exported from Netscape.");
				ex.printStackTrace();
			}

	    }
  	}

	public void jMenuToolsDisableCert_actionPerformed(ActionEvent e) {	
		jMenuToolsDisableCert.setEnabled(false);
		Global.isUseClientCert = false;
  	}


  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    MainFrame_AboutBox dlg = new MainFrame_AboutBox(frame, true);
	Util.centreChild(frame, dlg);
	dlg.pack();
    dlg.show();
  }

	public void setMenuScanSkipValue(ParsedEntity entity, JCheckBoxMenuItem item) {
		if (entity == null) {
        	Util.showMessageDialog("Please select a site or URL.");
			return;
		}
		
		if (entity.mState == ParsedEntity.DEFAULT) {
			entity.mState = ParsedEntity.DO_NOT_SCAN;
		} else {
			entity.mState = ParsedEntity.DEFAULT;
		}
		
		item.setState(entity.mState == ParsedEntity.DO_NOT_SCAN);
	}
	 
	public void setMenuScanSkipDisplay(ParsedEntity entity, JCheckBoxMenuItem item) {
		item.setState(entity.mState == ParsedEntity.DO_NOT_SCAN);
	}

	public void setMenuScanSkipDisplay(ParsedEntity entity) {
		jMenuScanSkipNode.setState(entity.mState == ParsedEntity.DO_NOT_SCAN);
	}

	public void scanAll() {
		scan(Global.treePanel.getRoot());
	}

	public void scan(ParsedEntity entity) {
       	Global.scanner.startScan(entity);
    }
    
    public void scanStress(ParsedEntity entity) {
    	
   		JTextField txtCount = new JTextField("10");
   		String label = "Please enter repeat count for the ST (adjust optimal threads):"; 
   		Object[] objArray = {label, txtCount};
		JOptionPane pane = new JOptionPane(objArray, JOptionPane.QUESTION_MESSAGE, JOptionPane.OK_CANCEL_OPTION);
		JDialog dialog = pane.createDialog(Global.parosFrame, Global.APP_TITLE);
		dialog.show();
		int result = ((Integer) pane.getValue()).intValue();
		if (result != JOptionPane.OK_OPTION) {
			return;
		}

		try {
			int count = Integer.parseInt(txtCount.getText());
			ScannerStress scanner = new ScannerStress();
			scanner.setCount(count);
			scanner.startScan(entity);
		} catch (Exception e) {
			e.printStackTrace();
		}
	}
	

}