/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.ui;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JSplitPane;
import javax.swing.UIManager;

public class ParosSplitPane extends JSplitPane{
	private JSplitPane jSplitPane5 = new JSplitPane();
	private JLabel jLabel1 = new JLabel();
  	private JLabel jLabel2 = new JLabel();
  private ImageIcon image4;
  private ImageIcon image5;
  private int minHeight = 100;
  private Color bcolor = new Color(0,4,196);

	public ParosSplitPane(){
		super();
/*
    image4 = new ImageIcon(paros.Frame2.class.getResource("header3.gif"));
    image5 = new ImageIcon(paros.Frame2.class.getResource("body3.gif"));
*/
	try {
	  UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	}
	catch(Exception e) {
	  e.printStackTrace();
	}
    image4 = new ImageIcon("header3.gif");
    image5 = new ImageIcon("body3.gif");
    jLabel1.setBackground(bcolor);
    jLabel1.setIcon(image4);
    jLabel2.setBackground(bcolor);
    jLabel2.setIcon(image5);
	    jSplitPane5.setDividerSize(3);
	    jSplitPane5.setOrientation(JSplitPane.VERTICAL_SPLIT);
	    jSplitPane5.setBackground(bcolor);
	    jSplitPane5.setMaximumSize(new Dimension(0, 0));
	    jSplitPane5.setMinimumSize(new Dimension(0, 0));
	    jSplitPane5.add(jLabel1, JSplitPane.LEFT);
	    jSplitPane5.add(jLabel2, JSplitPane.RIGHT);
	    jSplitPane5.setEnabled(false);
    	setDividerLocation(200);

	}

	ParosSplitPane(int minH){
		this();
		minHeight = minH;
	}


	public void setDividerLocation(int location){
		if (this.getSize().height - location < minHeight)
			location = this.getSize().height - minHeight;
		if (location < minHeight)
			location = minHeight;
		super.setDividerLocation(location);
		jSplitPane5.setDividerLocation(this.getDividerLocation());
	}

	public JSplitPane getJSplitPaneHeader(){
		return jSplitPane5;
	}

	public void resetHeaderIcon(){
//	    jSplitPane5.add(jLabel1, JSplitPane.LEFT);
	    //jSplitPane5.add(jLabel2, JSplitPane.RIGHT);
	    jSplitPane5.repaint();

	}


}

