/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package com.proofsecure.paros.ui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.Component;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;

import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.JFrame;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.ManualTester;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.ParsedFolder;
import com.proofsecure.paros.scan.ParsedURL;
import com.proofsecure.paros.scan.ScannerOneRequest;
import com.proofsecure.paros.util.Util;


public class PopupPanel extends JPanel {
  JPopupMenu popup = new JPopupMenu ();
  JComponent control = null;
//      JMenuItem item;
    JMenuItem item2;
		JMenuItem jMenuScanSelected ;
	JMenuItem jMenuResend;
	JMenuItem jMenuScanDeleteTree;		
  JMenuItem jMenuEditFind;
	
  public JPopupMenu getPopupMenu(){
  	return popup;
  }

  public PopupPanel(JComponent c) {
  	this();
  	control = c;
  	if (c instanceof JTree){
  		popup.remove (jMenuEditFind);
		popup.remove(jMenuResend);
//  		popup.remove(item);
  	}
  	else if (c instanceof JTextArea){
		popup.remove(jMenuResend);
  		popup.remove(jMenuScanSelected);
  		popup.remove(jMenuScanDeleteTree);
  	}
	else if (c instanceof JList){
//		popup.remove(jMenuScanSelected);
		popup.remove(jMenuScanDeleteTree);
		popup.remove (jMenuEditFind);
	}
  }


  public PopupPanel() {
	jMenuResend = new JMenuItem ("Re-send");		
	jMenuResend.addActionListener(new ActionListener() {
		public void actionPerformed(ActionEvent e) {
			if (control instanceof JList){
				JList list = (JList)control;
				if (list.getSelectedValue()==null){
					Util.showMessageDialog("Please select an item first");
					return;
				}
		
				String selected = list.getSelectedValue().toString();	
				selected = selected.substring(0,selected.indexOf(":"));
				Vector v = Global.dumpAnalyzer.searchRequest(selected);
					if (v!=null && v.size()>=3){
						try {
							boolean httpsFlag =(v.get(2).toString().equals("https")?true:false);
							HttpRequestHeader header = new HttpRequestHeader(v.get(0).toString());
							header.setSecure(httpsFlag);														
							String domain="";
							domain = (header.getSecure()?"https://":"http://") +header.getHostName(); 
							ManualTester tester = new ManualTester();
							tester.initValue(v.get(0).toString(),v.get(1).toString(),httpsFlag, domain,header.getHostPort()); 
							tester.show();								 

						} catch (HttpMalformedHeaderException e1) {
							// TODO Auto-generated catch block
							System.out.println(e1.getMessage());
						} catch (Exception e1) {
							// TODO Auto-generated catch block
							System.out.println(e1.getMessage());
						}
					}
	      			
			}
		}
	});
	

		jMenuScanSelected = new JMenuItem ("Scan Selected Node/Item");
		
//	  jMenuScanSelected.setText("Scan Selected Node");
		jMenuScanSelected.setMnemonic(KeyEvent.VK_S);
	    jMenuScanSelected.addActionListener(new ActionListener() {
	      	public void actionPerformed(ActionEvent e) {
	      		if (control instanceof JTree){
					if (Global.treePanel.getSelectedParsedEntity() != null) {
						Global.scanner.startScan(Global.treePanel.getSelectedParsedEntity());
					} else {
						Util.showMessageDialog("Please select a site or folder.");
					}	      			
	      		}
	      		else if (control instanceof JList){
	      			JList list = (JList)control;
					if (list.getSelectedValue()==null){
						Util.showMessageDialog("Please select a site or folder.");
						return;
					}
		
					String selected = list.getSelectedValue().toString();	
					selected = selected.substring(0,selected.indexOf(":"));
					Vector v = Global.dumpAnalyzer.searchRequest(selected);
						if (v!=null){
							ParsedEntity p = new ParsedEntity();
							try {
								boolean httpsFlag =(v.get(2).toString().equals("https")?true:false);
								HttpRequestHeader header = new HttpRequestHeader(v.get(0).toString());
								header.setSecure(httpsFlag);								 
								p.setEntity(header,new HttpBody(v.get(1).toString()));
								p.setSecure(httpsFlag);
//								p.getRequestHeader().setSecure(httpsFlag);
//								p.setCaption(parsedURL.getURIHostPath().toString());
								p.setCaption("ScannerOneRequest");
								ParsedURL parsedURL = new ParsedURL("", new HttpRequestHeader(v.get(0).toString()),new HttpBody(v.get(1).toString()));
								String	baseUri = parsedURL.getURIHostPath().getScheme() + "://" + parsedURL.getHostName();
								ParsedFolder root	= new ParsedFolder(parsedURL.getHostName(), new URI(baseUri), parsedURL);
								root.setSecure(httpsFlag);
								root.getRequestHeader().setSecure(httpsFlag);
								root.setCaption(parsedURL.getURIHostPath().toString());
								root.add(p);
//								ScannerOneRequest scanner = new ScannerOneRequest();
//								scanner.test(root);

								Thread thread = new ScanThread(root);
								thread.start();
								/*
								Global.scanner.startScan(root);
								*/
							} catch (HttpMalformedHeaderException e1) {
								// TODO Auto-generated catch block
								System.out.println(e1.getMessage());
							} catch (URISyntaxException e1) {
								// TODO Auto-generated catch block
								System.out.println(e1.getMessage());
							} catch (Exception e1) {
								// TODO Auto-generated catch block
								System.out.println(e1.getMessage());
							}
						}
	      			
	      		}
	      	}
	    });

	popup.add(jMenuResend);
    popup.add(jMenuScanSelected);

	jMenuScanDeleteTree = new JMenuItem("Delete Selected Node");
	popup.add(jMenuScanDeleteTree);
	jMenuScanDeleteTree.addActionListener(new ActionListener() {
      	public void actionPerformed(ActionEvent e) {   
    		
        	ParsedEntity entity = null;
        	
        	//entity = Global.treePanel.getSelectedParsedEntity();
        	//Global.treePanel.getTree().removeSelectionPath(Global.treePanel.getTree().getSelectionPath());
        	
        	
        	ParsedEntity parent = null;
        	entity = Global.treePanel.getSelectedParsedEntity();

        	if (entity == null) {
        		Util.showMessageDialog("Please select a site or folder.");
				return;
        	}

			parent = (ParsedEntity) entity.getParent();
			if (parent != null) {
                Global.treePanel.getTreeModel().removeNodeFromParent(entity);
                Global.treePanel.getTree().setModel(Global.treePanel.getTreeModel());
            }
			
       	
		}
    });

//    popup.add (item = new JMenuItem ("Cut"));
//    popup.add (new JMenuItem ("Popup"));
    popup.add (item2 = new JMenuItem ("Clear All"));
//    popup.addSeparator();
//    popup.add (item = new JMenuItem ("Paste"));
//		item = new JMenuItem ("Select All");
/*
        item.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
              if (control instanceof JTextArea){
//              			((JTextArea)control).setEditable(true);
  //            			((JTextArea)control).setCaretPosition(1);
    //          			((JTextArea)control).setDragEnabled(true);
                    ((JTextArea)control).selectAll();                
      //              ((JTextArea)control).repaint();                
                     //((JTextArea)control).select(0,((JTextArea)control).getText().length()); 
              }
            }
        });

    popup.add (item);
*/
        item2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
            	if (control instanceof JTextArea){
            		  ((JTextArea)control).setText("");
            	}
            	else if (control instanceof JTree){
//            		((JTree)control).removeAll();
            		Global.parosFrame.clearTree();

            	}
				else if (control instanceof JList){  // URL list
					Global.dumpLog.resetCurDate();
					Global.dumpAnalyzer.refresh();
					Global.urlLog.clear();
				}
                //mnuFileExitActionPerformed(evt);
//                System.out.println(evt);
            }
        });

    jMenuEditFind = new JMenuItem("Find...");
//    jMenuEditFind.setMnemonic(KeyEvent.VK_F);
//    jMenuEditFind.setAccelerator(KeyStroke.getKeyStroke(KeyEvent.VK_F, KeyEvent.CTRL_MASK));
    jMenuEditFind.addActionListener(new ActionListener()  {
      public void actionPerformed(ActionEvent e) {
      		Component c = control;
      		JFrame parent = null;
      		try {
      			while (c.getParent() != null) {
      				c = c.getParent();
      				if (c instanceof JFrame) {
      					parent = (JFrame) c;
      					break;
      				}
      			}
      		} catch (Exception ex) {
      			ex.printStackTrace();
      			parent = Global.parosFrame;
      		}

			if (parent == null) {
				parent = Global.parosFrame;
			}
			      			
      		Global.findDialog = new FindDialog(parent, false);
			Util.centreChild(parent, Global.findDialog);
			Global.findDialog.show();	      
	    }
    });
	
		popup.add (jMenuEditFind);


    popup.setInvoker (this);
/*
    addMouseListener (new MouseAdapter() {
      public void mousePressed (MouseEvent e) {
        if (e.isPopupTrigger()) {
          popup.show (e.getComponent(),
            e.getX(), e.getY());
//					System.out.println("AA 1");
        }
      }
      public void mouseReleased (MouseEvent e) {
        if (e.isPopupTrigger()) {
          popup.show (e.getComponent(),
            e.getX(), e.getY());
          //  JOptionPane.showInternalMessageDialog(popup, "information2","information2", JOptionPane.INFORMATION_MESSAGE);
//					System.out.println("AA 2");
        }
      }
    });
*/    
  }

  class ScanThread extends Thread {
	  ParsedEntity entity=null;
  	  ScanThread(ParsedEntity p){
  	  	entity = p;
  	  }
	  public void run() {
		  try {
			  ScannerOneRequest scanner = new ScannerOneRequest();
			  scanner.test(entity);
		  } catch (Exception e) {
			  System.out.println(e.getMessage());
		  }
	  }
  }

}
