/*
Paros and its related class files.
Paros is an HTTP/HTTPS proxy for assessing web application security.
Copyright (C) 2003-2004 www.proofsecure.com

This program is free software; you can redistribute it and/or
modify it under the terms of the Clarified Artistic License
as published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
Clarified Artistic License for more details.

You should have received a copy of the Clarified Artistic License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package com.proofsecure.paros.util;

import java.io.IOException;
import java.util.regex.Pattern;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Config implements com.proofsecure.paros.network.ConnectorConfig {

	// constants
	private static final String		PROXY_SERVER			= "ProxyServer";
	private static final String		PORT					= "Port";
	
	private static final String		PROXY_CHAIN				= "ProxyChain";
	private static final String		SCANNER					= "Scanner";

    private static final String[]	PATH_PROXY_IP 			= {PROXY_SERVER, "IP"};
    private static final String[]	PATH_PROXY_PORT			= {PROXY_SERVER, PORT};
    private static final String[]	PATH_PROXY_PORT_SSL		= {PROXY_SERVER, "SSL"};
	private static final String[]	PATH_PROXY_CHAIN_NAME	= {PROXY_CHAIN, "Name"};
	private static final String[]	PATH_PROXY_CHAIN_PORT	= {PROXY_CHAIN, PORT};
	private static final String[]	PATH_PROXY_CHAIN_SKIP	= {PROXY_CHAIN, "Skip"};
	private static final String[]	PATH_PROXY_CHAIN_USER	= {PROXY_CHAIN, "User"};
	private static final String[]	PATH_PROXY_CHAIN_PASSWORD	= {PROXY_CHAIN, "Password"};
	private static final String[]	PATH_SCANNER_THREAD		= {SCANNER, "Thread"};
	
	// xml document processing
	private Document				mDoc		= null;
	private DocumentBuilderFactory	mFactory 	= null;
	private DocumentBuilder 		mBuilder	= null;

	// proxy related
	private Pattern					patternSkip = null;


	public Config() {
		try {
			mFactory = DocumentBuilderFactory.newInstance();
			mFactory.setValidating(false);
			mBuilder	= mFactory.newDocumentBuilder();
			//builder.setErrorHandler(new ErrorHandler() {
			//});
		} catch (ParserConfigurationException e) {
		}
	}
	
	public void read(String fileName) throws SAXException, IOException {
		
		mDoc = mBuilder.parse(fileName);
		processConfig();
	}
	
	public void processConfig() {
		parseProxyChainSkip();
	}
	
	public void main(String[] args) {
	/*
		try {
			Config.read(args[0]);
		} catch (SAXParseException e) {
			e.printStackTrace();
			System.out.println(e.getMessage() + " Line=" + e.getLineNumber() + e.getPublicId());
		} catch (SAXException e) {
		} catch (IOException e) {
		}

		System.out.println("IP = " + getProxyIP());
		System.out.println("Port = " + getProxyPort());
		System.out.println("SSL = " + getProxyPortSSL());
		System.out.println("Use chain = " + isUseProxyChain());
		System.out.println("Chain IP = " + getProxyChainName());
		System.out.println("Chain IP = " + getProxyChainPort());

		System.out.println("Skip = " + isSkipProxyChain(args[1]));
	*/
    }

	private Element getElement(String[] path) {
		NodeList nodes = mDoc.getElementsByTagName(path[0]);
		Element ele = (Element) nodes.item(0);
		for (int i=1; i<path.length; i++) {
			nodes = ele.getElementsByTagName(path[i]);
			ele = (Element) nodes.item(0);
		}
		return ele;
	}


			
	/**
	Get the text in text node from the element.
	@param	element	Element to get text from
	@return	Text in the text node under the element
	*/
	private String getText(Element element) {
		for (int i=0; i<element.getChildNodes().getLength(); i++) {
			Node node = element.getChildNodes().item(i);
			if (node.getNodeType() == Node.TEXT_NODE) {
				return node.getNodeValue();
			}
		}
		return "";
	}
	
	/**
	Set the text in text node of a element.
	@param	element	Element to be set
	@param	text	Text to be set
	*/
	private void setText(Element element, String text) {
		for (int i=0; i<element.getChildNodes().getLength(); i++) {
			Node node = element.getChildNodes().item(i);
			if (node.getNodeType() == Node.TEXT_NODE) {
				node.setNodeValue(text);
				return;
			}
		}
	}
    		
	public String getProxyIP() {
		String ip = "127.0.0.1";
		try {
			ip = getText(getElement(PATH_PROXY_IP));
		} catch (Exception e) {
		}
		return ip;
	}

	public int getProxyPort() {
		int port = 8080;
		try {
			port = Integer.parseInt(getText(getElement(PATH_PROXY_PORT)));
		} catch (Exception e) {
		}
		return port;
	}

	public int getProxyPortSSL() {
		int port = 8443;
		try {
			port = Integer.parseInt(getText(getElement(PATH_PROXY_PORT_SSL)));
		} catch (Exception e) {
		}
		return port;
	}

	/**
	Check if via proxy chain.
	@return	True = use proxy chain
	*/
	public boolean isUseProxyChain() {
		boolean result = false;
		try {
			if (!getText(getElement(PATH_PROXY_CHAIN_NAME)).trim().equals("")) {
				result = true;
			}
		} catch (Exception e) {
		}
		return result;
	}
		
	public String getProxyChainName() {
		String ip = "127.0.0.1";
		try {
			ip = getText(getElement(PATH_PROXY_CHAIN_NAME)).trim();
		} catch (Exception e) {
		}
		return ip;
	}
	

	public int getProxyChainPort() {
		int port = 8080;
		try {
			port = Integer.parseInt(getText(getElement(PATH_PROXY_CHAIN_PORT)));
		} catch (Exception e) {
		}
		return port;
	}

	/**
	Check if the given host name is in the proxy chain skip list
	@param	hostName	Host name to be checked.
	*/
	public boolean isSkipProxyChain(String hostName) {
		if (patternSkip == null || hostName == null) {
			return false;
		}
		
		return patternSkip.matcher(hostName).find();
	}

	/**
	Get proxy chain authentication - user.
	@return user name for proxy chain authentication.
	*/
	public String getProxyChainUser() {
		String user = "";
		try {
			user = getText(getElement(PATH_PROXY_CHAIN_USER));
		} catch (Exception e) {
		}
		return user;
	}

	/**
	Get proxy chain authentication - password.
	@return user name for proxy chain password.
	*/
	public String getProxyChainPassword() {
		String pass = "";
		try {
			pass = getText(getElement(PATH_PROXY_CHAIN_PASSWORD));
		} catch (Exception e) {
		}
		return pass;
	}
		
	
	/**
	Check if given host name need to send using proxy.
	@param	hostName	host name to be checked.
	@return	true = need to send via proxy.
	*/
	public boolean useProxy(String hostName) {
		if (!isUseProxyChain() || isSkipProxyChain(hostName)) {
			return false;
		} else {
			return true;
		}
	}

	/**
	Parse the proxy chain skip text string and build the regex pattern.
	*/
	private void parseProxyChainSkip() {
		String skipNames = "";
		patternSkip = null;
		try {
			skipNames = getText(getElement(PATH_PROXY_CHAIN_SKIP)).trim();

		} catch (Exception e) {
		}
		if (skipNames.equals("")) {
			return;
		}
		skipNames = skipNames.replaceAll("\\.", "\\.");
		skipNames = skipNames.replaceAll("\\*","\\.*?").replaceAll("(;+$)|(^;+)", "");
		skipNames = "(" + skipNames.replaceAll(";+", "|") + ")$";
		patternSkip = Pattern.compile(skipNames);
	}
	

	/**
	Number of scanner threads.
	@return number of threads
	*/
	public int getScannerThread() {
		int thread = 5;
		try {
			thread = Integer.parseInt(getText(getElement(PATH_SCANNER_THREAD)));
		} catch (Exception e) {
		}
		return thread;
	}
		
		
		
}

