/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.ProxyHandler;
import com.proofsecure.paros.ProxyPassThruHandler;
import com.proofsecure.paros.ProxyPortForwardHandler;
import com.proofsecure.paros.SSLProxy;
import com.proofsecure.paros.util.Util;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;

public class Proxy
implements Runnable {
    protected static final int PORT_TIME_OUT = 3000;
    protected ServerSocket mProxySock = null;
    protected String mProxyIP = null;
    protected int mProxyPort = 0;
    protected boolean mIsProxyRunning = false;
    protected boolean mIsExit = false;
    Thread myThread = null;

    public Proxy(String proxyIP, int port) {
        this.mProxyIP = proxyIP;
        this.mProxyPort = port;
    }

    public synchronized boolean startServer() {
        if (this.mIsProxyRunning) {
            return false;
        }
        Util.closeServerSocket(this.mProxySock);
        this.mIsProxyRunning = false;
        this.mIsExit = false;
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.setPriority(6);
        this.myThread.start();
        try {
            this.mProxySock = Global.isCmdTunnel ? new ServerSocket(Global.cmdSourcePort, 300, InetAddress.getByName(Global.cmdSourceHost)) : new ServerSocket(this.mProxyPort, 300, InetAddress.getByName(this.mProxyIP));
            this.mProxySock.setSoTimeout(3000);
            this.mIsProxyRunning = true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        Util.writeOutput("Proxy server started.");
        return true;
    }

    public synchronized boolean stopServer() {
        String stopMsg = "Proxy server stopped.";
        if (this instanceof SSLProxy) {
            stopMsg = "SSL proxy server stopped.";
        }
        if (!this.mIsProxyRunning) {
            Util.writeOutput(String.valueOf(stopMsg) + "(already stopped)");
            return true;
        }
        this.mIsProxyRunning = false;
        this.mIsExit = true;
        try {
            this.myThread.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Util.closeServerSocket(this.mProxySock);
        this.mProxySock = null;
        Util.writeOutput(stopMsg);
        return true;
    }

    public void run() {
        Socket clientSock = null;
        ProxyHandler p = null;
        while (!this.mIsExit) {
            try {
                if (this.mIsProxyRunning) {
                    clientSock = this.mProxySock.accept();
                    p = Global.isCmdTunnel ? (Global.isCmdSSLout ? new ProxyPassThruHandler() : new ProxyPortForwardHandler()) : new ProxyHandler();
                    p.start(clientSock);
                    continue;
                }
                Util.sleep(100);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

