/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.filter;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.filter.AbstractFilter;
import com.proofsecure.paros.filter.PDialog;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;

public class CookieDetectFilter
extends AbstractFilter {
    private Pattern pattern = Pattern.compile("^ *Set-[Cc]ookie *: *([^\\r\\n]*)\\r\\n", 10);
    private Matcher matcher = null;
    private Vector result = null;

    public CookieDetectFilter() {
        this.dialog = new PDialog("CookieDetect");
    }

    public void filterResponse(HttpRequestHeader reqHeader, HttpResponseHeader resHeader, HttpBody body) {
        if (resHeader != null && resHeader.getHeader("Set-cookie") != null) {
            String content = resHeader.toString();
            this.matcher = this.pattern.matcher(content);
            this.result = new Vector();
            while (this.matcher.find()) {
                String cookie = this.matcher.group(1);
                if (cookie == null) continue;
                Global.parosFrame.toFront();
                String text = JOptionPane.showInputDialog(Global.parosFrame, "Accept the following cookie (Ok=Accept, Cancel=Reject)?", cookie);
                if (text != null && !text.equals("")) {
                    resHeader.setHeader("Set-cookie", null);
                    this.result.add(text);
                    continue;
                }
                if (text != null) continue;
                resHeader.setHeader("Set-cookie", null);
            }
            if (this.result.size() > 0) {
                content = this.matcher.replaceAll("");
                int i = 0;
                while (i < this.result.size()) {
                    content = String.valueOf(content) + "Set-Cookie: " + this.result.get(i).toString() + "\r\n";
                    ++i;
                }
                try {
                    resHeader.setMessage(content);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
            this.result.clear();
        }
    }

    public String usage() {
        return "Detect and alert 'Set-cookie' attempt in HTTP response for modification.";
    }
}

