/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.filter;

import com.proofsecure.paros.filter.AbstractFilter;
import com.proofsecure.paros.filter.PDialog;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogPostQuery
extends AbstractFilter {
    private final String logFile = "post.xls";
    private final String delim = "\t";
    private final int MAX_FORM_FIELDS = 80;
    private File selFile;
    private Pattern pSeparator = Pattern.compile("([^=&]+)[=]([^=&]*)");
    private Matcher matcher2;

    public LogPostQuery() {
        this.selFile = new File("post.xls");
        this.dialog = new PDialog("LogPostQuery");
    }

    public void filterRequest(HttpRequestHeader reqHeader, HttpBody body) {
        if (reqHeader != null && reqHeader.isText() && reqHeader.getMethod().equalsIgnoreCase("POST")) {
            String uri = reqHeader.getURIHostPathQuery();
            String firstline = String.valueOf(reqHeader.getHostName()) + "\t" + reqHeader.getHostPort() + "\t" + uri;
            Hashtable param = this.parseParameter(body.toString());
            this.writeLogFile(firstline, param);
        }
    }

    public String usage() {
        return "Record all POST query into file post.xls";
    }

    private synchronized void writeLogFile(String line, Hashtable param) {
        try {
            BufferedWriter out = new BufferedWriter(new FileWriter(this.selFile, true));
            out.write(String.valueOf(line) + "\r\n");
            Enumeration v = param.keys();
            while (v.hasMoreElements()) {
                String name = (String)v.nextElement();
                String value = (String)param.get(name);
                out.write("\t" + name + "\t" + value + "\r\n");
            }
            out.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Hashtable parseParameter(String param) {
        Hashtable<String, String> table = new Hashtable<String, String>();
        try {
            this.matcher2 = this.pSeparator.matcher(param);
            while (this.matcher2.find()) {
                table.put(this.matcher2.group(1), this.matcher2.group(2));
            }
        }
        catch (Exception e) {
            System.out.println("Error: " + e.getMessage());
        }
        return table;
    }
}

