/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.log;

import com.proofsecure.paros.log.Dump;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.Charset;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.DefaultListModel;

public class DumpAnalyzer {
    protected DefaultListModel model = new DefaultListModel();
    protected boolean isCurSession = true;
    protected Dump dump = null;
    protected String REQUEST_FILE = Dump.REQUEST_FILE;
    protected String RESPONSE_FILE = Dump.RESPONSE_FILE;
    protected BufferedReader requestFeed = null;
    protected BufferedReader responseFeed = null;
    protected Pattern patternHeader = Pattern.compile(String.valueOf(Dump.SEPARATOR_LEFT) + "\\d+[-]((\\d+)[.](\\d+))" + Dump.SEPARATOR_RIGHT);

    DumpAnalyzer(Dump d) {
        this.dump = d;
    }

    public boolean openFile() {
        try {
            File selFile = this.dump.getFile(this.REQUEST_FILE);
            File selFile2 = this.dump.getFile(this.RESPONSE_FILE);
            if (!selFile.exists() || !selFile2.exists()) {
                return false;
            }
            this.requestFeed = new BufferedReader(new FileReader(selFile));
            this.responseFeed = new BufferedReader(new FileReader(selFile2));
            return true;
        }
        catch (IOException ae) {
            this.requestFeed = null;
            this.responseFeed = null;
            System.out.println("Dump files not found.");
            return false;
        }
    }

    protected long stringToDigit(String s) {
        return Long.parseLong(s);
    }

    public static void main(String[] args) {
        DumpAnalyzer da = new DumpAnalyzer(new Dump());
        da.openFile();
    }

    private Vector searchIndex(String selected, String type) {
        String separator = "\t";
        Matcher matcher = null;
        Pattern patternLine = Pattern.compile(String.valueOf(type.substring(0, 3)) + separator + selected + separator + "(\\d+)" + separator + "(\\d+)" + separator + "(\\d+)" + separator + "(\\d+)" + "(" + separator + "(\\w+)" + ")*" + "\r\n");
        CharSequence cs = null;
        CharSequence cs2 = null;
        try {
            cs = this.fromFile(this.dump.getFilePath(Dump.INDEX_FILE));
        }
        catch (IOException e) {
            return null;
        }
        matcher = patternLine.matcher(cs);
        if (matcher.find()) {
            long start = Long.parseLong(matcher.group(2));
            long middle = Long.parseLong(matcher.group(3));
            long end = Long.parseLong(matcher.group(4));
            String httpsFlag = "http";
            if (matcher.groupCount() > 5 && matcher.group(6).startsWith(httpsFlag)) {
                httpsFlag = matcher.group(6);
            }
            Vector<CharSequence> result = new Vector<CharSequence>(3);
            try {
                cs2 = this.fromFile(this.dump.getFilePath(type), start, end - start);
                result.add(cs2.subSequence(0, (int)(middle - start)));
                if (end - middle > 1000000L) {
                    result.add("Body content too large (maybe a binary file). Cannot be displayed.");
                } else {
                    result.add(cs2.subSequence((int)(middle - start), (int)(end - start)).toString());
                }
            }
            catch (IOException e1) {
                System.out.println(e1.getMessage());
                return null;
            }
            cs = null;
            cs2 = null;
            result.add(httpsFlag);
            return result;
        }
        return null;
    }

    public Vector searchRequest(String selected) {
        Vector qresult;
        if (selected.indexOf(".") == -1) {
            selected = String.valueOf(selected) + "." + this.dump.getCurDate();
        }
        if ((qresult = this.searchIndex(selected, this.REQUEST_FILE)) != null) {
            return qresult;
        }
        String line = "";
        Pattern patternLine = Pattern.compile(String.valueOf(Dump.SEPARATOR_LEFT) + "\\d+[-]" + selected + Dump.SEPARATOR_RIGHT);
        Matcher matcher = null;
        Matcher matcher2 = null;
        CharSequence cs = null;
        try {
            cs = this.fromFile(this.dump.getFilePath(Dump.REQUEST_FILE));
            matcher = patternLine.matcher(cs);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            return null;
        }
        if (matcher.find()) {
            int startRes = matcher.end();
            matcher2 = this.patternHeader.matcher(cs);
            int endRes = matcher2.find(startRes) ? matcher2.start() : cs.length();
            String request = cs.subSequence(startRes + 2, endRes).toString();
            String[] tResult = request.split("\r\n\r\n");
            Vector<String> result = new Vector<String>(2);
            if (tResult.length < 2) {
                result.add(String.valueOf(tResult[0]) + "\r\n");
                result.add("");
            } else {
                result.add(String.valueOf(tResult[0]) + "\r\n");
                result.add(tResult[1]);
            }
            cs = null;
            return result;
        }
        return null;
    }

    public String searchRequestFirstLine(String selected) {
        Vector result = this.searchRequest(selected);
        if (result != null) {
            String header = result.get(0).toString();
            return header.substring(0, header.indexOf("\r\n"));
        }
        return null;
    }

    public String searchRequestPattern(String id, String pattern, int groupID) {
        Pattern p;
        Matcher matcher;
        Vector result = this.searchRequest(id);
        if (result != null && (matcher = (p = Pattern.compile(pattern)).matcher(result.get(0).toString())).find()) {
            return matcher.group(groupID);
        }
        return null;
    }

    private String searchContentPattern(String content, String pattern, int groupID) {
        Pattern p;
        Matcher matcher;
        if (content != null && (matcher = (p = Pattern.compile(pattern)).matcher(content)).find()) {
            return matcher.group(groupID);
        }
        return null;
    }

    private Vector searchAllContentPattern(String content, String pattern, int groupID) {
        if (content != null) {
            Vector<String> result = new Vector<String>();
            Pattern p = Pattern.compile(pattern);
            Matcher matcher = p.matcher(content);
            while (matcher.find() && result.indexOf(matcher.group(groupID)) == -1) {
                result.add(matcher.group(groupID));
            }
            return result;
        }
        return null;
    }

    public Vector searchResponse(String selected) {
        Vector qresult;
        if (selected.indexOf(".") == -1) {
            selected = String.valueOf(selected) + "." + this.dump.getCurDate();
        }
        if ((qresult = this.searchIndex(selected, this.RESPONSE_FILE)) != null) {
            return qresult;
        }
        String line = "";
        Pattern patternLine = Pattern.compile(String.valueOf(Dump.SEPARATOR_LEFT) + "\\d+[-]" + selected + Dump.SEPARATOR_RIGHT);
        Matcher matcher = null;
        Matcher matcher2 = null;
        CharSequence cs = null;
        try {
            cs = this.fromFile(this.dump.getFilePath(Dump.RESPONSE_FILE));
            matcher = patternLine.matcher(cs);
        }
        catch (IOException e1) {
            System.out.println(e1.getMessage());
            return null;
        }
        if (matcher.find()) {
            int startRes = matcher.end();
            matcher2 = this.patternHeader.matcher(cs);
            int endRes = matcher2.find(startRes) ? matcher2.start() : cs.length();
            String response = cs.subSequence(startRes + 2, endRes).toString();
            Vector<String> result = new Vector<String>(2);
            int split = response.indexOf("\r\n\r\n");
            if (split == -1) {
                result.add(String.valueOf(response) + "\r\n");
                result.add("");
            } else {
                result.add(String.valueOf(response.substring(0, split)) + "\r\n");
                if (response.substring(split + 4).length() > 1000000) {
                    result.add("Body content too large (maybe a binary file). Cannot be displayed.");
                } else {
                    result.add(response.substring(split + 4));
                }
            }
            cs = null;
            return result;
        }
        return null;
    }

    public CharSequence fromFile(String filename) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, 0L, (int)fc.size());
        CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
        return cbuf;
    }

    public CharSequence fromFile(String filename, long start, long size) throws IOException {
        FileInputStream fis = new FileInputStream(filename);
        FileChannel fc = fis.getChannel();
        MappedByteBuffer bbuf = fc.map(FileChannel.MapMode.READ_ONLY, start, size);
        CharBuffer cbuf = Charset.forName("8859_1").newDecoder().decode(bbuf);
        return cbuf;
    }

    protected void readList(Pattern pattern, String searchPlace) {
        String line = "";
        Matcher matcher = null;
        Matcher matcher3 = null;
        CharSequence cs = null;
        CharSequence cs2 = null;
        Pattern patternHeaderLine = null;
        String curDateTime = Long.toString(this.dump.getCurDate());
        patternHeaderLine = this.isCurSession ? Pattern.compile(String.valueOf(searchPlace.substring(0, 3)) + "\\t((\\d+)[.](" + curDateTime + "))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)") : Pattern.compile(String.valueOf(searchPlace.substring(0, 3)) + "\\t((\\d+)[.](\\d+))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)");
        this.model.clear();
        String fromFile = searchPlace.equals("request") ? Dump.REQUEST_FILE : Dump.RESPONSE_FILE;
        try {
            cs = this.fromFile(this.dump.getFilePath(Dump.INDEX_FILE));
            matcher = patternHeaderLine.matcher(cs);
            cs2 = this.fromFile(this.dump.getFilePath(fromFile));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String id = null;
        String website = null;
        String firstLine = null;
        Matcher matcher4 = null;
        String index = null;
        Pattern p1 = null;
        while (matcher.find()) {
            int index3;
            id = matcher.group(1);
            index = matcher.group(2);
            if (!searchPlace.equals("request") && pattern.pattern().equals("")) {
                firstLine = null;
                website = null;
                Vector v = this.searchRequest(id);
                if (v != null) {
                    firstLine = v.get(0).toString();
                    website = this.searchContentPattern(firstLine, "Host: (.*)\r\n", 1);
                    int t = -1;
                    t = firstLine.indexOf("\r\n");
                    if (t != -1) {
                        firstLine = firstLine.substring(0, t);
                    }
                }
                if (firstLine == null || website == null) continue;
                if (this.isCurSession) {
                    this.model.addElement(String.valueOf(index) + "---" + website + "---" + firstLine);
                    continue;
                }
                this.model.addElement(String.valueOf(id) + "---" + website + "---" + firstLine);
                continue;
            }
            int index2 = Integer.parseInt(matcher.group(4));
            String content = cs2.subSequence(index2, index3 = Integer.parseInt(matcher.group(5))).toString();
            matcher3 = pattern.matcher(content);
            if (!matcher3.find()) continue;
            firstLine = null;
            website = null;
            if (searchPlace.equals("request")) {
                firstLine = content.substring(0, content.indexOf("\r\n"));
                p1 = Pattern.compile("Host: (.*)\r\n");
                matcher4 = p1.matcher(content);
                if (matcher4.find()) {
                    website = matcher4.group(1);
                }
            } else {
                Vector v = this.searchRequest(id);
                if (v != null) {
                    firstLine = v.get(0).toString();
                    website = this.searchContentPattern(firstLine, "Host: (.*)\r\n", 1);
                    int t = -1;
                    t = firstLine.indexOf("\r\n");
                    if (t != -1) {
                        firstLine = firstLine.substring(0, t);
                    }
                }
            }
            if (firstLine == null || website == null) continue;
            if (this.isCurSession) {
                this.model.addElement(String.valueOf(index) + "---" + website + "---" + firstLine);
                continue;
            }
            this.model.addElement(String.valueOf(id) + "---" + website + "---" + firstLine);
        }
    }

    protected Vector listPattern(Pattern pattern, String searchPlace) {
        String line = "";
        Matcher matcher = null;
        Object matcher3 = null;
        CharSequence cs = null;
        CharSequence cs2 = null;
        Pattern patternHeaderLine = null;
        String curDateTime = Long.toString(this.dump.getCurDate());
        if (pattern.pattern().equals("")) {
            return null;
        }
        Vector result = new Vector();
        patternHeaderLine = this.isCurSession ? Pattern.compile(String.valueOf(searchPlace.substring(0, 3)) + "\\t((\\d+)[.](" + curDateTime + "))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)") : Pattern.compile(String.valueOf(searchPlace.substring(0, 3)) + "\\t((\\d+)[.](\\d+))\\t\\d+\\t(\\d+)\\t\\d+\\t(\\d+)");
        String fromFile = searchPlace.equals("request") ? Dump.REQUEST_FILE : Dump.RESPONSE_FILE;
        try {
            cs = this.fromFile(this.dump.getFilePath(Dump.INDEX_FILE));
            matcher = patternHeaderLine.matcher(cs);
            cs2 = this.fromFile(this.dump.getFilePath(fromFile));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String id = null;
        Object matcher4 = null;
        String index = null;
        Object p1 = null;
        while (matcher.find()) {
            int index3;
            id = matcher.group(1);
            index = matcher.group(2);
            int index2 = Integer.parseInt(matcher.group(4));
            String content = cs2.subSequence(index2, index3 = Integer.parseInt(matcher.group(5))).toString();
            Vector tmpRes = this.searchAllContentPattern(content, pattern.pattern(), 0);
            if (tmpRes == null) continue;
            int q = 0;
            while (q < tmpRes.size()) {
                if (result.indexOf(tmpRes.get(q)) == -1) {
                    result.add(tmpRes.get(q));
                }
                ++q;
            }
        }
        if (result.size() < 1) {
            result = null;
        }
        return result;
    }

    protected Vector listPatternOld(Pattern pattern, String searchPlace, boolean isStop) {
        String line = "";
        Object matcher = null;
        Object matcher3 = null;
        Object cs = null;
        CharSequence cs2 = null;
        Object patternHeaderLine = null;
        String curDateTime = Long.toString(this.dump.getCurDate());
        if (pattern.pattern().equals("")) {
            return null;
        }
        Vector result = new Vector();
        String fromFile = searchPlace.equals("request") ? Dump.REQUEST_FILE : Dump.RESPONSE_FILE;
        try {
            cs2 = this.fromFile(this.dump.getFilePath(fromFile));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        String content = cs2.toString();
        result = this.searchAllContentPattern(content, pattern.pattern(), 0);
        if (result != null && result.size() < 1) {
            result = null;
        }
        return result;
    }

    protected void readList2(Pattern pattern, String searchPlace) {
        String line = "";
        Matcher matcher = null;
        Object matcher2 = null;
        Matcher matcher3 = null;
        CharSequence cs = null;
        Pattern patternHeaderLine = null;
        patternHeaderLine = this.isCurSession ? this.getDump().getCurrentHeaderPattern() : this.getDump().getHeaderPattern("\\d+");
        this.model.clear();
        String fromFile = searchPlace.equals("request") ? Dump.REQUEST_FILE : Dump.RESPONSE_FILE;
        try {
            cs = this.fromFile(this.dump.getFilePath(fromFile));
            matcher = patternHeaderLine.matcher(cs);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int startRes = 0;
        int endRes = 0;
        String id = null;
        String website = null;
        String firstLine = null;
        Matcher matcher4 = null;
        String index = null;
        String index2 = null;
        Pattern p1 = null;
        String curDateTime = Long.toString(this.dump.getCurDate());
        while (matcher.find(startRes)) {
            startRes = matcher.end();
            id = matcher.group(1);
            index = matcher.group(2);
            index2 = matcher.group(3);
            endRes = matcher.find(startRes) ? matcher.start() : cs.length();
            String content = cs.subSequence(startRes + 2, endRes).toString();
            matcher3 = pattern.matcher(content);
            if (!matcher3.find()) continue;
            firstLine = null;
            website = null;
            if (searchPlace.equals("request")) {
                firstLine = content.substring(0, content.indexOf("\r\n"));
                p1 = Pattern.compile("Host: (.*)\r\n");
                matcher4 = p1.matcher(content);
                if (matcher4.find()) {
                    website = matcher4.group(1);
                }
            } else {
                firstLine = this.searchRequestFirstLine(id);
                website = this.searchRequestPattern(id, "Host: (.*)\r\n", 1);
            }
            if (firstLine == null || website == null) continue;
            if (curDateTime.equals(index2)) {
                this.model.addElement(String.valueOf(index) + "---" + website + "---" + firstLine);
                continue;
            }
            this.model.addElement(String.valueOf(id) + "---" + website + "---" + firstLine);
        }
    }

    public boolean isCurSession() {
        return this.isCurSession;
    }

    public void setCurSession(boolean b) {
        this.isCurSession = b;
    }

    public BufferedReader getRequestFeed() {
        return this.requestFeed;
    }

    public BufferedReader getResponseFeed() {
        return this.responseFeed;
    }

    public Pattern getPatternHeader() {
        return this.patternHeader;
    }

    public Dump getDump() {
        return this.dump;
    }
}

