/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.network;

import com.proofsecure.paros.network.HttpHeader;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpResponseHeader
extends HttpHeader {
    public static final String HTTP = "HTTP";
    public static final String HTTP_CLIENT_BAD_REQUEST = "HTTP/1.0 400 Bad request\r\n\r\n";
    private static final String _CONTENT_TYPE_IMAGE = "image";
    private static final String _CONTENT_TYPE_TEXT = "text";
    private static final String _CONTENT_TYPE_HTML = "html";
    static final Pattern patternStatusLine = Pattern.compile("(HTTP/\\d+\\.\\d+) +(\\d{3}) *([^\\x00-\\x1f\\r\\n]*)", 2);
    private static final Pattern patternPartialStatusLine = Pattern.compile("\\A *(HTTP/\\d+\\.\\d+)", 2);
    private String mStatusCodeString = "";
    private int mStatusCode = 0;
    private String mReasonPhrase = "";
    private HttpRequestHeader requestHeader = null;
    private static final String PROXY_CONNECT_HTTP_200 = "HTTP/1.0 200 Connection established\r\n\r\n";

    public HttpResponseHeader() {
    }

    public void setHttpRequestHeader(HttpRequestHeader h) {
        this.requestHeader = h;
    }

    public HttpRequestHeader getHttpRequestHeader() {
        return this.requestHeader;
    }

    public HttpResponseHeader(String data) throws HttpMalformedHeaderException {
        this.setMessage(data);
    }

    public void setMessage(String data) throws HttpMalformedHeaderException {
        super.setMessage(data);
        try {
            if (!this.parse()) {
                this.mMalformedHeader = true;
            }
        }
        catch (Exception e) {
            this.mMalformedHeader = true;
        }
        if (this.mMalformedHeader) {
            throw new HttpMalformedHeaderException();
        }
    }

    public void setVersion(String version) {
        this.mVersion = version;
        this.mStartLine = String.valueOf(this.mVersion) + " " + this.getStatusCode();
        if (!this.getReasonPhrase().equals("")) {
            this.mStartLine = String.valueOf(this.mStartLine) + " " + this.getReasonPhrase();
        }
    }

    public int getStatusCode() {
        return this.mStatusCode;
    }

    public String getReasonPhrase() {
        return this.mReasonPhrase;
    }

    public boolean parse() throws Exception {
        Matcher matcher = patternStatusLine.matcher(this.mStartLine);
        if (!matcher.find()) {
            this.mMalformedHeader = true;
            return false;
        }
        this.mVersion = matcher.group(1);
        this.mStatusCodeString = matcher.group(2);
        String tmp = matcher.group(3);
        if (tmp != null) {
            this.mReasonPhrase = tmp;
        }
        if (!this.mVersion.equalsIgnoreCase("HTTP/1.0") && !this.mVersion.equalsIgnoreCase("HTTP/1.1")) {
            this.mMalformedHeader = true;
            return false;
        }
        try {
            this.mStatusCode = Integer.parseInt(this.mStatusCodeString);
        }
        catch (NumberFormatException e) {
            this.mMalformedHeader = true;
            return false;
        }
        return true;
    }

    public int getContentLength() {
        int len = super.getContentLength();
        if (this.mStatusCode >= 100 && this.mStatusCode < 200 || this.mStatusCode == 204 || this.mStatusCode == 304) {
            return 0;
        }
        if (this.mStatusCode >= 200 && this.mStatusCode < 300) {
            return len;
        }
        if (len > 0) {
            return len;
        }
        return 0;
    }

    public static HttpResponseHeader getError(String msg) {
        HttpResponseHeader res = null;
        try {
            res = new HttpResponseHeader(msg);
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            // empty catch block
        }
        return res;
    }

    public boolean isImage() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        return contentType != null && contentType.toLowerCase().indexOf(_CONTENT_TYPE_IMAGE) > -1;
    }

    public boolean isText() {
        String contentType = this.getHeader("Content-Type".toUpperCase());
        if (contentType != null) {
            if (contentType.toLowerCase().indexOf(_CONTENT_TYPE_TEXT) > -1) {
                return true;
            }
            if (contentType.toLowerCase().indexOf(_CONTENT_TYPE_HTML) > -1) {
                return true;
            }
        }
        return false;
    }

    public static boolean isStatusLine(String data) {
        return patternPartialStatusLine.matcher(data).find();
    }

    public static HttpResponseHeader ProxyConnectResponse(boolean isConnectionClose) {
        HttpResponseHeader res = null;
        try {
            res = new HttpResponseHeader(PROXY_CONNECT_HTTP_200);
            if (isConnectionClose) {
                res.setHeader("Proxy-Connection", "Close");
            } else {
                res.setHeader("Proxy-Connection", "Keep-alive");
            }
        }
        catch (HttpMalformedHeaderException httpMalformedHeaderException) {
            // empty catch block
        }
        return res;
    }
}

