/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.scan.AbstractTest;
import com.proofsecure.paros.scan.AlertDB;
import com.proofsecure.paros.scan.AlertItem;
import com.proofsecure.paros.scan.Analyser;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.Report;
import com.proofsecure.paros.util.Util;
import java.io.File;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.TreeSet;

public abstract class AbstractScanner
implements Runnable {
    protected static final String CRLF = "\r\n";
    protected static DecimalFormat decFormat = new DecimalFormat("##0.###");
    protected ParsedEntity mStartEntity = null;
    private Thread myThread = null;
    protected boolean mIsStarted = false;
    protected boolean mIsSignalStop = false;
    protected AbstractTest mTestModel = null;
    static Analyser mAnalyser = null;
    protected AlertDB mAlertDB = new AlertDB();
    protected TreeSet mAlertList = new TreeSet();

    public AbstractScanner() throws Exception {
        try {
            this.mAlertDB.read("alerts.xml");
        }
        catch (Exception e) {
            System.out.println("Error reading alerts.xml.  Please make sure it is in the program path.");
            e.printStackTrace();
            throw e;
        }
    }

    public void startScan(ParsedEntity entity) {
        if (this.mIsStarted) {
            return;
        }
        Global.currentScanner = this;
        this.removeAllAlert();
        this.mStartEntity = entity;
        this.myThread = new Thread(this);
        this.myThread.setDaemon(true);
        this.myThread.start();
        this.mIsStarted = true;
    }

    public void stopScan() {
        if (!this.mIsStarted) {
            return;
        }
        this.mIsSignalStop = true;
        if (this.mTestModel != null) {
            this.mTestModel.stop();
        }
    }

    public boolean isStarted() {
        return this.mIsStarted;
    }

    public int getScannerThread() {
        return Global.config.getScannerThread();
    }

    public void run() {
        long startTime = 0L;
        long diffTime = 0L;
        try {
            Global.proxy.stopServer();
            startTime = System.currentTimeMillis();
            this.writeOutput("Scanning using " + this.getScannerThread() + " thread(s).");
            this.process();
            diffTime = System.currentTimeMillis() - startTime;
            String diffTimeString = String.valueOf(decFormat.format((double)diffTime / 1000.0)) + "s";
            if (this.mIsSignalStop) {
                this.writeOutput("Stopping scan...");
                if (this.mTestModel != null) {
                    this.mTestModel.getThreadPool().waitAllThreadComplete(15000);
                }
                this.writeOutput("Scanning stopped.");
                this.endOfScan();
                return;
            }
            this.writeOutput("Scanning completed in " + diffTimeString);
            this.endOfScan();
            this.endOfProcess();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    protected abstract void process() throws Exception;

    protected abstract void endOfProcess();

    protected void endOfScan() {
        Global.currentScanner = null;
        Global.proxy.startServer();
        this.mIsStarted = false;
        this.mIsSignalStop = false;
        this.writeStatus(" ");
    }

    protected void writeOutput(String text) {
        Util.writeOutput(text);
    }

    protected void writeStatus(String text) {
        Util.writeStatus(text);
    }

    static Analyser getAnalyser() {
        return mAnalyser;
    }

    public AlertDB getAlertDB() {
        return this.mAlertDB;
    }

    public synchronized void writeAlertToOutput(AlertItem alert) {
        StringBuffer sb = new StringBuffer();
        sb.append(String.valueOf(AlertItem.MSG_RISK[alert.risk]) + " risk (");
        sb.append(String.valueOf(AlertItem.MSG_RELIABILITY[alert.reliability]) + ") - " + alert.alert + CRLF);
        sb.append("URI:\t" + alert.uri + CRLF);
        sb.append("Parameter:\t" + alert.param + CRLF);
        sb.append("******");
        this.writeOutput(sb.toString());
    }

    public synchronized void writeAlert(AlertItem alert) {
        switch (alert.id) {
            case 10010: {
                if (!this.addAlertUniqueOtherInfo(alert)) break;
                this.writeAlertToOutput(alert);
                break;
            }
            default: {
                this.addAlert(alert);
                this.writeAlertToOutput(alert);
            }
        }
    }

    public void generateAlertReport() {
        AlertItem item = null;
        if (!Global.isReportEnabled) {
            return;
        }
        try {
            StringBuffer sb = new StringBuffer(500);
            sb.append("<?xml version=\"1.0\"?>");
            sb.append("<report>\r\n");
            sb.append("This report was generated at " + Report.getCurrentDateTimeString() + ".");
            Iterator iterator = this.mAlertList.iterator();
            while (iterator.hasNext()) {
                item = (AlertItem)iterator.next();
                sb.append(item.toXML());
            }
            sb.append("</report>");
            File report = Report.stringToHtml(sb.toString(), "report" + File.separator + "rp_alert.xsl", Global.PATH_SCAN_REPORT);
            Util.showMessageDialog("Scanning report generated.  If it does not show up after clicking OK,\r\nplease browse the file at " + report.getAbsolutePath());
            Report.openBrowser(report.getAbsolutePath());
        }
        catch (Exception ae) {
            Util.showMessageDialog("File creation error.");
        }
    }

    public synchronized void removeAllAlert() {
        if (this.mAlertList == null || this.mAlertList.size() > 0) {
            this.mAlertList = new TreeSet();
        }
        if (Global.isDumpScan) {
            AbstractTest.resetDump();
        }
    }

    public synchronized void listAllAlert() {
        this.mAlertList = new TreeSet();
        AlertItem item = null;
        Iterator iterator = this.mAlertDB.getTable().values().iterator();
        while (iterator.hasNext()) {
            item = (AlertItem)iterator.next();
            item = item.newInstance();
            item.setRiskReliability(3, 2);
            this.writeAlert(item);
        }
        this.generateAlertReport();
    }

    synchronized void addAlert(AlertItem alert) {
        this.mAlertList.add(alert);
    }

    synchronized boolean addAlertUniqueOtherInfo(AlertItem alert) {
        AlertItem item = null;
        Iterator iterator = this.mAlertList.iterator();
        while (iterator.hasNext()) {
            item = (AlertItem)iterator.next();
            if (alert.id != item.id || !alert.otherInfo.equalsIgnoreCase(item.otherInfo)) continue;
            return false;
        }
        this.addAlert(alert);
        return true;
    }
}

