/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.log.Dump;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpInputStream;
import com.proofsecure.paros.network.HttpOutputStream;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.scan.AlertItem;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.Scanner;
import com.proofsecure.paros.util.ThreadPool;
import com.proofsecure.paros.util.Util;
import java.io.IOException;
import java.net.Socket;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class AbstractTest
implements Runnable {
    protected static final String CRLF = "\r\n";
    protected static final int PATTERN_PARAM = 42;
    protected static final int WAIT_TIME_MILLIS = 30000;
    protected static final String DEFAULT_HEADER = "Accept: */*\r\nAccept-Language: en-us\r\nPragma: no-cache\r\nUser-Agent: Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0;)\r\n";
    protected HttpRequestHeader mReqHeader = new HttpRequestHeader();
    protected HttpBody mReqBody = new HttpBody();
    protected HttpResponseHeader mResHeader = new HttpResponseHeader();
    protected HttpBody mResBody = new HttpBody();
    protected ThreadPool mThreadPool = null;
    private Socket mSocket = null;
    private ParsedEntity mCurEntity = null;
    private HttpInputStream mHttpIn = null;
    private HttpOutputStream mHttpOut = null;
    private boolean mAbsoluteUriRequired = false;
    private boolean mIsSignalStop = false;
    private static Dump dumpScan = null;

    protected AbstractTest() {
    }

    public static void resetDump() {
        dumpScan = new Dump("scan", false, true);
    }

    abstract void startTest(ParsedEntity var1);

    public abstract String getTestName();

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            try {
                this.scan();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.close();
            throw throwable;
        }
        {
            Object var2_4 = null;
            this.close();
            return;
        }
    }

    public void stop() {
        this.mIsSignalStop = true;
    }

    protected abstract void scan() throws Exception;

    protected void writeOutput(String text) {
        Global.scanner.writeOutput(text);
    }

    protected void writeAlert(AlertItem alert) {
        Global.scanner.writeAlert(alert);
    }

    protected void writeStatus(String text) {
        Global.scanner.writeStatus(text);
    }

    protected ParsedEntity getEntity() {
        return this.mCurEntity;
    }

    protected HttpInputStream getHttpInputStream() {
        return this.mHttpIn;
    }

    protected HttpOutputStream getHttpOutputStream() {
        return this.mHttpOut;
    }

    protected HttpRequestHeader getRequestHeader() {
        return this.mReqHeader;
    }

    protected HttpBody getRequestBody() {
        return this.mReqBody;
    }

    protected HttpResponseHeader getResponseHeader() {
        return this.mResHeader;
    }

    protected HttpBody getResponseBody() {
        return this.mResBody;
    }

    protected void sendAndReceive() throws IOException {
        HttpRequestHeader reqHeader = new HttpRequestHeader(this.getRequestHeader().toString());
        HttpResponseHeader tmpResHeader = null;
        HttpBody tmpResBody = null;
        reqHeader.setHostName(this.getRequestHeader().getHostName());
        reqHeader.setHostPort(this.getRequestHeader().getHostPort());
        reqHeader.setSecure(this.getRequestHeader().getSecure());
        this.connect();
        reqHeader.setAbsoluteUriRequired(this.mAbsoluteUriRequired);
        reqHeader.setContentLength(this.getRequestBody().length());
        long count = System.currentTimeMillis();
        if (Global.isDumpScan && dumpScan != null) {
            if (this.getRequestBody() != null && this.getRequestBody().length() > 0) {
                dumpScan.log(Dump.REQUEST_FILE, count, reqHeader.toString(), this.getRequestBody().toString(), reqHeader.getSecure() ? "https" : "http");
            } else {
                dumpScan.log(Dump.REQUEST_FILE, count, reqHeader.toString(), null, reqHeader.getSecure() ? "https" : "http");
            }
        }
        this.mHttpOut.write(reqHeader);
        this.mHttpOut.write(this.getRequestBody());
        Thread.yield();
        tmpResHeader = (HttpResponseHeader)this.mHttpIn.readHeader();
        tmpResBody = this.mHttpIn.readBody();
        this.close();
        int i = 0;
        while (i < 5 && HttpStatusCode.isRedirection(tmpResHeader.getStatusCode()) && tmpResHeader.getStatusCode() != 304) {
            String location = tmpResHeader.getHeader("Location");
            reqHeader.setURI(location);
            reqHeader.setMethod("GET");
            this.connect(reqHeader.getHostName(), reqHeader.getHostPort(), reqHeader.getSecure());
            this.mHttpOut.write(this.getRequestHeader());
            this.mHttpOut.write(this.getRequestBody());
            Thread.yield();
            tmpResHeader = (HttpResponseHeader)this.mHttpIn.readHeader();
            tmpResBody = this.mHttpIn.readBody();
            this.close();
            ++i;
        }
        this.mResHeader = tmpResHeader;
        this.mResBody = tmpResBody;
        if (Global.isDumpScan && dumpScan != null) {
            if (this.mResBody != null && this.mResBody.length() > 0) {
                dumpScan.log(Dump.RESPONSE_FILE, count, this.mResHeader.toString(), this.mResBody.toString(), reqHeader.getSecure() ? "https" : "http");
            } else {
                dumpScan.log(Dump.RESPONSE_FILE, count, this.mResHeader.toString(), null, reqHeader.getSecure() ? "https" : "http");
            }
        }
    }

    protected void init(ParsedEntity entity) throws Exception {
        this.mSocket = null;
        this.mCurEntity = null;
        this.mHttpIn = null;
        this.mHttpOut = null;
        this.mCurEntity = entity;
        this.mAbsoluteUriRequired = false;
        this.mReqHeader.setMessage(entity.getRequestHeader().toStringAbsoluteUri());
        this.mReqHeader.setHostName(entity.getHostName());
        this.mReqHeader.setHostPort(entity.getHostPort());
        this.mReqHeader.setSecure(entity.getSecure());
        this.mReqHeader.setHeader("If-Modified-Since", null);
        this.mReqHeader.setHeader("If-None-Match", null);
        this.mReqBody.setBody(entity.getRequestBody().toString());
    }

    protected void close() {
        try {
            this.mHttpIn.close();
            this.mHttpOut.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Util.closeSocket(this.mSocket);
    }

    protected boolean matchBodyPattern(Pattern pattern, StringBuffer sb) {
        Matcher matcher = pattern.matcher(this.getResponseBody().toString());
        boolean result = matcher.find();
        if (result && sb != null) {
            sb.append(matcher.group());
        }
        return result;
    }

    protected boolean matchHeaderPattern(String header, Pattern pattern) {
        String val = this.getResponseHeader().getHeader(header);
        if (val == null) {
            return false;
        }
        Matcher matcher = pattern.matcher(val);
        return matcher.find();
    }

    private void connect() throws IOException {
        this.connect(this.mCurEntity.getHostName(), this.mCurEntity.getHostPort(), this.mCurEntity.getSecure());
    }

    private void connect(String hostName, int hostPort, boolean isSecure) throws IOException {
        this.mSocket = Util.connect(this.mCurEntity.getHostName(), this.mCurEntity.getHostPort(), this.mCurEntity.getSecure());
        this.mSocket.setSoTimeout(30000);
        this.mHttpIn = new HttpInputStream(this.mSocket.getInputStream());
        this.mHttpOut = new HttpOutputStream(this.mSocket.getOutputStream());
        this.mAbsoluteUriRequired = !isSecure && Util.checkAndUseProxy(hostName);
    }

    protected boolean isFileExist(ParsedEntity entity, HttpRequestHeader reqHeader, HttpResponseHeader resHeader, HttpBody body) {
        return Scanner.getAnalyser().isFileExist(entity, reqHeader, resHeader, body);
    }

    protected boolean isSignalStop() {
        return this.mIsSignalStop;
    }

    protected void bingo(int id, int risk, int reliability, String uri, String param, String otherInfo) {
        AlertItem alert = Global.scanner.getAlertDB().getInstance(id);
        alert.setRiskReliability(risk, reliability);
        if (uri == null || uri.length() == 0) {
            uri = this.getRequestHeader().getURIHostPathQuery();
        }
        if (uri.length() > 200) {
            uri = uri.substring(200);
        }
        alert.setUri(uri);
        alert.setParam(param);
        alert.setOtherInfo(otherInfo);
        this.writeAlert(alert);
    }

    ThreadPool getThreadPool() {
        return this.mThreadPool;
    }
}

