/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.network.HttpResponseHeader;
import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.scan.AbstractTest;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.SampleResponse;
import java.net.URI;
import java.util.Hashtable;
import java.util.Random;
import java.util.regex.Pattern;

class Analyser
extends AbstractTest {
    private Hashtable mAnalysedEntityTable = new Hashtable();
    private static Random staticRandomGenerator = new Random();
    private static final String p_REMOVE_HEADER = "(?m)(?i)(?s)<HEAD>.*?</HEAD>";
    private static final String[] staticSuffixList = new String[]{".cfm", ".jsp", ".php", ".asp", ".aspx", ".dll", ".exe", ".pl"};
    private static final Pattern patternNotFound = Pattern.compile("(\\bnot\\b(found|exist))|(\\b404\\berror\\b)|(\\berror\\b404\\b)", 42);

    public String getTestName() {
        return "Analyser";
    }

    protected void scan() throws Exception {
    }

    void startTest(ParsedEntity startEntity) {
        this.mAnalysedEntityTable.clear();
        if (startEntity.isRoot() && startEntity.getChildCount() == 0) {
            return;
        }
        this.writeOutput("Running analyser ...");
        this.analyseServer(startEntity);
        if (!startEntity.isRoot()) {
            try {
                this.preTestAnalyse(this.getHostEntity(startEntity));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected boolean isFileExist(ParsedEntity entity, HttpRequestHeader reqh, HttpResponseHeader resh, HttpBody resBody) {
        SampleResponse sample;
        if (resh.getStatusCode() == 404) {
            return false;
        }
        ParsedEntity refEntity = entity;
        if (refEntity.isLeaf() && !((ParsedEntity)refEntity.getParent()).isRoot()) {
            refEntity = (ParsedEntity)refEntity.getParent();
        }
        if ((sample = (SampleResponse)this.mAnalysedEntityTable.get(refEntity.getURIHostPath().toString())) == null) {
            sample = (SampleResponse)this.mAnalysedEntityTable.get(this.getHostEntity(refEntity).getURIHostPath().toString());
        }
        if (sample == null) {
            System.out.println("sample not found. RefEntity = " + refEntity.getURIHostPath().toString());
            return resh.getStatusCode() == 200;
        }
        if (HttpStatusCode.isRedirection(resh.getStatusCode())) {
            try {
                String location;
                if (sample.resHeader.getStatusCode() == resh.getStatusCode() && (location = resh.getHeader("Location")) != null && location.equals(sample.resHeader.getHeader("Location"))) {
                    return false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return true;
        }
        if (resh.getStatusCode() != 200) {
            return false;
        }
        String body = resBody.toString().replaceAll(p_REMOVE_HEADER, "");
        if (sample.errorPageType == 3) {
            return !sample.resBody.equals(body);
        }
        try {
            URI uri = new URI(reqh.getURIHostPathQuery());
            if (sample.errorPageType == 4) {
                body = resBody.toString().replaceAll(this.getPathRegex(uri), "");
                return !sample.resBody.equals(body);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return !this.matchBodyPattern(patternNotFound, null);
    }

    private void analyseServer(ParsedEntity entity) {
        ParsedEntity tmp = null;
        if (entity == null) {
            return;
        }
        try {
            if (!entity.isRoot() && (!entity.isLeaf() || entity.isLeaf() && ((ParsedEntity)entity.getParent()).isRoot())) {
                this.preTestAnalyse(entity);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int i = 0;
        while (i < entity.getChildCount()) {
            try {
                tmp = (ParsedEntity)entity.getChildAt(i);
                this.analyseServer(tmp);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void preTestAnalyse(ParsedEntity entity) throws Exception {
        HttpResponseHeader resHeader = null;
        HttpBody resBody = null;
        ParsedEntity folderEntity = entity;
        this.init(folderEntity);
        Hashtable hashtable = this.mAnalysedEntityTable;
        synchronized (hashtable) {
            if (this.mAnalysedEntityTable.get(this.getRequestHeader().getURIHostPath()) != null) {
                return;
            }
        }
        URI tmpUri = new URI(this.getRequestHeader().getURIHostPath());
        String path = this.getRandomPathSuffix(folderEntity, tmpUri);
        URI uri1 = new URI(tmpUri.getScheme(), null, tmpUri.getHost(), tmpUri.getPort(), path, null, null);
        this.getRequestHeader().setURI(uri1.toString());
        this.sendAndReceive();
        resHeader = new HttpResponseHeader(this.getResponseHeader().toString());
        if (resHeader.getStatusCode() == 404) {
            this.addAnalysedHost(folderEntity, resHeader, "", 0);
            return;
        }
        if (HttpStatusCode.isRedirection(resHeader.getStatusCode())) {
            this.addAnalysedHost(folderEntity, resHeader, "", 2);
            return;
        }
        if (resHeader.getStatusCode() != 200) {
            this.addAnalysedHost(folderEntity, resHeader, "", 1);
            return;
        }
        resHeader = new HttpResponseHeader(this.getResponseHeader().toString());
        resBody = new HttpBody(this.getResponseBody().toString());
        this.init(folderEntity);
        tmpUri = new URI(this.getRequestHeader().getURIHostPath());
        path = this.getRandomPathSuffix(folderEntity, tmpUri);
        URI uri2 = new URI(tmpUri.getScheme(), null, tmpUri.getHost(), tmpUri.getPort(), path, null, null);
        this.getRequestHeader().setURI(uri2.toString());
        this.sendAndReceive();
        String resBody1 = resBody.toString().replaceAll(p_REMOVE_HEADER, "");
        String resBody2 = this.getResponseBody().toString().replaceAll(p_REMOVE_HEADER, "");
        if (resBody1.equals(resBody2)) {
            this.addAnalysedHost(folderEntity, resHeader, resBody1, 3);
            return;
        }
        if ((resBody1 = resBody1.toString().replaceAll(this.getPathRegex(uri1), "")).equals(resBody2 = resBody2.toString().replaceAll(this.getPathRegex(uri2), ""))) {
            this.addAnalysedHost(folderEntity, resHeader, resBody1, 4);
            return;
        }
        this.addAnalysedHost(folderEntity, resHeader, "", 5);
    }

    private String getRandomPathSuffix(ParsedEntity entity, URI uri) {
        String resultSuffix = this.getChildSuffix(entity, true);
        String path = "";
        path = uri.getPath() == null ? "" : uri.getPath();
        path = String.valueOf(path) + (path.endsWith("/") ? "" : "/") + Long.toString(Math.abs(staticRandomGenerator.nextLong())) + Global.getEyeCatcher();
        path = String.valueOf(path) + resultSuffix;
        return path;
    }

    private String getChildSuffix(ParsedEntity entity, boolean performRecursiveCheck) {
        String resultSuffix = "";
        String suffix = null;
        ParsedEntity childEntity = null;
        try {
            int i = 0;
            while (i < staticSuffixList.length) {
                suffix = staticSuffixList[i];
                int j = 0;
                while (j < entity.getChildCount()) {
                    childEntity = (ParsedEntity)entity.getChildAt(j);
                    if (childEntity.getURIHostPath().getPath().endsWith(suffix)) {
                        return suffix;
                    }
                    ++j;
                }
                ++i;
            }
            if (performRecursiveCheck) {
                int j = 0;
                while (j < entity.getChildCount()) {
                    resultSuffix = this.getChildSuffix((ParsedEntity)entity.getChildAt(j), performRecursiveCheck);
                    if (!resultSuffix.equals("")) {
                        return resultSuffix;
                    }
                    ++j;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultSuffix;
    }

    private void addAnalysedHost(ParsedEntity entity, HttpResponseHeader resHeader, String body, int errorPageType) {
        String host = null;
        host = entity.getURIHostPath().toString();
        SampleResponse sample = new SampleResponse();
        sample.resHeader = resHeader;
        sample.resBody = body;
        sample.errorPageType = errorPageType;
        Hashtable hashtable = this.mAnalysedEntityTable;
        synchronized (hashtable) {
            this.mAnalysedEntityTable.put(host, sample);
        }
    }

    /*
     * Unable to fully structure code
     */
    private ParsedEntity getHostEntity(ParsedEntity entity) {
        hostEntity = entity;
        if (!hostEntity.isRoot()) ** GOTO lbl5
        return hostEntity;
lbl-1000:
        // 1 sources

        {
            hostEntity = (ParsedEntity)hostEntity.getParent();
lbl5:
            // 2 sources

            ** while (!((ParsedEntity)hostEntity.getParent()).isRoot())
        }
lbl6:
        // 1 sources

        return hostEntity;
    }

    private String getPathRegex(URI uri) {
        StringBuffer sb = new StringBuffer(100);
        String host = String.valueOf(uri.getScheme()) + "://" + uri.getHost();
        if (uri.getPort() != -1) {
            host = String.valueOf(host) + ":" + uri.getPort();
        }
        sb.append(this.getPathPattern(host));
        String path = "";
        if (uri.getPath() != null) {
            path = uri.getPath();
            if (uri.getQuery() != null) {
                path = String.valueOf(path) + "(\\?" + uri.getQuery() + ")?";
            }
            sb.append(path);
        }
        return sb.toString();
    }

    private String getPathPattern(String path) {
        return "(" + path + ")?";
    }
}

