/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.scan;

import com.proofsecure.paros.network.HttpStatusCode;
import com.proofsecure.paros.scan.TestAbstractParam;
import java.io.IOException;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class TestCRLFInjection
extends TestAbstractParam {
    private static Random staticRandomGenerator = new Random();
    private String randomString = "Tamper=" + Long.toString(Math.abs(staticRandomGenerator.nextLong()));
    private String cookieTamper1 = "%0D%0ASet-cookie:%20" + this.randomString + "%0D%0A";
    private String cookieTamper2 = "%0ASet-cookie:%20" + this.randomString + "%0A";
    private String[] PARAM_LIST = new String[]{this.cookieTamper1, this.cookieTamper2};
    private Pattern patternCookieTamper = Pattern.compile("Set-cookie: " + this.randomString, 42);

    TestCRLFInjection() {
    }

    public String toString() {
        return "TestCRLFInjection";
    }

    public String getTestName() {
        return "CRLF Injection";
    }

    protected void check(boolean isBody, String paramKey, String paramValue, String query, int insertPos) throws IOException {
        String bingoQuery = null;
        String displayURI = null;
        String newQuery = null;
        String resBodyNormal = null;
        boolean pos = false;
        long defaultTimeUsed = 0L;
        long timeUsed = 0L;
        long lastTime = 0L;
        newQuery = this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + paramValue);
        this.createMessage(isBody, newQuery);
        lastTime = System.currentTimeMillis();
        this.sendAndReceive();
        defaultTimeUsed = System.currentTimeMillis() - lastTime;
        if (this.getResponseHeader().getStatusCode() != 200) {
            return;
        }
        resBodyNormal = this.getResponseBody().toString();
        int i = 0;
        while (i < this.PARAM_LIST.length) {
            bingoQuery = i == 0 ? this.insertQuery(query, insertPos, "") : this.insertQuery(query, insertPos, String.valueOf(paramKey) + "=" + this.PARAM_LIST[i]);
            this.createMessage(isBody, bingoQuery);
            lastTime = System.currentTimeMillis();
            this.sendAndReceive();
            defaultTimeUsed = System.currentTimeMillis() - lastTime;
            displayURI = this.getRequestHeader().getURIHostPathQuery();
            if (this.checkResult(bingoQuery, resBodyNormal)) {
                return;
            }
            ++i;
        }
    }

    private boolean checkResult(String query, String normalHTTPResponse) {
        if (this.getResponseHeader().getStatusCode() != 200 && !HttpStatusCode.isServerError(this.getResponseHeader().getStatusCode())) {
            return false;
        }
        if (this.getResponseBody().toString().equals(normalHTTPResponse)) {
            return false;
        }
        Matcher matcher = this.patternCookieTamper.matcher(this.getResponseHeader().toString());
        if (matcher.find()) {
            this.bingo(10007, 2, 2, "", query, "");
            return true;
        }
        return false;
    }

    private void bingo(boolean isSuspicious, String query, String uri, String other) {
        String result;
        String string = result = isSuspicious ? "Suspicious" : "Warning";
        if (uri == null) {
            uri = this.getRequestHeader().getURIHostPathQuery();
        }
        this.writeOutput(String.valueOf(result) + " -\tCookie tampering or CRLF injection: " + uri);
        this.writeOutput("\tQuery: " + (query == null || query.length() == 0 ? "[empty]" : query));
        if (other != null) {
            this.writeOutput("\tDetail: " + other);
        }
    }

    protected void scan() throws Exception {
        boolean skip = this.getEntity().mState == 1;
        this.writeStatus("CRLF Injection: " + (skip ? "(skipped) " : "") + this.getRequestHeader().getURIHostPath());
        if (skip) {
            return;
        }
        this.init();
        this.checkUrlOrBody(false, this.myQuery);
        this.checkUrlOrBody(true, this.myReqBody.toString());
    }
}

