/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.spider;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.spider.Spider;
import com.proofsecure.paros.util.Util;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class SpiderGUI
extends Spider {
    WaitingDialog waitingDialog = null;

    private String getURLfromGUI() {
        return JOptionPane.showInputDialog(Global.parosFrame, "Please type the URL for spider\r\n(Note: website with invalid SSL certificate cannot be crawled)", "http://");
    }

    public boolean init() {
        String su = this.getURLfromGUI();
        if (su == null) {
            return false;
        }
        URL u = null;
        try {
            u = new URL(su);
            if (u.getFile().equals("")) {
                u = new URL(String.valueOf(u.toString()) + "/");
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Global.parosFrame, "URL is invalid");
        }
        this.setStartURL(u);
        if (Global.config.getProxyChainName() != null) {
            if (Global.config.getProxyChainName().equals("") || !Global.config.useProxy(u.getHost())) {
                this.setProxy("", "");
            } else {
                this.setProxy(Global.config.getProxyChainName(), "" + Global.config.getProxyChainPort());
            }
        }
        this.waitingDialog = new WaitingDialog(Global.parosFrame, false, this);
        Util.centreChild(Global.parosFrame, this.waitingDialog);
        this.waitingDialog.show();
        return true;
    }

    protected void wrapup() {
        if (this.hconn != null) {
            this.hconn.disconnect();
        }
        Global.parosFrame.logAppend("Total " + this.links.getUrlDone().size() + " links crawled." + "\r\n");
        Global.parosFrame.logAppend(this.links.listUrlRejected());
        this.isStarted = false;
        if (this.waitingDialog != null) {
            this.waitingDialog.dispose();
        }
        Global.parosFrame.setStatus("  ");
        Global.treePanel.TreeRefresh();
    }

    public void logError(String s) {
        Global.parosFrame.logAppend("!!! Error: " + s + " !!!\r\n");
    }

    protected void log(URL ur, HttpRequestHeader reqHeader) throws Exception {
        Global.treePanel.setTree(reqHeader, new HttpBody());
        Global.parosFrame.setStatus("Crawled  " + ur.toString());
    }

    public static void main(String[] args) throws Exception {
        if (args.length < 1) {
            System.out.println("java paros.spider.Spider URL [proxy_name:proxy_port]\r\ne.g. java paros.spider.Spider http://localhost:8080/ \r\n      java paros.spider.Spider http://localhost:8080/ proxy.abc.com:8080\r\n ");
            return;
        }
        if (args.length == 2 && args[1].indexOf(":") == -1) {
            System.out.println("java paros.spider.Spider URL [proxy_name:proxy_port]\r\ne.g. java paros.spider.Spider http://localhost:8080/ \r\n      java paros.spider.Spider http://localhost:8080/ proxy.abc.com:8080\r\n ");
            return;
        }
        SpiderGUI s = new SpiderGUI();
        s.initSecureConnection();
        URL url = new URL(args[0]);
        if (url.getFile().equals("")) {
            url = new URL(String.valueOf(url.toString()) + "/");
        }
        s.setStartURL(url);
        if (args.length == 2) {
            String[] proxyArg = args[1].split(":");
            s.setProxy(proxyArg[0], proxyArg[1]);
        }
        s.start();
    }

    class WaitingDialog
    extends JDialog {
        private Spider spider = null;
        private JButton btnCancel;
        private JLabel jLabel1;
        private JLabel jLabel2;

        WaitingDialog(Frame parent, boolean modal, Spider s) {
            super(parent, modal);
            this.spider = s;
            this.initComponents();
        }

        private void initComponents() {
            this.getContentPane().setLayout(new GridLayout(2, 1));
            this.btnCancel = new JButton();
            this.jLabel1 = new JLabel();
            this.jLabel2 = new JLabel();
            this.setTitle("Paros 3.1.3 ");
            this.setResizable(false);
            this.setBackground(Color.lightGray);
            this.addWindowListener(new WindowAdapter(this){
                final /* synthetic */ WaitingDialog this$1;
                {
                    this.this$1 = waitingDialog;
                }

                public void windowClosing(WindowEvent evt) {
                    WaitingDialog.access$0(this.this$1);
                }
            });
            this.btnCancel.setText("Stop");
            this.btnCancel.addActionListener(new ActionListener(this){
                final /* synthetic */ WaitingDialog this$1;
                {
                    this.this$1 = waitingDialog;
                }

                public void actionPerformed(ActionEvent evt) {
                    WaitingDialog.access$1(this.this$1, evt);
                }
            });
            this.jLabel1.setText("Spider is running.");
            this.jLabel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.getContentPane().add(this.jLabel1);
            this.getContentPane().add(this.btnCancel);
            this.pack();
        }

        private void btnCancelActionPerformed(ActionEvent evt) {
            this.closeDialog();
        }

        private void closeDialog() {
            this.spider.setStop();
            this.dispose();
        }

        public void show(Dimension parentSize) {
            Dimension frameSize = this.getPreferredSize();
            if (parentSize == null) {
                parentSize = Toolkit.getDefaultToolkit().getScreenSize();
            }
            if (frameSize.height > parentSize.height) {
                frameSize.height = parentSize.height;
            }
            if (frameSize.width > parentSize.width) {
                frameSize.width = parentSize.width;
            }
            this.setLocation((parentSize.width - frameSize.width) / 2, (parentSize.height - frameSize.height) / 2);
            this.pack();
            this.show();
        }

        static /* synthetic */ void access$0(WaitingDialog waitingDialog) {
            waitingDialog.closeDialog();
        }

        static /* synthetic */ void access$1(WaitingDialog waitingDialog, ActionEvent actionEvent) {
            waitingDialog.btnCancelActionPerformed(actionEvent);
        }
    }
}

