/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.ui.PopupPanel;
import java.awt.Component;
import java.awt.Font;
import java.awt.Insets;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

public class ParosTabbedPane
extends JTabbedPane {
    private static final int MAX_LOG_SIZE = 1024000;
    Hashtable panels = new Hashtable();

    ParosTabbedPane() {
    }

    JList addListPanel(String name) {
        JScrollPane scrollPane = new JScrollPane();
        final JList list = new JList();
        list.setFont(new Font("Dialog", 0, 11));
        scrollPane.getViewport().add(list, null);
        this.panels.put(name, scrollPane);
        list.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    PopupPanel pp = new PopupPanel(list);
                    pp.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.mousePressed(e);
                }
            }
        });
        this.addTab(name, scrollPane);
        return list;
    }

    void addLogPanel(String name) {
        JScrollPane scrollPane = new JScrollPane();
        final JTextArea textArea = new JTextArea();
        textArea.setFont(new Font("Dialog", 0, 11));
        textArea.setEditable(false);
        textArea.setLineWrap(true);
        textArea.setMargin(new Insets(0, 5, 5, 0));
        textArea.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if ((e.getModifiers() & 4) != 0) {
                    PopupPanel pp = new PopupPanel(textArea);
                    pp.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
                } else {
                    super.mousePressed(e);
                }
            }
        });
        scrollPane.getViewport().add((Component)textArea, null);
        this.panels.put(name, scrollPane);
        this.addTab(name, scrollPane);
    }

    void setEditable(String name, boolean b) {
        ((JTextArea)((JScrollPane)this.panels.get(name)).getViewport().getView()).setEditable(b);
    }

    void clear(final String name) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component log = ((JScrollPane)ParosTabbedPane.this.panels.get(name)).getViewport().getView();
                if (log instanceof JTextArea) {
                    String newText = "";
                    JTextArea area = (JTextArea)((JScrollPane)ParosTabbedPane.this.panels.get(name)).getViewport().getView();
                    area.setText(null);
                } else if (log instanceof JList) {
                    Global.urlLog.clear();
                }
            }
        });
    }

    void append(final String name, final String text) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Component log = ((JScrollPane)ParosTabbedPane.this.panels.get(name)).getViewport().getView();
                if (log instanceof JTextArea) {
                    String newText = "";
                    JTextArea area = (JTextArea)((JScrollPane)ParosTabbedPane.this.panels.get(name)).getViewport().getView();
                    if (area.getText().length() + text.length() > 1024000) {
                        int pos = area.getText().indexOf("\\n", area.getText().length() / 2);
                        newText = pos > -1 ? area.getText().substring(pos) : area.getText().substring(area.getText().length() / 2);
                        area.setText(newText);
                    }
                    area.append(text);
                    ((JScrollPane)ParosTabbedPane.this.panels.get(name)).getVerticalScrollBar().setValue(((JScrollPane)ParosTabbedPane.this.panels.get(name)).getVerticalScrollBar().getMaximum());
                } else if (log instanceof JList) {
                    Global.urlLog.addElement(text);
                    ((JScrollPane)ParosTabbedPane.this.panels.get(name)).getVerticalScrollBar().setValue(((JScrollPane)ParosTabbedPane.this.panels.get(name)).getVerticalScrollBar().getMaximum());
                }
            }
        });
    }

    public void requestLogFocus(String pane) {
        try {
            this.setSelectedComponent((JScrollPane)this.panels.get(pane));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

