/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.ui;

import com.proofsecure.paros.Global;
import com.proofsecure.paros.ManualTester;
import com.proofsecure.paros.network.HttpBody;
import com.proofsecure.paros.network.HttpMalformedHeaderException;
import com.proofsecure.paros.network.HttpRequestHeader;
import com.proofsecure.paros.scan.ParsedEntity;
import com.proofsecure.paros.scan.ParsedFolder;
import com.proofsecure.paros.scan.ParsedURL;
import com.proofsecure.paros.scan.ScannerOneRequest;
import com.proofsecure.paros.ui.FindDialog;
import com.proofsecure.paros.util.Util;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextArea;
import javax.swing.JTree;

public class PopupPanel
extends JPanel {
    JPopupMenu popup = new JPopupMenu();
    JComponent control = null;
    JMenuItem item2;
    JMenuItem jMenuScanSelected;
    JMenuItem jMenuResend = new JMenuItem("Re-send");
    JMenuItem jMenuScanDeleteTree;
    JMenuItem jMenuEditFind;

    public JPopupMenu getPopupMenu() {
        return this.popup;
    }

    public PopupPanel(JComponent c) {
        this();
        this.control = c;
        if (c instanceof JTree) {
            this.popup.remove(this.jMenuEditFind);
            this.popup.remove(this.jMenuResend);
        } else if (c instanceof JTextArea) {
            this.popup.remove(this.jMenuResend);
            this.popup.remove(this.jMenuScanSelected);
            this.popup.remove(this.jMenuScanDeleteTree);
        } else if (c instanceof JList) {
            this.popup.remove(this.jMenuScanDeleteTree);
            this.popup.remove(this.jMenuEditFind);
        }
    }

    public PopupPanel() {
        this.jMenuResend.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PopupPanel.this.control instanceof JList) {
                    JList list = (JList)PopupPanel.this.control;
                    if (list.getSelectedValue() == null) {
                        Util.showMessageDialog("Please select an item first");
                        return;
                    }
                    String selected = list.getSelectedValue().toString();
                    Vector v = Global.dumpAnalyzer.searchRequest(selected = selected.substring(0, selected.indexOf(":")));
                    if (v != null && v.size() >= 3) {
                        try {
                            boolean httpsFlag = v.get(2).toString().equals("https");
                            HttpRequestHeader header = new HttpRequestHeader(v.get(0).toString());
                            header.setSecure(httpsFlag);
                            String domain = "";
                            domain = String.valueOf(header.getSecure() ? "https://" : "http://") + header.getHostName();
                            ManualTester tester = new ManualTester();
                            tester.initValue(v.get(0).toString(), v.get(1).toString(), httpsFlag, domain, header.getHostPort());
                            tester.show();
                        }
                        catch (HttpMalformedHeaderException e1) {
                            System.out.println(e1.getMessage());
                        }
                        catch (Exception e1) {
                            System.out.println(e1.getMessage());
                        }
                    }
                }
            }
        });
        this.jMenuScanSelected = new JMenuItem("Scan Selected Node/Item");
        this.jMenuScanSelected.setMnemonic(83);
        this.jMenuScanSelected.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (PopupPanel.this.control instanceof JTree) {
                    if (Global.treePanel.getSelectedParsedEntity() != null) {
                        Global.scanner.startScan(Global.treePanel.getSelectedParsedEntity());
                    } else {
                        Util.showMessageDialog("Please select a site or folder.");
                    }
                } else if (PopupPanel.this.control instanceof JList) {
                    JList list = (JList)PopupPanel.this.control;
                    if (list.getSelectedValue() == null) {
                        Util.showMessageDialog("Please select a site or folder.");
                        return;
                    }
                    String selected = list.getSelectedValue().toString();
                    Vector v = Global.dumpAnalyzer.searchRequest(selected = selected.substring(0, selected.indexOf(":")));
                    if (v != null) {
                        ParsedEntity p = new ParsedEntity();
                        try {
                            boolean httpsFlag = v.get(2).toString().equals("https");
                            HttpRequestHeader header = new HttpRequestHeader(v.get(0).toString());
                            header.setSecure(httpsFlag);
                            p.setEntity(header, new HttpBody(v.get(1).toString()));
                            p.setSecure(httpsFlag);
                            p.setCaption("ScannerOneRequest");
                            ParsedURL parsedURL = new ParsedURL("", new HttpRequestHeader(v.get(0).toString()), new HttpBody(v.get(1).toString()));
                            String baseUri = String.valueOf(parsedURL.getURIHostPath().getScheme()) + "://" + parsedURL.getHostName();
                            ParsedFolder root = new ParsedFolder(parsedURL.getHostName(), new URI(baseUri), parsedURL);
                            root.setSecure(httpsFlag);
                            root.getRequestHeader().setSecure(httpsFlag);
                            root.setCaption(parsedURL.getURIHostPath().toString());
                            root.add(p);
                            ScanThread thread = new ScanThread(root);
                            thread.start();
                        }
                        catch (HttpMalformedHeaderException e1) {
                            System.out.println(e1.getMessage());
                        }
                        catch (URISyntaxException e1) {
                            System.out.println(e1.getMessage());
                        }
                        catch (Exception e1) {
                            System.out.println(e1.getMessage());
                        }
                    }
                }
            }
        });
        this.popup.add(this.jMenuResend);
        this.popup.add(this.jMenuScanSelected);
        this.jMenuScanDeleteTree = new JMenuItem("Delete Selected Node");
        this.popup.add(this.jMenuScanDeleteTree);
        this.jMenuScanDeleteTree.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ParsedEntity entity = null;
                ParsedEntity parent = null;
                entity = Global.treePanel.getSelectedParsedEntity();
                if (entity == null) {
                    Util.showMessageDialog("Please select a site or folder.");
                    return;
                }
                parent = (ParsedEntity)entity.getParent();
                if (parent != null) {
                    Global.treePanel.getTreeModel().removeNodeFromParent(entity);
                    Global.treePanel.getTree().setModel(Global.treePanel.getTreeModel());
                }
            }
        });
        this.item2 = new JMenuItem("Clear All");
        this.popup.add(this.item2);
        this.item2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (PopupPanel.this.control instanceof JTextArea) {
                    ((JTextArea)PopupPanel.this.control).setText("");
                } else if (PopupPanel.this.control instanceof JTree) {
                    Global.parosFrame.clearTree();
                } else if (PopupPanel.this.control instanceof JList) {
                    Global.dumpLog.resetCurDate();
                    Global.dumpAnalyzer.refresh();
                    Global.urlLog.clear();
                }
            }
        });
        this.jMenuEditFind = new JMenuItem("Find...");
        this.jMenuEditFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Container c = PopupPanel.this.control;
                JFrame parent = null;
                try {
                    while (c.getParent() != null) {
                        if (!((c = c.getParent()) instanceof JFrame)) continue;
                        parent = (JFrame)c;
                        break;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    parent = Global.parosFrame;
                }
                if (parent == null) {
                    parent = Global.parosFrame;
                }
                Global.findDialog = new FindDialog((Frame)parent, false);
                Util.centreChild(parent, Global.findDialog);
                Global.findDialog.show();
            }
        });
        this.popup.add(this.jMenuEditFind);
        this.popup.setInvoker(this);
    }

    class ScanThread
    extends Thread {
        ParsedEntity entity = null;

        ScanThread(ParsedEntity p) {
            this.entity = p;
        }

        public void run() {
            try {
                ScannerOneRequest scanner = new ScannerOneRequest();
                scanner.test(this.entity);
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
    }
}

