/*
 * Decompiled with CFR 0.152.
 */
package com.proofsecure.paros.util;

import com.proofsecure.paros.Global;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class Util {
    public static void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static void closeSocket(Socket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        socket = null;
    }

    public static void closeServerSocket(ServerSocket socket) {
        if (socket == null) {
            return;
        }
        try {
            socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        socket = null;
    }

    public static void closeInputStream(InputStream in) {
        try {
            in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void closeOutputStream(OutputStream out) {
        try {
            out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getURIPathQuery(URI uri) {
        String result = uri.getPath();
        if (result != null && result.equals("")) {
            result = "/";
        }
        if (uri.getQuery() != null) {
            result = String.valueOf(result) + "?" + uri.getQuery();
        }
        return result;
    }

    public static String getURIHostPath(URI uri, boolean isSecure) {
        String path;
        if (uri.getScheme().equalsIgnoreCase("https")) {
            isSecure = true;
        }
        String hostAndPath = "";
        if (isSecure) {
            hostAndPath = "https://" + uri.getHost();
            if (uri.getPort() != -1 && uri.getPort() != 443) {
                hostAndPath = String.valueOf(hostAndPath) + ":" + uri.getPort();
            }
        } else {
            hostAndPath = "http://" + uri.getHost();
            if (uri.getPort() != -1 && uri.getPort() != 80) {
                hostAndPath = String.valueOf(hostAndPath) + ":" + uri.getPort();
            }
        }
        if ((path = uri.getPath()) != null) {
            if (path.equals("")) {
                path = "/";
            }
            hostAndPath = String.valueOf(hostAndPath) + uri.getPath();
        }
        return hostAndPath;
    }

    public static void showDebugMsg(String msg) {
        System.out.println(msg);
    }

    public static Socket connect(String hostName, int hostPort, boolean isSecure) throws IOException {
        Socket socket = null;
        if (isSecure) {
            if (Util.checkAndUseProxy(hostName)) {
                try {
                    socket = Global.ssl.clientViaProxy(hostName, hostPort, Global.config.getProxyChainName(), Global.config.getProxyChainPort(), Global.isUseClientCert);
                }
                catch (SocketException e) {
                    socket = Global.ssl.client(hostName, hostPort, Global.isUseClientCert);
                }
            } else {
                socket = Global.ssl.client(hostName, hostPort, Global.isUseClientCert);
            }
        } else if (Util.checkAndUseProxy(hostName)) {
            try {
                socket = new Socket(Global.config.getProxyChainName(), Global.config.getProxyChainPort());
            }
            catch (SocketException e) {
                socket = new Socket(hostName, hostPort);
            }
        } else {
            socket = new Socket(hostName, hostPort);
        }
        return socket;
    }

    public static boolean checkAndUseProxy(String hostName) {
        return Global.config.useProxy(hostName);
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static void showMessageDialog(String text) {
        JOptionPane.showMessageDialog(Global.parosFrame, text, "Paros 3.1.3 ", 2);
    }

    public static void showConfirmDialog(String text) {
        JOptionPane.showConfirmDialog(Global.parosFrame, text, "Paros 3.1.3 ", 0);
    }

    public static void writeStatus(String text) {
        Global.parosFrame.setStatus(text);
    }

    public static void writeOutput(String text) {
        if (Global.isRunGUI) {
            if (!text.endsWith("\r\n")) {
                text = String.valueOf(text) + "\r\n";
            }
            Global.parosFrame.logAppend(text);
        } else {
            Util.writeConsole(text);
        }
    }

    public static void writeConsole(String text) {
        System.out.println(text);
    }

    public static void centreChild(JFrame parent, Component child) {
        Dimension parentSize = parent.getSize();
        Dimension childSize = child.getPreferredSize();
        Point loc = parent.getLocation();
        child.setLocation((parentSize.width - childSize.width) / 2 + loc.x, (parentSize.height - childSize.height) / 2 + loc.y);
    }
}

