/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import org.hsqldb.ScaledRAFile;
import org.hsqldb.Trace;

class NIOScaledRAFile
extends ScaledRAFile {
    MappedByteBuffer buffer;
    FileChannel channel;
    long bufferLength;

    public NIOScaledRAFile(String string, boolean bl, int n) throws FileNotFoundException, IOException {
        super(string, bl, n);
        if (super.length() > 0x20000000L) {
            return;
        }
        this.isNio = true;
        this.channel = this.file.getChannel();
        this.enlargeBuffer(super.length(), 0);
        this.isNio = true;
        Trace.printSystemOut("NIO file instance created. mode:  " + bl);
    }

    private long newBufferSize(long l) throws IOException {
        long l2;
        int n = 20;
        while (true) {
            if ((l2 = (long)(1 << n)) > Integer.MAX_VALUE) {
                l2 = Integer.MAX_VALUE;
                if (l2 >= l) break;
                throw new IOException(Trace.getMessage(29));
            }
            if (l2 >= l) break;
            ++n;
        }
        return l2;
    }

    private void enlargeBuffer(long l, int n) throws IOException {
        int n2 = 0;
        if (this.buffer != null) {
            n2 = this.buffer.position();
            this.buffer.force();
        }
        long l2 = this.newBufferSize(l + (long)n);
        Trace.printSystemOut("NIO next enlargeBuffer():  " + l2);
        try {
            this.buffer = this.channel.map(this.readOnly ? FileChannel.MapMode.READ_ONLY : FileChannel.MapMode.READ_WRITE, 0L, l2);
        }
        catch (Exception exception) {
            this.isNio = false;
            this.buffer = null;
            this.channel = null;
            return;
        }
        this.bufferLength = l2;
        this.buffer.position(n2);
    }

    void seek(long l) throws IOException {
        if (!this.isNio) {
            super.seek(l);
            return;
        }
        if (l >= this.bufferLength) {
            this.enlargeBuffer(l, 0);
            if (!this.isNio) {
                super.seek(l);
                return;
            }
        }
        this.buffer.position((int)l);
    }

    long getFilePointer() throws IOException {
        if (!this.isNio) {
            return super.getFilePointer();
        }
        return (this.buffer.position() + this.scale - 1) / this.scale;
    }

    int read() throws IOException {
        if (!this.isNio) {
            return super.read();
        }
        return this.buffer.get();
    }

    void read(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isNio) {
            super.read(byArray, n, n2);
            return;
        }
        this.buffer.get(byArray, n, n2);
    }

    int readInt() throws IOException {
        if (!this.isNio) {
            return super.readInt();
        }
        return this.buffer.getInt();
    }

    void write(byte[] byArray, int n, int n2) throws IOException {
        if (!this.isNio) {
            super.write(byArray, n, n2);
            return;
        }
        if ((long)this.buffer.position() + (long)n2 > this.bufferLength) {
            this.enlargeBuffer(this.buffer.position(), n2);
            if (!this.isNio) {
                super.write(byArray, n, n2);
                return;
            }
        }
        this.buffer.put(byArray, n, n2);
    }

    void writeInt(int n) throws IOException {
        if (!this.isNio) {
            super.writeInt(n);
            return;
        }
        if ((long)this.buffer.position() + 4L > this.bufferLength) {
            this.enlargeBuffer(this.buffer.position(), 4);
            if (!this.isNio) {
                super.writeInt(n);
                return;
            }
        }
        this.buffer.putInt(n);
    }

    void close() throws IOException {
        if (!this.isNio) {
            super.close();
            return;
        }
        Trace.printSystemOut("NIO next close() - fileLength = " + this.bufferLength);
        Trace.printSystemOut("NIO next buffer.force()");
        if (this.buffer != null) {
            this.buffer.force();
        }
        this.buffer = null;
        this.channel = null;
        Trace.printSystemOut("NIO next file.close()");
        this.file.close();
    }
}

