/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.CompiledStatement;
import org.hsqldb.Database;
import org.hsqldb.Expression;
import org.hsqldb.Function;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.NumberSequence;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.SubQuery;
import org.hsqldb.Table;
import org.hsqldb.TableFilter;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Types;
import org.hsqldb.View;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMap;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.IntValueHashMap;
import org.hsqldb.store.ValuePool;

class Parser {
    private Database database;
    private Tokenizer tokenizer;
    private Session session;
    private String sTable;
    private String sToken;
    private Object oData;
    private int iType;
    private int iToken;
    private int subQueryLevel;
    private HsqlArrayList subQueryList = new HsqlArrayList();
    static HashMap simpleFunctions = new HashMap();
    private static IntValueHashMap tokenSet;
    HsqlArrayList parameters = new HsqlArrayList();
    private static final Expression[] noParameters;
    private static final SubQuery[] noSubqueries;

    Parser(Session session, Database database, Tokenizer tokenizer) {
        this.database = database;
        this.tokenizer = tokenizer;
        this.session = session;
    }

    void reset(String string) {
        this.sTable = null;
        this.sToken = null;
        this.oData = null;
        this.tokenizer.reset(string);
        this.subQueryList.clear();
        this.subQueryLevel = 0;
        this.parameters.clear();
    }

    void checkTableWriteAccess(Table table, int n) throws HsqlException {
        this.session.checkReadWrite();
        this.session.check(table.getName(), n);
        if (table.isView()) {
            throw Trace.error(55, table.getName().name);
        }
        table.checkDataReadOnly();
    }

    static HsqlArrayList getColumnNames(Database database, Tokenizer tokenizer, boolean bl) throws HsqlException {
        String string;
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        do {
            if (bl) {
                string = tokenizer.getIdentifier();
                boolean bl2 = tokenizer.wasQuotedIdentifier();
                HsqlNameManager.HsqlName hsqlName = database.nameManager.newHsqlName(string, bl2);
                hsqlArrayList.add(hsqlName);
                continue;
            }
            hsqlArrayList.add(tokenizer.getString());
        } while ((string = tokenizer.getString()).equals(","));
        if (!string.equals(")")) {
            throw Trace.error(11, string);
        }
        return hsqlArrayList;
    }

    SubQuery parseSubquery(View view, HsqlNameManager.HsqlName[] hsqlNameArray, boolean bl, int n) throws HsqlException {
        SubQuery subQuery;
        if (view == null) {
            int[] nArray;
            int n2;
            subQuery = new SubQuery();
            ++this.subQueryLevel;
            Select select = this.parseSelect(false);
            subQuery.level = this.subQueryLevel--;
            boolean bl2 = select.resolveAll(bl);
            subQuery.select = select;
            subQuery.isResolved = bl2;
            if (!bl2) {
                return subQuery;
            }
            Table table = new Table(this.database, this.database.nameManager.newHsqlName("SYSTEM_SUBQUERY", false), 1, 0);
            if (hsqlNameArray != null) {
                if (hsqlNameArray.length != select.iResultLen) {
                    throw Trace.error(5);
                }
                for (n2 = 0; n2 < select.iResultLen; ++n2) {
                    HsqlNameManager.HsqlName hsqlName = hsqlNameArray[n2];
                    select.exprColumns[n2].setAlias(hsqlName.name, hsqlName.isNameQuoted);
                }
            } else {
                for (n2 = 0; n2 < select.iResultLen; ++n2) {
                    String string = select.exprColumns[n2].getAlias();
                    if (string != null && string.length() != 0) continue;
                    string = "COL_" + String.valueOf(n2 + 1);
                    select.exprColumns[n2].setAlias(string, false);
                }
            }
            table.addColumns(select);
            if (n == 30) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = 0;
            } else {
                nArray = null;
            }
            int[] nArray3 = nArray;
            table.createPrimaryKey(nArray3);
            subQuery.table = table;
            subQuery.isInPredicate = n == 30;
            this.subQueryList.add(subQuery);
        } else {
            subQuery = view.viewSubQuery;
            for (int i = 0; i < view.viewSubqueries.length; ++i) {
                this.subQueryList.add(view.viewSubqueries[i]);
            }
        }
        return subQuery;
    }

    Select parseSelect(boolean bl) throws HsqlException {
        Expression expression;
        Object object;
        Expression expression2;
        String string;
        Select select = new Select();
        if (!bl) {
            this.parseLimit(select);
        }
        if ((string = this.tokenizer.getString()).equals("DISTINCT")) {
            select.isDistinctSelect = true;
        } else {
            this.tokenizer.back();
        }
        HsqlArrayList hsqlArrayList = new HsqlArrayList();
        do {
            expression2 = this.parseExpression();
            string = this.tokenizer.getString();
            if (string.equals("AS")) {
                expression2.setAlias(this.tokenizer.getName(), this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            } else if (this.tokenizer.wasName()) {
                expression2.setAlias(string, this.tokenizer.wasQuotedIdentifier());
                string = this.tokenizer.getString();
            }
            hsqlArrayList.add(expression2);
        } while (string.equals(","));
        if (string.equals("INTO")) {
            boolean bl2 = true;
            string = this.tokenizer.getString();
            switch (Token.get(string)) {
                case 302: {
                    select.intoType = 4;
                    break;
                }
                case 324: {
                    select.intoType = 2;
                    break;
                }
                case 325: {
                    select.intoType = 6;
                    break;
                }
                case 309: {
                    select.intoType = 3;
                    break;
                }
                default: {
                    select.intoType = 3;
                    bl2 = false;
                }
            }
            if (bl2) {
                string = this.tokenizer.getString();
            }
            select.sIntoTable = this.database.nameManager.newHsqlName(string, this.tokenizer.wasQuotedIdentifier());
            string = this.tokenizer.getString();
            if ("?".equals(this.sToken)) {
                throw Trace.error(11, 195);
            }
        }
        if (!string.equals("FROM")) {
            throw Trace.error(11, string);
        }
        expression2 = null;
        HsqlArrayList hsqlArrayList2 = new HsqlArrayList();
        hsqlArrayList2.add(this.parseTableFilter(false));
        while (true) {
            if ((string = this.tokenizer.getString()).equals("INNER")) {
                string = this.tokenizer.getThis("JOIN");
            }
            if (string.equals("LEFT")) {
                string = this.tokenizer.getString();
                if (string.equals("OUTER")) {
                    string = this.tokenizer.getString();
                }
                Trace.check(string.equals("JOIN"), 11, string);
                object = this.parseTableFilter(true);
                hsqlArrayList2.add(object);
                this.tokenizer.getThis("ON");
                expression = this.parseExpression();
                expression.checkTables(hsqlArrayList2);
                expression2 = Parser.addJoinCondition(expression2, expression, (TableFilter)object, true);
                continue;
            }
            if (string.equals("JOIN")) {
                hsqlArrayList2.add(this.parseTableFilter(false));
                this.tokenizer.getThis("ON");
                object = this.parseExpression();
                ((Expression)object).checkTables(hsqlArrayList2);
                expression2 = Parser.addJoinCondition(expression2, (Expression)object, null, false);
                continue;
            }
            if (!string.equals(",")) break;
            hsqlArrayList2.add(this.parseTableFilter(false));
        }
        this.tokenizer.back();
        Parser.resolveSelectTableFilter(select, hsqlArrayList, hsqlArrayList2);
        string = this.tokenizer.getString();
        if (string.equals("WHERE")) {
            object = this.parseExpression();
            object = Parser.resolveWhereColumnAliases((Expression)object, hsqlArrayList);
            expression2 = Parser.addCondition(expression2, (Expression)object);
            string = this.tokenizer.getString();
        }
        select.queryCondition = expression2;
        if (string.equals("GROUP")) {
            this.tokenizer.getThis("BY");
            int n = 0;
            do {
                expression = this.parseExpression();
                hsqlArrayList.add(expression);
                string = this.tokenizer.getString();
                ++n;
            } while (string.equals(","));
            select.iGroupLen = n;
        }
        if (string.equals("HAVING")) {
            select.iHavingIndex = hsqlArrayList.size();
            select.havingCondition = this.parseExpression();
            string = this.tokenizer.getString();
            hsqlArrayList.add(select.havingCondition);
        }
        switch (Token.get(string)) {
            case 227: {
                string = this.tokenizer.getString();
                if (string.equals("ALL")) {
                    select.iUnionType = 2;
                } else if (string.equals("DISTINCT")) {
                    select.iUnionType = 1;
                } else {
                    select.iUnionType = 1;
                    this.tokenizer.back();
                }
                this.tokenizer.getThis("SELECT");
                select.sUnion = this.parseSelect(true);
                break;
            }
            case 115: {
                string = this.tokenizer.getString();
                if (!string.equals("DISTINCT")) {
                    this.tokenizer.back();
                }
                this.tokenizer.getThis("SELECT");
                select.iUnionType = 3;
                select.sUnion = this.parseSelect(true);
                break;
            }
            case 78: 
            case 310: {
                string = this.tokenizer.getString();
                if (!string.equals("DISTINCT")) {
                    this.tokenizer.back();
                }
                this.tokenizer.getThis("SELECT");
                select.iUnionType = 4;
                select.sUnion = this.parseSelect(true);
                break;
            }
            default: {
                this.tokenizer.back();
            }
        }
        if (!bl) {
            string = this.tokenizer.getString();
            if (string.equals("ORDER")) {
                this.tokenizer.getThis("BY");
                this.parseOrderBy(select, hsqlArrayList);
            } else {
                this.tokenizer.back();
            }
        }
        int n = hsqlArrayList.size();
        select.exprColumns = new Expression[n];
        hsqlArrayList.toArray(select.exprColumns);
        return select;
    }

    private void parseLimit(Select select) throws HsqlException {
        Expression expression;
        Expression expression2;
        String string = this.tokenizer.getString();
        boolean bl = false;
        if (string.equals("LIMIT")) {
            this.read();
            expression2 = this.readTerm();
            expression = this.readTerm();
            bl = true;
            this.tokenizer.back();
        } else if (string.equals("TOP")) {
            this.read();
            expression2 = new Expression(4, ValuePool.getInt(0));
            expression = this.readTerm();
            this.tokenizer.back();
        } else {
            this.tokenizer.back();
            return;
        }
        if ((expression2.getType() == 1 && expression2.getDataType() == 4 && (Integer)expression2.getValue(null) >= 0 || expression2.isParam()) && (expression.getType() == 1 && expression.getDataType() == 4 && (Integer)expression2.getValue(null) >= 0 || expression.isParam())) {
            expression2.setDataType(4);
            expression.setDataType(4);
            select.limitCondition = new Expression(8, expression2, expression);
            return;
        }
        int n = bl ? 168 : 169;
        throw Trace.error(16, n);
    }

    private void parseOrderBy(Select select, HsqlArrayList hsqlArrayList) throws HsqlException {
        String string;
        int n = 0;
        do {
            Expression expression = this.parseExpression();
            expression = Parser.resolveOrderByColumnAlias(expression, hsqlArrayList, select.iResultLen, select.sUnion != null);
            string = this.tokenizer.getString();
            if (string.equals("DESC")) {
                expression.setDescending();
                string = this.tokenizer.getString();
            } else if (string.equals("ASC")) {
                string = this.tokenizer.getString();
            }
            hsqlArrayList.add(expression);
            ++n;
        } while (string.equals(","));
        this.tokenizer.back();
        select.iOrderLen = n;
    }

    private static void resolveSelectTableFilter(Select select, HsqlArrayList hsqlArrayList, HsqlArrayList hsqlArrayList2) throws HsqlException {
        Expression expression;
        int n;
        int n2 = hsqlArrayList2.size();
        TableFilter[] tableFilterArray = new TableFilter[n2];
        hsqlArrayList2.toArray(tableFilterArray);
        select.tFilter = tableFilterArray;
        n2 = hsqlArrayList.size();
        for (n = 0; n < n2; ++n) {
            int n3;
            expression = (Expression)hsqlArrayList.get(n);
            if (expression.getType() == 6) {
                n3 = n;
                Table table = null;
                String string = expression.getTableName();
                for (int i = 0; i < tableFilterArray.length; ++i) {
                    TableFilter tableFilter = tableFilterArray[i];
                    expression.resolveTables(tableFilter);
                    if (string != null && !string.equals(tableFilter.getName())) continue;
                    table = tableFilter.getTable();
                    int n4 = table.getColumnCount();
                    for (int j = 0; j < n4; ++j) {
                        Expression expression2 = new Expression(tableFilter.getName(), table.getColumn(j));
                        hsqlArrayList.add(n3++, expression2);
                        ++n2;
                    }
                }
                Trace.check(table != null, 22, string);
                --n2;
                hsqlArrayList.remove(n3);
                continue;
            }
            if (expression.getType() != 2 || expression.getFilter() != null) continue;
            for (n3 = 0; n3 < tableFilterArray.length; ++n3) {
                expression.resolveTables(tableFilterArray[n3]);
            }
        }
        for (n = 0; n < n2; ++n) {
            expression = (Expression)hsqlArrayList.get(n);
            expression.resolveTypes();
        }
        select.iResultLen = n2;
    }

    private static Expression resolveWhereColumnAliases(Expression expression, HsqlArrayList hsqlArrayList) throws HsqlException {
        return expression;
    }

    private static Expression resolveOrderByColumnAlias(Expression expression, HsqlArrayList hsqlArrayList, int n, boolean bl) throws HsqlException {
        if (expression.getType() == 1) {
            return Parser.resolveOrderByColumnIndex(expression, hsqlArrayList, n);
        }
        if (expression.getType() != 2) {
            if (bl) {
                throw Trace.error(70);
            }
            return expression;
        }
        String string = expression.getColumnName();
        String string2 = expression.getTableName();
        if (string2 != null) {
            int n2 = n;
            for (int i = 0; i < n2; ++i) {
                Expression expression2 = (Expression)hsqlArrayList.get(i);
                if (!string.equals(expression2.getColumnName()) || !string2.endsWith(expression2.getTableName())) continue;
                expression2.orderColumnIndex = i;
                return expression2;
            }
            if (bl) {
                throw Trace.error(70, string);
            }
            return expression;
        }
        Expression expression3 = expression;
        int n3 = hsqlArrayList.size();
        for (int i = 0; i < n3; ++i) {
            Expression expression4 = (Expression)hsqlArrayList.get(i);
            String string3 = expression4.getDefinedAlias();
            String string4 = expression4.getColumnName();
            if (!string.equals(string3) && !string.equals(string4)) continue;
            if (expression3 != expression && i < n) {
                throw Trace.error(156, string);
            }
            if (expression3 != expression) continue;
            expression3 = expression4;
            expression3.orderColumnIndex = i;
        }
        if (bl && (expression3 == expression || expression3.orderColumnIndex >= n)) {
            throw Trace.error(70, string);
        }
        return expression3;
    }

    private static Expression resolveOrderByColumnIndex(Expression expression, HsqlArrayList hsqlArrayList, int n) throws HsqlException {
        int n2;
        if (expression.getDataType() == 4 && 0 < (n2 = ((Integer)expression.getValue(null)).intValue()) && n2 <= n) {
            Expression expression2 = (Expression)hsqlArrayList.get(n2 - 1);
            expression2.orderColumnIndex = n2 - 1;
            return expression2;
        }
        throw Trace.error(70);
    }

    private TableFilter parseTableFilter(boolean bl) throws HsqlException {
        String string = this.tokenizer.getString();
        Table table = null;
        String string2 = null;
        if (string.equals("(")) {
            this.tokenizer.getThis("SELECT");
            SubQuery subQuery = this.parseSubquery(null, null, true, 3);
            this.tokenizer.getThis(")");
            table = subQuery.table;
        } else {
            table = this.database.getTable(this.session, string);
            this.session.check(table.getName(), 1);
            if (table.isView()) {
                SubQuery subQuery = this.parseSubquery((View)table, null, true, 3);
                subQuery.select = ((View)table).viewSelect;
                table = subQuery.table;
                string2 = string;
            }
        }
        string = this.tokenizer.getString();
        if (string.equals("LEFT")) {
            this.tokenizer.back();
        } else if (string.equals("AS")) {
            string2 = this.tokenizer.getName();
        } else if (this.tokenizer.wasName()) {
            string2 = string;
        } else {
            this.tokenizer.back();
        }
        TableFilter tableFilter = new TableFilter(table, string2, bl);
        return tableFilter;
    }

    private static Expression addCondition(Expression expression, Expression expression2) {
        if (expression == null) {
            return expression2;
        }
        if (expression2 == null) {
            return expression;
        }
        return new Expression(28, expression, expression2);
    }

    private static Expression addJoinCondition(Expression expression, Expression expression2, TableFilter tableFilter, boolean bl) throws HsqlException {
        if (!expression2.setForJoin(tableFilter, bl)) {
            throw Trace.error(64);
        }
        return Parser.addCondition(expression, expression2);
    }

    Expression parseExpression() throws HsqlException {
        this.read();
        Expression expression = this.readOr();
        this.tokenizer.back();
        return expression;
    }

    private Expression readAggregate() throws HsqlException {
        boolean bl = false;
        int n = this.iToken;
        this.read();
        if (this.tokenizer.getString().equals("DISTINCT")) {
            bl = true;
        } else {
            this.tokenizer.back();
        }
        this.readThis(101);
        Expression expression = this.readOr();
        this.readThis(102);
        Expression expression2 = new Expression(n, expression, null);
        expression2.setDistinctAggregate(bl);
        return expression2;
    }

    private Expression readOr() throws HsqlException {
        Expression expression = this.readAnd();
        while (this.iToken == 29) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readAnd());
        }
        return expression;
    }

    private Expression readAnd() throws HsqlException {
        Expression expression = this.readCondition();
        while (this.iToken == 28) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readCondition());
        }
        return expression;
    }

    private Expression readCondition() throws HsqlException {
        switch (this.iToken) {
            case 20: {
                int n = this.iToken;
                this.read();
                return new Expression(n, this.readCondition(), null);
            }
            case 31: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                Trace.check(this.iToken == 103, 11);
                SubQuery subQuery = this.parseSubquery(null, null, false, 31);
                Select select = subQuery.select;
                Expression expression = new Expression(select, subQuery.table, !subQuery.isResolved);
                this.read();
                this.readThis(102);
                return new Expression(n, expression, null);
            }
        }
        Expression expression = this.readConcat();
        boolean bl = false;
        if (this.iToken == 20) {
            bl = true;
            this.read();
        }
        switch (this.iToken) {
            case 27: {
                expression = this.parseLikePredicate(expression);
                break;
            }
            case 106: {
                expression = this.parseBetweenPredicate(expression);
                break;
            }
            case 30: {
                expression = this.parseInPredicate(expression);
                break;
            }
            default: {
                Trace.check(!bl, 11);
                if (Expression.isCompare(this.iToken)) {
                    int n = this.iToken;
                    this.read();
                    return new Expression(n, expression, this.readConcat());
                }
                return expression;
            }
        }
        if (bl) {
            expression = new Expression(20, expression, null);
        }
        return expression;
    }

    private Expression parseLikePredicate(Expression expression) throws HsqlException {
        this.read();
        Expression expression2 = this.readTerm();
        Character c = null;
        if (this.sToken.equals("ESCAPE")) {
            this.read();
            Expression expression3 = this.readTerm();
            Trace.check(expression3.getType() == 1, 7);
            String string = (String)expression3.getValue(this.session, 12);
            if (string == null || string.length() < 1) {
                throw Trace.error(7, string);
            }
            c = new Character(string.charAt(0));
        }
        expression = new Expression(expression, expression2, c);
        return expression;
    }

    private Expression parseBetweenPredicate(Expression expression) throws HsqlException {
        this.read();
        Expression expression2 = new Expression(22, expression, this.readConcat());
        this.readThis(28);
        Expression expression3 = new Expression(25, expression, this.readConcat());
        if (expression2.getArg().isParam() && expression2.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        if (expression3.getArg().isParam() && expression3.getArg2().isParam()) {
            throw Trace.error(216, 185);
        }
        return new Expression(28, expression2, expression3);
    }

    private Expression parseInPredicate(Expression expression) throws HsqlException {
        int n = this.iToken;
        this.read();
        this.readThis(101);
        Expression expression2 = null;
        if (this.iToken == 103) {
            SubQuery subQuery = this.parseSubquery(null, null, false, 30);
            Select select = subQuery.select;
            Trace.check(select.iResultLen == 1, 159);
            expression2 = new Expression(select, subQuery.table, !subQuery.isResolved);
            this.read();
        } else {
            Expression[] expressionArray;
            this.tokenizer.back();
            HsqlArrayList hsqlArrayList = new HsqlArrayList();
            do {
                expressionArray = this.parseExpression();
                if (expressionArray.exprType == 1 && expressionArray.valueData == null && !expressionArray.isParam()) {
                    throw Trace.error(79);
                }
                hsqlArrayList.add(expressionArray);
                this.read();
            } while (this.iToken == 104);
            expressionArray = (Expression[])hsqlArrayList.toArray(new Expression[hsqlArrayList.size()]);
            expression2 = new Expression(expressionArray);
        }
        this.readThis(102);
        return new Expression(n, expression, expression2);
    }

    private void readThis(int n) throws HsqlException {
        Trace.check(this.iToken == n, 11);
        this.read();
    }

    private Expression readConcat() throws HsqlException {
        Expression expression = this.readSum();
        while (this.iToken == 105) {
            int n = 15;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readSum());
        }
        return expression;
    }

    private Expression readSum() throws HsqlException {
        Expression expression = this.readFactor();
        while (true) {
            int n;
            if (this.iToken == 100) {
                n = 11;
            } else {
                if (this.iToken != 10) break;
                n = 12;
            }
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readFactor());
        }
        return expression;
    }

    private Expression readFactor() throws HsqlException {
        Expression expression = this.readTerm();
        while (this.iToken == 13 || this.iToken == 14) {
            int n = this.iToken;
            Expression expression2 = expression;
            this.read();
            expression = new Expression(n, expression2, this.readTerm());
        }
        return expression;
    }

    private Expression readTerm() throws HsqlException {
        Expression expression = null;
        block0 : switch (this.iToken) {
            case 2: {
                String string = this.sToken;
                expression = new Expression(this.sTable, this.sToken);
                this.read();
                if (this.iToken == 101) {
                    String string2 = this.database.getJavaName(string);
                    Function function = new Function(string, string2, false);
                    this.session.check(string2, 15);
                    int n = function.getArgCount();
                    int n2 = 0;
                    this.read();
                    if (this.iToken != 102) {
                        while (true) {
                            function.setArgument(n2++, this.readOr());
                            if (this.iToken != 104) break;
                            this.read();
                        }
                    }
                    this.readThis(102);
                    expression = new Expression(function);
                    break;
                }
                String string3 = (String)simpleFunctions.get(string);
                if (string3 == null) break;
                Function function = new Function(string, string3, true);
                expression = new Expression(function);
                break;
            }
            case 10: {
                int n = this.iToken;
                this.read();
                expression = new Expression(n, this.readTerm(), null);
                Trace.check(!expression.getArg().isParam(), 212);
                break;
            }
            case 100: {
                this.read();
                expression = this.readTerm();
                Trace.check(!expression.isParam(), 216, Trace.getMessage(212));
                break;
            }
            case 101: {
                this.read();
                expression = this.readOr();
                if (this.iToken != 102) {
                    throw Trace.error(11, this.sToken);
                }
                this.read();
                break;
            }
            case 1: {
                expression = new Expression(this.iType, this.oData);
                this.read();
                break;
            }
            case 9: {
                expression = new Expression(0, null, true);
                this.parameters.add(expression);
                this.read();
                break;
            }
            case 103: {
                Select select = this.parseSelect(false);
                select.resolve();
                expression = new Expression(select, null, true);
                this.read();
                break;
            }
            case 13: {
                expression = new Expression(this.sTable, (String)null);
                this.read();
                break;
            }
            case 15: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                expression = new Expression(n, expression, this.readOr());
                this.readThis(102);
                break;
            }
            case 62: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                Expression expression2 = this.readOr();
                this.readThis(104);
                expression2 = new Expression(70, expression2, this.readOr());
                expression = new Expression(n, expression, expression2);
                this.readThis(102);
                break;
            }
            case 68: {
                Expression expression3;
                int n = 62;
                Expression expression4 = null;
                this.read();
                if (this.iToken != 110) {
                    expression4 = this.readOr();
                }
                Expression expression5 = null;
                do {
                    expression3 = this.parseCaseWhen(expression4);
                    if (expression == null) {
                        expression = expression3;
                    } else {
                        expression5.setRightExpression(expression3);
                    }
                    expression5 = expression3.getRightExpression();
                } while (this.iToken == 110);
                if (this.iToken == 112) {
                    this.readThis(112);
                    expression3 = this.readOr();
                    expression5.setRightExpression(expression3);
                }
                this.readThis(113);
                break;
            }
            case 67: {
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                Expression expression6 = new Expression(70, new Expression(0, null), expression);
                expression = new Expression(21, expression, this.readOr());
                expression = new Expression(62, expression, expression6);
                this.readThis(102);
                break;
            }
            case 60: 
            case 69: {
                this.read();
                this.readThis(101);
                Expression expression7 = null;
                while (true) {
                    Expression expression8 = this.readOr();
                    Expression expression9 = new Expression(21, expression8, new Expression(0, null));
                    Expression expression10 = new Expression(70, new Expression(0, null), expression8);
                    Expression expression11 = new Expression(62, expression9, expression10);
                    if (expression == null) {
                        expression = expression11;
                    } else {
                        expression7.setLeftExpression(expression11);
                    }
                    expression7 = expression10;
                    if (this.iToken == 102) {
                        this.readThis(102);
                        break block0;
                    }
                    this.readThis(104);
                }
            }
            case 71: {
                this.tokenizer.getThis("VALUE");
                this.tokenizer.getThis("FOR");
                String string = this.tokenizer.getIdentifier();
                this.tokenizer.getString();
                NumberSequence numberSequence = this.database.sequenceManager.getSequence(string);
                Trace.check(numberSequence != null, 191);
                expression = new Expression(numberSequence);
                break;
            }
            case 61: {
                int n = this.iToken;
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(104);
                int n3 = Types.getTypeNr(this.sToken);
                int n4 = 0;
                int n5 = 0;
                if (Types.acceptsPrecisionCreateParam(n3) && this.tokenizer.isGetThis("(")) {
                    n4 = this.tokenizer.getInt();
                    if (Types.acceptsScaleCreateParam(n3) && this.tokenizer.isGetThis(",")) {
                        n5 = this.tokenizer.getInt();
                    }
                    this.tokenizer.getThis(")");
                }
                if (expression.isParam()) {
                    expression.setDataType(n3);
                }
                expression = new Expression(n, expression, null);
                expression.setDataType(n3);
                this.read();
                this.readThis(102);
                break;
            }
            case 107: {
                this.read();
                this.readThis(101);
                expression = this.readOr();
                this.readThis(122);
                int n = Types.getTypeNr(this.sToken);
                int n6 = 0;
                int n7 = 0;
                if (Types.acceptsPrecisionCreateParam(n) && this.tokenizer.isGetThis("(")) {
                    n6 = this.tokenizer.getInt();
                    if (Types.acceptsScaleCreateParam(n) && this.tokenizer.isGetThis(",")) {
                        n7 = this.tokenizer.getInt();
                    }
                    this.tokenizer.getThis(")");
                }
                if (expression.isParam()) {
                    expression.setDataType(n);
                }
                expression = new Expression(61, expression, null);
                expression.setDataType(n);
                this.read();
                this.readThis(102);
                break;
            }
            case 63: {
                this.read();
                this.readThis(101);
                String string = this.sToken;
                if (!Expression.SQL_EXTRACT_FIELD_NAMES.contains(string)) {
                    throw Trace.error(11, this.sToken);
                }
                this.readToken();
                this.readThis(124);
                Function function = new Function(string, this.database.getJavaName(string), false);
                function.setArgument(0, this.readOr());
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            case 65: {
                Expression expression12;
                Expression expression13;
                String string;
                this.read();
                this.readThis(101);
                String string4 = this.sToken;
                if (Expression.SQL_TRIM_SPECIFICATION.contains(string4)) {
                    this.read();
                } else {
                    string4 = "BOTH";
                }
                if (this.sToken.length() == 1) {
                    string = this.sToken;
                    this.read();
                } else {
                    string = " ";
                }
                this.readThis(124);
                Expression expression14 = new Expression(1, (Object)string);
                if (string4.equals("LEADING")) {
                    expression13 = new Expression(true);
                    expression12 = new Expression(false);
                } else if (string4.equals("TRAILING")) {
                    expression13 = new Expression(false);
                    expression12 = new Expression(true);
                } else {
                    expression13 = expression12 = new Expression(true);
                }
                Function function = new Function("TRIM", "org.hsqldb.Library.trim", false);
                function.setArgument(0, this.readOr());
                function.setArgument(1, expression14);
                function.setArgument(2, expression13);
                function.setArgument(3, expression12);
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            case 64: {
                this.read();
                this.readThis(101);
                Function function = new Function("POSITION", "org.hsqldb.Library.position", false);
                function.setArgument(0, this.readTerm());
                this.readThis(30);
                function.setArgument(1, this.readOr());
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            case 66: {
                boolean bl = false;
                this.read();
                this.readThis(101);
                Function function = new Function("SUBSTRING", "org.hsqldb.Library.substring", false);
                function.setArgument(0, this.readTerm());
                if (this.iToken == 124) {
                    this.readThis(124);
                } else {
                    this.readThis(104);
                    bl = true;
                }
                function.setArgument(1, this.readOr());
                Expression expression15 = null;
                if (!bl && this.iToken == 123) {
                    this.readThis(123);
                    expression15 = this.readTerm();
                } else if (bl && this.iToken == 104) {
                    this.readThis(104);
                    expression15 = this.readTerm();
                }
                function.setArgument(2, expression15);
                this.readThis(102);
                expression = new Expression(function);
                break;
            }
            default: {
                if (Expression.isAggregate(this.iToken)) {
                    expression = this.readAggregate();
                    break;
                }
                throw Trace.error(11, this.sToken);
            }
        }
        return expression;
    }

    Expression readDefaultClause() throws HsqlException {
        Expression expression = null;
        this.read();
        switch (this.iToken) {
            case 2: {
                String string = this.sToken;
                String string2 = (String)simpleFunctions.get(string);
                if (string2 != null) {
                    Function function = new Function(string, string2, true);
                    expression = new Expression(function);
                    break;
                }
                throw Trace.error(46, this.sToken);
            }
            case 10: {
                int n = this.iToken;
                this.read();
                if (this.iToken == 1) {
                    expression = new Expression(n, new Expression(this.iType, this.oData), null);
                    break;
                }
                throw Trace.error(46, this.sToken);
            }
            case 1: {
                expression = new Expression(this.iType, this.oData);
                break;
            }
            default: {
                throw Trace.error(46, this.sToken);
            }
        }
        return expression;
    }

    Expression parseCaseWhen(Expression expression) throws HsqlException {
        this.readThis(110);
        Expression expression2 = expression == null ? this.readOr() : new Expression(21, expression, this.readOr());
        this.readThis(111);
        Expression expression3 = this.readOr();
        Expression expression4 = new Expression(70, expression3, new Expression(0, null));
        Expression expression5 = new Expression(62, expression2, expression4);
        return expression5;
    }

    private void read() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        if (this.tokenizer.wasValue()) {
            this.iToken = 1;
            this.oData = this.tokenizer.getAsValue();
            this.iType = this.tokenizer.getType();
        } else if (this.tokenizer.wasName()) {
            this.iToken = 2;
            this.sTable = null;
        } else if (this.tokenizer.wasLongName()) {
            this.sTable = this.tokenizer.getLongNameFirst();
            this.iToken = this.sToken.equals("*") ? 13 : 2;
        } else if (this.sToken.length() == 0) {
            this.iToken = 108;
        } else {
            this.iToken = tokenSet.get((Object)this.sToken, -1);
            if (this.iToken == -1) {
                this.iToken = 108;
            }
            switch (this.iToken) {
                case 9: 
                case 10: 
                case 14: 
                case 15: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 60: 
                case 61: 
                case 62: 
                case 63: 
                case 64: 
                case 65: 
                case 66: 
                case 67: 
                case 68: 
                case 69: 
                case 71: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: {
                    break;
                }
                case 13: {
                    this.sTable = null;
                    break;
                }
                case 109: {
                    this.sToken = this.tokenizer.getString();
                    if (this.sToken.equals("NOT")) {
                        this.iToken = 26;
                        break;
                    }
                    this.iToken = 21;
                    this.tokenizer.back();
                    break;
                }
                default: {
                    this.iToken = 108;
                }
            }
        }
    }

    private void readToken() throws HsqlException {
        this.sToken = this.tokenizer.getString();
        this.iToken = tokenSet.get((Object)this.sToken, -1);
    }

    Expression[] getParameters() {
        Expression[] expressionArray = this.parameters.size() == 0 ? noParameters : (Expression[])this.parameters.toArray(new Expression[this.parameters.size()]);
        this.parameters.clear();
        return expressionArray;
    }

    void clearParameters() {
        this.parameters.clear();
    }

    void setAsView(View view) {
        for (int i = 0; i < this.subQueryList.size(); ++i) {
            SubQuery subQuery = (SubQuery)this.subQueryList.get(i);
            if (subQuery.view != null) continue;
            subQuery.view = view;
        }
    }

    SubQuery[] getSortedSubqueries() {
        if (this.subQueryList.size() == 0) {
            return noSubqueries;
        }
        this.subQueryList.sort((SubQuery)this.subQueryList.get(0));
        SubQuery[] subQueryArray = new SubQuery[this.subQueryList.size()];
        this.subQueryList.toArray(subQueryArray);
        this.subQueryList.clear();
        return subQueryArray;
    }

    CompiledStatement compileCallStatement() throws HsqlException {
        this.clearParameters();
        Expression expression = this.parseExpression();
        CompiledStatement compiledStatement = new CompiledStatement(expression, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    CompiledStatement compileDeleteStatement() throws HsqlException {
        this.clearParameters();
        this.tokenizer.getThis("FROM");
        String string = this.tokenizer.getString();
        Table table = this.database.getTable(this.session, string);
        this.checkTableWriteAccess(table, 2);
        string = this.tokenizer.getString();
        Expression expression = null;
        if (string.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        CompiledStatement compiledStatement = new CompiledStatement(table, expression, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    private void getInsertColumnValueExpressions(Table table, Expression[] expressionArray, int n) throws HsqlException {
        int n2;
        boolean bl = false;
        this.tokenizer.getThis("(");
        for (n2 = 0; n2 < n; ++n2) {
            Expression expression = this.parseExpression();
            expression.resolveTables(null);
            expression.resolveTypes();
            expressionArray[n2] = expression;
            String string = this.tokenizer.getString();
            if (string.equals(",")) continue;
            if (string.equals(")")) {
                bl = true;
                break;
            }
            throw Trace.error(11, string);
        }
        if (!bl || n2 != n - 1) {
            throw Trace.error(5);
        }
    }

    CompiledStatement compileInsertStatement() throws HsqlException {
        this.clearParameters();
        this.tokenizer.getThis("INTO");
        String string = this.tokenizer.getString();
        Table table = this.database.getTable(this.session, string);
        this.checkTableWriteAccess(table, 4);
        string = this.tokenizer.getString();
        HsqlArrayList hsqlArrayList = null;
        boolean[] blArray = null;
        int[] nArray = table.getColumnMap();
        int n = table.getColumnCount();
        if (string.equals("(")) {
            hsqlArrayList = Parser.getColumnNames(this.database, this.tokenizer, false);
            if (hsqlArrayList.size() > n) {
                throw Trace.error(5);
            }
            n = hsqlArrayList.size();
            blArray = table.getNewColumnCheckList();
            nArray = new int[n];
            for (int i = 0; i < n; ++i) {
                int n2;
                nArray[i] = n2 = table.getColumnNr((String)hsqlArrayList.get(i));
                blArray[n2] = true;
            }
            string = this.tokenizer.getString();
        }
        if (string.equals("VALUES")) {
            Expression[] expressionArray = new Expression[n];
            this.getInsertColumnValueExpressions(table, expressionArray, n);
            CompiledStatement compiledStatement = new CompiledStatement(table, nArray, expressionArray, blArray, this.getParameters());
            compiledStatement.subqueries = this.getSortedSubqueries();
            return compiledStatement;
        }
        if (string.equals("SELECT")) {
            Select select = this.parseSelect(false);
            if (n != select.iResultLen) {
                throw Trace.error(5);
            }
            CompiledStatement compiledStatement = new CompiledStatement(table, nArray, blArray, select, this.getParameters());
            compiledStatement.subqueries = this.getSortedSubqueries();
            return compiledStatement;
        }
        throw Trace.error(11, string);
    }

    CompiledStatement compileSelectStatement(boolean bl) throws HsqlException {
        this.clearParameters();
        Select select = this.parseSelect(bl);
        if (select.sIntoTable != null) {
            this.session.checkDDLWrite();
            String string = select.sIntoTable.name;
            if (this.database.findUserTable(this.session, string) != null) {
                throw Trace.error(21, string);
            }
        }
        CompiledStatement compiledStatement = new CompiledStatement(select, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    CompiledStatement compileUpdateStatement() throws HsqlException {
        String string = null;
        this.clearParameters();
        String string2 = this.tokenizer.getString();
        Table table = this.database.getTable(this.session, string2);
        this.checkTableWriteAccess(table, 8);
        if (!this.tokenizer.isGetThis("SET")) {
            string = this.tokenizer.getIdentifier();
            this.tokenizer.getThis("SET");
        }
        int[] nArray = table.getNewColumnMap();
        Expression[] expressionArray = new Expression[nArray.length];
        int n = 0;
        string2 = null;
        do {
            int n2 = table.getColumnNr(this.tokenizer.getString());
            this.tokenizer.getThis("=");
            Expression expression = this.parseExpression();
            if (n == nArray.length) {
                throw Trace.error(5);
            }
            nArray[n] = n2;
            expressionArray[n] = expression;
            string2 = this.tokenizer.getString();
            ++n;
        } while (string2.equals(","));
        Expression expression = null;
        if (string2.equals("WHERE")) {
            expression = this.parseExpression();
        } else {
            this.tokenizer.back();
        }
        nArray = (int[])ArrayUtil.resizeArray(nArray, n);
        expressionArray = (Expression[])ArrayUtil.resizeArray(expressionArray, n);
        CompiledStatement compiledStatement = new CompiledStatement(table, string, nArray, expressionArray, expression, this.getParameters());
        compiledStatement.subqueries = this.getSortedSubqueries();
        return compiledStatement;
    }

    static {
        simpleFunctions.put("CURRENT_DATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("CURRENT_TIME", "org.hsqldb.Library.curtime");
        simpleFunctions.put("CURRENT_TIMESTAMP", "org.hsqldb.Library.now");
        simpleFunctions.put("CURRENT_USER", "org.hsqldb.Library.user");
        simpleFunctions.put("SYSDATE", "org.hsqldb.Library.curdate");
        simpleFunctions.put("NOW", "org.hsqldb.Library.now");
        simpleFunctions.put("TODAY", "org.hsqldb.Library.curdate");
        tokenSet = new IntValueHashMap(37);
        tokenSet.put(",", 104);
        tokenSet.put("=", 21);
        tokenSet.put("!=", 26);
        tokenSet.put("<>", 26);
        tokenSet.put("<", 24);
        tokenSet.put(">", 23);
        tokenSet.put("<=", 25);
        tokenSet.put(">=", 22);
        tokenSet.put("AND", 28);
        tokenSet.put("NOT", 20);
        tokenSet.put("OR", 29);
        tokenSet.put("IN", 30);
        tokenSet.put("EXISTS", 31);
        tokenSet.put("BETWEEN", 106);
        tokenSet.put("+", 100);
        tokenSet.put("-", 10);
        tokenSet.put("*", 13);
        tokenSet.put("/", 14);
        tokenSet.put("||", 105);
        tokenSet.put("(", 101);
        tokenSet.put(")", 102);
        tokenSet.put("SELECT", 103);
        tokenSet.put("LIKE", 27);
        tokenSet.put("COUNT", 40);
        tokenSet.put("SUM", 41);
        tokenSet.put("MIN", 42);
        tokenSet.put("MAX", 43);
        tokenSet.put("AVG", 44);
        tokenSet.put("IFNULL", 60);
        tokenSet.put("NULLIF", 67);
        tokenSet.put("CONVERT", 61);
        tokenSet.put("CAST", 107);
        tokenSet.put("NEXT", 71);
        tokenSet.put("CASE", 68);
        tokenSet.put("WHEN", 110);
        tokenSet.put("THEN", 111);
        tokenSet.put("ELSE", 112);
        tokenSet.put("END", 113);
        tokenSet.put("CASEWHEN", 62);
        tokenSet.put("CONCAT", 15);
        tokenSet.put("COALESCE", 69);
        tokenSet.put("EXTRACT", 63);
        tokenSet.put("POSITION", 64);
        tokenSet.put("FROM", 124);
        tokenSet.put("TRIM", 65);
        tokenSet.put("SUBSTRING", 66);
        tokenSet.put("FOR", 123);
        tokenSet.put("AS", 122);
        tokenSet.put("IS", 109);
        tokenSet.put("?", 9);
        noParameters = new Expression[0];
        noSubqueries = new SubQuery[0];
    }
}

