/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import org.hsqldb.CompiledStatement;
import org.hsqldb.CompiledStatementExecutor;
import org.hsqldb.CompiledStatementManager;
import org.hsqldb.Database;
import org.hsqldb.DatabaseCommandInterpreter;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Expression;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.HsqlException;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.SessionInterface;
import org.hsqldb.Table;
import org.hsqldb.Token;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Transaction;
import org.hsqldb.User;
import org.hsqldb.jdbc.jdbcConnection;
import org.hsqldb.lib.ArrayUtil;
import org.hsqldb.lib.HashMappedList;
import org.hsqldb.lib.HashSet;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.store.ValuePool;

public class Session
implements SessionInterface {
    private volatile boolean isAutoCommit;
    private volatile boolean isReadOnly;
    private volatile boolean isClosed;
    private Database database;
    private User user;
    private HsqlArrayList transactionList;
    private boolean isNestedTransaction;
    private int nestedOldTransIndex;
    private int currentMaxRows;
    private int sessionMaxRows;
    private Number iLastIdentity = ValuePool.getInt(0);
    private final int sessionId;
    private HashMappedList savepoints;
    private boolean script;
    private jdbcConnection intConnection;
    private Tokenizer tokenizer;
    private Parser parser;
    private long sessionSCN;
    static final Result emptyUpdateCount = new Result(1);
    private final long connectTime = System.currentTimeMillis();
    DatabaseCommandInterpreter dbCommandInterpreter;
    CompiledStatementExecutor compiledStatementExecutor;
    CompiledStatementManager compiledStatementManager;
    long currentDateTimeSCN;
    long currentMillis;
    Date currentDate;
    Time currentTime;
    Timestamp currentTimestamp;
    static final int INFO_DATABASE = 0;
    static final int INFO_USER = 1;
    static final int INFO_SESSION_ID = 2;
    static final int INFO_IDENTITY = 3;
    static final int INFO_AUTOCOMMIT = 4;
    static final int INFO_DATABASE_READONLY = 5;
    static final int INFO_CONNECTION_READONLY = 6;

    Session getSession() {
        return this;
    }

    Session(Database database, User user, boolean bl, boolean bl2, int n) {
        this.sessionId = n;
        this.database = database;
        this.user = user;
        this.transactionList = new HsqlArrayList();
        this.savepoints = new HashMappedList(4);
        this.isAutoCommit = bl;
        this.isReadOnly = bl2;
        this.dbCommandInterpreter = new DatabaseCommandInterpreter(this);
        this.compiledStatementExecutor = new CompiledStatementExecutor(this);
        this.compiledStatementManager = database.compiledStatementManager;
        this.tokenizer = new Tokenizer();
        this.parser = new Parser(this, this.database, this.tokenizer);
    }

    public int getId() {
        return this.sessionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (this.isClosed) {
                return;
            }
            try {
                this.database.logger.writeToLog(this, "DISCONNECT");
            }
            catch (HsqlException hsqlException) {
                // empty catch block
            }
            this.database.sessionManager.removeSession(this);
            this.rollback();
            this.database.dropTempTables(this);
            this.compiledStatementManager.removeSession(this.sessionId);
            this.database = null;
            this.user = null;
            this.transactionList = null;
            this.savepoints = null;
            this.intConnection = null;
            this.compiledStatementExecutor = null;
            this.compiledStatementManager = null;
            this.dbCommandInterpreter = null;
            this.iLastIdentity = null;
            this.isClosed = true;
        }
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    void setLastIdentity(Number number) {
        this.iLastIdentity = number;
    }

    Number getLastIdentity() {
        return this.iLastIdentity;
    }

    Database getDatabase() {
        return this.database;
    }

    String getUsername() {
        return this.user.getName();
    }

    User getUser() {
        return this.user;
    }

    void setUser(User user) {
        this.user = user;
    }

    int getMaxRows() {
        return this.currentMaxRows;
    }

    int getSQLMaxRows() {
        return this.sessionMaxRows;
    }

    void setSQLMaxRows(int n) {
        this.currentMaxRows = this.sessionMaxRows = n;
    }

    void checkAdmin() throws HsqlException {
        this.user.checkAdmin();
    }

    void check(Object object, int n) throws HsqlException {
        this.user.check(object, n);
    }

    void checkReadWrite() throws HsqlException {
        Trace.check(!this.isReadOnly, 31);
    }

    void checkDDLWrite() throws HsqlException {
        if (this.user.isSys() || !this.database.filesReadOnly) {
            return;
        }
        Trace.check(false, 31);
    }

    void setPassword(String string) {
        this.user.setPassword(string);
    }

    void addTransactionDelete(Table table, Object[] objectArray) throws HsqlException {
        if (!this.isAutoCommit || this.isNestedTransaction) {
            Transaction transaction = new Transaction(true, this.isNestedTransaction, table, objectArray);
            this.transactionList.add(transaction);
        }
    }

    void addTransactionInsert(Table table, Object[] objectArray) throws HsqlException {
        if (!this.isAutoCommit || this.isNestedTransaction) {
            Transaction transaction = new Transaction(false, this.isNestedTransaction, table, objectArray);
            this.transactionList.add(transaction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean bl) {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (bl != this.isAutoCommit) {
                this.commit();
                this.isAutoCommit = bl;
                try {
                    this.database.logger.writeToLog(this, this.getAutoCommitStatement());
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            if (!this.transactionList.isEmpty()) {
                try {
                    this.database.logger.writeToLog(this, "COMMIT");
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
                this.transactionList.clear();
                this.savepoints.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() {
        if (this.isClosed) {
            return;
        }
        Database database = this.database;
        synchronized (database) {
            int n = this.transactionList.size();
            while (n-- > 0) {
                Transaction transaction = (Transaction)this.transactionList.get(n);
                transaction.rollback(this);
            }
            if (!this.transactionList.isEmpty()) {
                try {
                    this.database.logger.writeToLog(this, "ROLLBACK");
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
                this.transactionList.clear();
            }
            this.savepoints.clear();
        }
    }

    void savepoint(String string) throws HsqlException {
        this.savepoints.remove(string);
        this.savepoints.add(string, ValuePool.getInt(this.transactionList.size()));
        try {
            this.database.logger.writeToLog(this, "SAVEPOINT " + string);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    void rollbackToSavepoint(String string) throws HsqlException {
        int n = this.savepoints.getIndex(string);
        Trace.check(n >= 0, 44, string);
        Integer n2 = (Integer)this.savepoints.get(n);
        n = n2;
        this.rollbackToSavepoint(n);
        this.releaseSavepoint(string);
        try {
            this.database.logger.writeToLog(this, "ROLLBACK TO SAVEPOINT " + string);
        }
        catch (HsqlException hsqlException) {
            // empty catch block
        }
    }

    private void rollbackToSavepoint(int n) throws HsqlException {
        for (int i = this.transactionList.size() - 1; i >= n; --i) {
            Transaction transaction = (Transaction)this.transactionList.get(i);
            transaction.rollback(this);
        }
        this.transactionList.setSize(n);
    }

    void releaseSavepoint(String string) throws HsqlException {
        int n = this.savepoints.getIndex(string);
        Trace.check(n >= 0, 44, string);
        while (this.savepoints.size() > n) {
            this.savepoints.remove(this.savepoints.size() - 1);
        }
    }

    void beginNestedTransaction() throws HsqlException {
        Trace.doAssert(!this.isNestedTransaction, "beginNestedTransaction");
        this.nestedOldTransIndex = this.transactionList.size();
        this.isNestedTransaction = true;
    }

    void endNestedTransaction(boolean bl) throws HsqlException {
        Trace.doAssert(this.isNestedTransaction, "endNestedTransaction");
        if (bl) {
            this.rollbackToSavepoint(this.nestedOldTransIndex);
        }
        this.isNestedTransaction = false;
        if (this.isAutoCommit) {
            this.transactionList.clear();
        }
    }

    public void setReadOnly(boolean bl) throws HsqlException {
        if (!bl && this.database.databaseReadOnly) {
            throw Trace.error(31);
        }
        this.isReadOnly = bl;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    boolean isNestedTransaction() {
        return this.isNestedTransaction;
    }

    public boolean isAutoCommit() {
        return this.isAutoCommit;
    }

    void setScripting(boolean bl) {
        this.script = bl;
    }

    boolean getScripting() {
        return this.script;
    }

    String getAutoCommitStatement() {
        return this.isAutoCommit ? "SET AUTOCOMMIT TRUE" : "SET AUTOCOMMIT FALSE";
    }

    jdbcConnection getInternalConnection() throws HsqlException {
        if (this.intConnection == null) {
            this.intConnection = new jdbcConnection(this);
        }
        return this.intConnection;
    }

    boolean isAdmin() {
        return this.user.isAdmin();
    }

    long getConnectTime() {
        return this.connectTime;
    }

    int getTransactionSize() {
        return this.transactionList.size();
    }

    boolean isAccessible(Object object) throws HsqlException {
        return this.user.isAccessible(object);
    }

    HashSet getGrantedClassNames(boolean bl) {
        return this.isAdmin() ? this.database.getUserManager().getGrantedClassNames() : this.user.getGrantedClassNames(bl);
    }

    private CompiledStatement sqlCompileStatement(String string) throws HsqlException {
        CompiledStatement compiledStatement;
        this.parser.reset(string);
        String string2 = this.tokenizer.getString();
        int n = Token.get(string2);
        switch (n) {
            case 193: {
                compiledStatement = this.parser.compileSelectStatement(false);
                break;
            }
            case 112: {
                compiledStatement = this.parser.compileInsertStatement();
                break;
            }
            case 222: {
                compiledStatement = this.parser.compileUpdateStatement();
                break;
            }
            case 62: {
                compiledStatement = this.parser.compileDeleteStatement();
                break;
            }
            case 23: {
                compiledStatement = this.parser.compileCallStatement();
                break;
            }
            default: {
                compiledStatement = new CompiledStatement();
            }
        }
        if (compiledStatement.type != 9) {
            while (this.tokenizer.getPosition() < this.tokenizer.getLength()) {
                string2 = this.tokenizer.getString();
                if (string2.length() == 0 || string2.equals(";")) continue;
                throw Trace.error(11, string2);
            }
        }
        compiledStatement.sql = string;
        return compiledStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result execute(Result result) {
        try {
            Trace.check(!this.isClosed, 33, Trace.getMessage(222));
        }
        catch (Throwable throwable) {
            return new Result(throwable, null);
        }
        Database database = this.database;
        synchronized (database) {
            int n = result.iMode;
            if (this.sessionMaxRows == 0) {
                this.currentMaxRows = result.iUpdateCount;
            }
            this.sessionSCN = this.database.nextDMLSCN();
            DatabaseManager.gc();
            switch (n) {
                case 65548: {
                    Result result2 = this.sqlExecute(result);
                    result2 = this.performPostExecute(result2);
                    return result2;
                }
                case 9: {
                    Result result3 = this.sqlExecuteBatch(result);
                    result3 = this.performPostExecute(result3);
                    return result3;
                }
                case 65547: {
                    Result result4 = this.sqlExecuteDirectNoPreChecks(result.getMainString());
                    result4 = this.performPostExecute(result4);
                    return result4;
                }
                case 8: {
                    Result result5 = this.sqlExecuteBatchDirect(result);
                    result5 = this.performPostExecute(result5);
                    return result5;
                }
                case 65555: {
                    return this.sqlPrepare(result.getMainString());
                }
                case 65552: {
                    return this.sqlFreeStatement(result.getStatementID());
                }
                case 7: {
                    return this.getAttributes();
                }
                case 6: {
                    return this.setAttributes(result);
                }
                case 66541: {
                    switch (result.getEndTranType()) {
                        case 0: {
                            this.commit();
                            break;
                        }
                        case 1: {
                            this.rollback();
                            break;
                        }
                        case 4: {
                            try {
                                String string = result.getMainString();
                                this.releaseSavepoint(string);
                                break;
                            }
                            catch (Throwable throwable) {
                                return new Result(throwable, null);
                            }
                        }
                        case 2: {
                            try {
                                this.rollbackToSavepoint(result.getMainString());
                                break;
                            }
                            catch (Throwable throwable) {
                                return new Result(throwable, null);
                            }
                        }
                    }
                    return emptyUpdateCount;
                }
                case 66552: {
                    switch (result.getConnectionAttrType()) {
                        case 10027: {
                            try {
                                this.savepoint(result.getMainString());
                                break;
                            }
                            catch (Throwable throwable) {
                                return new Result(throwable, null);
                            }
                        }
                    }
                    return emptyUpdateCount;
                }
                case 65545: {
                    this.close();
                    return emptyUpdateCount;
                }
            }
            return Trace.toResult(Trace.error(202));
        }
    }

    private Result performPostExecute(Result result) {
        try {
            if (this.database != null) {
                this.database.sequenceManager.logSequences(this, this.database.logger);
            }
            return result;
        }
        catch (Exception exception) {
            return new Result(exception, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result sqlExecuteDirectNoPreChecks(String string) {
        Database database = this.database;
        synchronized (database) {
            return this.dbCommandInterpreter.execute(string);
        }
    }

    Result sqlExecuteCompiledNoPreChecks(CompiledStatement compiledStatement) {
        return this.compiledStatementExecutor.execute(compiledStatement);
    }

    private Result sqlPrepare(String string) {
        int n = this.compiledStatementManager.getStatementID(string);
        CompiledStatement compiledStatement = this.compiledStatementManager.getStatement(n);
        if (compiledStatement == null) {
            try {
                compiledStatement = this.sqlCompileStatement(string);
            }
            catch (Throwable throwable) {
                return new Result(throwable, string);
            }
            n = this.compiledStatementManager.registerStatement(n, compiledStatement);
        }
        this.compiledStatementManager.linkSession(n, this.sessionId);
        Result result = compiledStatement.describeResult();
        Result result2 = compiledStatement.describeParameters();
        return Result.newPrepareResponse(n, result, result2);
    }

    private Result sqlExecuteBatch(Result result) {
        int n = result.getStatementID();
        CompiledStatement compiledStatement = this.compiledStatementManager.getStatement(n);
        if (compiledStatement == null && (compiledStatement = this.recompileStatement(n)) == null) {
            return Trace.toResult(Trace.error(203));
        }
        Expression[] expressionArray = compiledStatement.parameters;
        int n2 = 0;
        int[] nArray = new int[result.getSize()];
        Record record = result.rRoot;
        while (record != null) {
            Result result2;
            Object[] objectArray = record.data;
            try {
                for (int i = 0; i < expressionArray.length; ++i) {
                    expressionArray[i].bind(objectArray[i]);
                }
                result2 = this.compiledStatementExecutor.execute(compiledStatement);
            }
            catch (Throwable throwable) {
                result2 = new Result(2);
            }
            if (result2.iMode == 1) {
                nArray[n2++] = result2.iUpdateCount;
            } else if (result2.iMode == 3) {
                nArray[n2++] = -2;
            } else {
                nArray = ArrayUtil.arraySlice(nArray, 0, n2);
                break;
            }
            record = record.next;
        }
        Result result3 = new Result(65548, nArray, 0);
        return result3;
    }

    private Result sqlExecuteBatchDirect(Result result) {
        int n = 0;
        int[] nArray = new int[result.getSize()];
        Record record = result.rRoot;
        while (record != null) {
            Result result2;
            String string = (String)record.data[0];
            try {
                result2 = this.dbCommandInterpreter.execute(string);
            }
            catch (Throwable throwable) {
                result2 = new Result(2);
            }
            if (result2.iMode == 1) {
                nArray[n++] = result2.iUpdateCount;
            } else if (result2.iMode == 3) {
                nArray[n++] = -2;
            } else {
                nArray = ArrayUtil.arraySlice(nArray, 0, n);
                break;
            }
            record = record.next;
        }
        Result result3 = new Result(65548, nArray, 0);
        return result3;
    }

    private Result sqlExecute(Result result) {
        int n = result.getStatementID();
        Object[] objectArray = result.getParameterData();
        CompiledStatement compiledStatement = this.compiledStatementManager.getStatement(n);
        if (compiledStatement == null && (compiledStatement = this.recompileStatement(n)) == null) {
            return Trace.toResult(Trace.error(203));
        }
        Expression[] expressionArray = compiledStatement.parameters;
        try {
            for (int i = 0; i < expressionArray.length; ++i) {
                expressionArray[i].bind(objectArray[i]);
            }
        }
        catch (Throwable throwable) {
            return new Result(throwable, compiledStatement.sql);
        }
        return this.compiledStatementExecutor.execute(compiledStatement);
    }

    private CompiledStatement recompileStatement(int n) {
        String string = this.compiledStatementManager.getSql(n);
        if (string == null) {
            return null;
        }
        Result result = this.sqlPrepare(string);
        if (result.iMode == 2) {
            this.compiledStatementManager.freeStatement(n, this.sessionId);
            return null;
        }
        return this.compiledStatementManager.getStatement(n);
    }

    private Result sqlFreeStatement(int n) {
        this.compiledStatementManager.freeStatement(n, this.sessionId);
        Result result = new Result(1);
        result.iUpdateCount = 1;
        return result;
    }

    Date getCurrentDate() {
        if (this.currentDateTimeSCN != this.sessionSCN) {
            this.currentDateTimeSCN = this.sessionSCN;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = HsqlDateTime.getCurrentDate(this.currentMillis);
            this.currentTime = null;
            this.currentTimestamp = null;
        } else if (this.currentDate == null) {
            this.currentDate = HsqlDateTime.getCurrentDate(this.currentMillis);
        }
        return this.currentDate;
    }

    Time getCurrentTime() {
        if (this.currentDateTimeSCN != this.sessionSCN) {
            this.currentDateTimeSCN = this.sessionSCN;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTime = HsqlDateTime.getNormalisedTime(this.currentMillis);
            this.currentTimestamp = null;
        } else if (this.currentTime == null) {
            this.currentTime = HsqlDateTime.getNormalisedTime(this.currentMillis);
        }
        return this.currentTime;
    }

    Timestamp getCurrentTimestamp() {
        if (this.currentDateTimeSCN != this.sessionSCN) {
            this.currentDateTimeSCN = this.sessionSCN;
            this.currentMillis = System.currentTimeMillis();
            this.currentDate = null;
            this.currentTime = null;
            this.currentTimestamp = HsqlDateTime.getTimestamp(this.currentMillis);
        } else if (this.currentTimestamp == null) {
            this.currentTimestamp = HsqlDateTime.getTimestamp(this.currentMillis);
        }
        return this.currentTimestamp;
    }

    Result getAttributes() {
        Result result = new Result(3, 7);
        result.metaData.sTable = new String[]{"", "", "", "", "", "", ""};
        result.metaData.sLabel = result.metaData.sTable;
        result.metaData.sName = result.metaData.sTable;
        result.metaData.colType = new int[]{12, 12, 4, this.iLastIdentity instanceof Long ? -5 : 4, 16, 16, 16};
        Object[] objectArray = new Object[]{this.database.getURI(), this.getUsername(), ValuePool.getInt(this.sessionId), this.iLastIdentity, ValuePool.getBoolean(this.isAutoCommit), ValuePool.getBoolean(this.database.databaseReadOnly), ValuePool.getBoolean(this.isReadOnly)};
        result.add(objectArray);
        return result;
    }

    Result setAttributes(Result result) {
        Object[] objectArray = result.rRoot.data;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            if (object == null) continue;
            try {
                switch (i) {
                    case 4: {
                        this.setAutoCommit((Boolean)object);
                        break;
                    }
                    case 6: {
                        this.setReadOnly((Boolean)object);
                    }
                }
                continue;
            }
            catch (HsqlException hsqlException) {
                return new Result(hsqlException, null);
            }
        }
        return emptyUpdateCount;
    }

    public String getInternalConnectionURL() {
        return "jdbc:hsqldb:" + this.database.getURI();
    }
}

