/*
 * Created on May 19, 2004
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros;


import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory; 
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.AboutWindow;
import org.parosproxy.paros.view.LicenseFrame;
import org.parosproxy.paros.view.View;

import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;



/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Paros {

    static {
	    System.setProperty("log4j.configuration","xml/log4j.properties");	    
    }
    
    private static Log log = LogFactory.getLog(Paros.class);
    
    private CommandLine cmdLine = null;
    
	public static void main(String[] args) throws Exception {
	    Paros paros = new Paros();
	    paros.init(args);
	    log.info(Constant.PROGRAM_NAME + " " + Constant.PROGRAM_VERSION + " started.");

	    paros.showLicense();
	    try {
	        paros.run();
	    } catch (Exception e) {
	        log.fatal(e.getStackTrace());
	        throw e;
	    }
		
	}
	
	private void run() throws Exception {
	    
	    
	    AboutWindow aboutWindow = null;
	    if (cmdLine.isGUI()) {
	        aboutWindow = new AboutWindow();
	        aboutWindow.show();
	    }
	    

	    Model.getSingleton().init();

		
		if (cmdLine.isGUI()) {
		    runGUI();
		    aboutWindow.dispose();
	    } else {
	        runCommandLine();
		    log.info(Constant.PROGRAM_NAME + " " + Constant.PROGRAM_VERSION + " terminated.");

	    }
	    
	}
	
	
	
	private void runGUI() throws ClassNotFoundException, Exception {

	    Control control = Control.getSingleton();
	    View view = View.getSingleton();
	    view.postInit();
		view.getMainFrame().show();
		view.setStatus("");
		
		control.getMenuFileControl().newSession(false);

	}
	
	private void runCommandLine() {
	    
	}
	

	/**
	 * Initialization without dependence on any data model nor view creation.
	 * @param args
	 */
	private void init(String[] args) {

	    HttpSender.setUserAgent(Constant.USER_AGENT);
	    try {
	        cmdLine = new CommandLine(args);
	    } catch (Exception e) {
	        displayHelp();
	        System.exit(1);
	    }

	    Locale.setDefault(Locale.ENGLISH);

		try {
  			UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
		}
	    catch(Exception e) {
		}

//	    System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
//	    System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
//	    System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.commons.httpclient", "error");

	    
	}

	private static void displayHelp() {
		String CRLF = "\r\n";
		String help =
			"Usage:" + CRLF +
			"javaw paros.jar" + CRLF +
			"java -jar paros.jar" + CRLF +
			"java -jar paros.jar [-session session_xml] [-policy policy_xml] [-scan] [-spider] [-report output_report]";
		System.out.println(help);
	}
	
	private void showLicense() {
	    if (!(new File("license/AcceptedLicense")).exists()){
	        
	        LicenseFrame license = new LicenseFrame();
	        license.show();
	        
	        while (!license.isAccepted()) {
	            try {
	                Thread.sleep(100);
	            } catch (InterruptedException e) {}
	        }
	    }
	    
	    try{
	        FileWriter fo = new FileWriter("license/AcceptedLicense");
	        fo.close();
	    }catch (IOException ie){
	        JOptionPane.showMessageDialog(new JFrame(), "Unknown Error. Please report to the author.");
	        System.exit(0);
	    }
	}
}

