/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.control;

import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.extension.encoder.ExtensionEncoder;
import org.parosproxy.paros.extension.filter.ExtensionFilter;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.report.ExtensionReport;
import org.parosproxy.paros.extension.scanner.ExtensionScanner;
import org.parosproxy.paros.extension.spider.ExtensionSpider;
import org.parosproxy.paros.extension.viewOption.ExtensionViewOption;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;


/**
 *
 * Overall control with interaction on model and view.
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class Control extends AbstractControl {
    
    private static Control control = null;
    private Proxy proxy = null;
    private MenuFileControl menuFileControl = null;
    private MenuEditControl menuEditControl = null;
    private MenuToolsControl menuToolsControl = null;
    
    private Control(Model model, View view) {
        super(model, view);
        init();
    }
    
    private void init() {
        
        PluginFactory.loadAllPlugin();
        
		// init all components before loading any plugin
        getProxy();
		
		// start plugin loading
		loadExtension();

		getExtensionLoader().hookProxyListener(getProxy());
		
		// post-init
		getProxy().startServer();
		
    }
    
    public Proxy getProxy() {
        if (proxy == null) {
            proxy = new Proxy(model, view);
        }
        
        return proxy;
    }
    
    protected void addExtension() {

        getExtensionLoader().addExtension(new ExtensionFilter());
        getExtensionLoader().addExtension(new ExtensionHistory());
        
        getExtensionLoader().addExtension(new ExtensionSpider());
        getExtensionLoader().addExtension(new ExtensionEncoder());
        getExtensionLoader().addExtension(new ExtensionScanner());
        getExtensionLoader().addExtension(new ExtensionViewOption());
        getExtensionLoader().addExtension(new ExtensionReport());
        

    }
    
    public MenuFileControl getMenuFileControl() {
        if (menuFileControl == null) {
            menuFileControl = new MenuFileControl(model, view, this);
        }

        return menuFileControl;
    }
    
    public MenuEditControl getMenuEditControl() {
        if (menuEditControl == null) {
            menuEditControl = new MenuEditControl(model, view);                
        }
        return menuEditControl;
    }

    public MenuToolsControl getMenuToolsControl() {
        if (menuToolsControl == null) {
            menuToolsControl = new MenuToolsControl(model, view, this);                
        }
        return menuToolsControl;
    }

    
    public static Control getSingleton() {
        if (control == null) {
            control = new Control(Model.getSingleton(), View.getSingleton());
        }
        return control;
    }
    

    

}
