/*
 * Created on Jun 6, 2004
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.core.proxy;

import org.parosproxy.paros.common.FileXML;
import org.w3c.dom.Document;



/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProxyParam extends FileXML {

	private static final String PROXY = "proxy";
	
	private static final String PROXY_IP = "proxyIp";
	private static final String PROXY_PORT = "proxyPort";
	private static final String PROXY_SSL_IP = "proxySSLIp";
	private static final String PROXY_SSL_PORT = "proxySSLPort";

	private static final String[] PATH_PROXY_IP = {PROXY, PROXY_IP};
	private static final String[] PATH_PROXY_PORT = {PROXY, PROXY_PORT};
	private static final String[] PATH_PROXY_SSL_IP = {PROXY, PROXY_SSL_IP};
	private static final String[] PATH_PROXY_SSL_PORT = {PROXY, PROXY_SSL_PORT};
	
		
	private String proxyIp = "localhost";
	private int proxyPort = 8080;
	private String proxySSLIp = "localhost";
	private int proxySSLPort = 8443;

	private Document mDoc = null;
	
	public ProxyParam() {
		super(PROXY);
	}
	
	protected void parse() {
		proxyIp = getValue(PROXY_IP);
		try {
			proxyPort = Integer.parseInt(getValue(PROXY_PORT));
		} catch (Exception e) {}

		proxySSLIp = getValue(PROXY_SSL_IP);
		try {
			proxySSLPort = Integer.parseInt(getValue(PROXY_SSL_PORT));
		} catch (Exception e) {}

		
	}
	
	public String getProxyIp() {
		return proxyIp;
	}
	
	public void setProxyIp(String proxyIp) {
		this.proxyIp = proxyIp.trim();
		setValue(PATH_PROXY_IP, this.proxyIp);
		
	}
	
	public int getProxyPort() {
		return proxyPort;
	}
	
	public void setProxyPort(int proxyPort) {
		this.proxyPort = proxyPort;
		setValue(PATH_PROXY_PORT, Integer.toString(this.proxyPort));
	}
	
	public String getProxySSLIp() {
		return proxySSLIp;
	}
	
	public void setProxySSLIp(String proxySSLIp) {
		this.proxySSLIp = proxySSLIp.trim();
		setValue(PATH_PROXY_SSL_IP, this.proxySSLIp);

	}
	
	public int getProxySSLPort() {
		return proxySSLPort;
	}
	
	public void setProxySSLPort(int proxySSLPort) {
		this.proxySSLPort = proxySSLPort;
		setValue(PATH_PROXY_SSL_PORT, Integer.toString(this.proxySSLPort));
	}
	

}
