/*
*
* Paros and its related class files.
* 
* Paros is an HTTP/HTTPS proxy for assessing web application security.
* Copyright (C) 2003-2004 Chinotec Technologies Company
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the Clarified Artistic License
* as published by the Free Software Foundation.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* Clarified Artistic License for more details.
* 
* You should have received a copy of the Clarified Artistic License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/
package org.parosproxy.paros.core.spider;

import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpMalformedHeaderException;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpResponseHeader;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class HttpMessageItem extends HttpMessage {
    private int depth = 0;
    
    /**
     * 
     */
    HttpMessageItem() {
        super();
    }
    
    HttpMessageItem(HttpMessage msg) {
        super(msg.getRequestHeader(), msg.getRequestBody(), msg.getResponseHeader(), msg.getResponseBody());
        
    }
    
    /**
     * @param reqHeader
     */
    HttpMessageItem(HttpRequestHeader reqHeader) {
        super(reqHeader);
    }
    /**
     * @param reqHeader
     * @param reqBody
     */
    HttpMessageItem(HttpRequestHeader reqHeader, HttpBody reqBody) {
        super(reqHeader, reqBody);
        // TODO Auto-generated constructor stub
    }
    /**
     * @param reqHeader
     * @param reqBody
     * @param resHeader
     * @param resBody
     */
    HttpMessageItem(HttpRequestHeader reqHeader, HttpBody reqBody,
            HttpResponseHeader resHeader, HttpBody resBody) {
        super(reqHeader, reqBody, resHeader, resBody);
    }
    /**
     * @param reqHeader
     * @param reqBody
     * @param resHeader
     * @param resBody
     * @throws HttpMalformedHeaderException
     */
    HttpMessageItem(String reqHeader, String reqBody, String resHeader,
            String resBody) throws HttpMalformedHeaderException {
        super(reqHeader, reqBody, resHeader, resBody);
    }

    void setDepth(int depth) {
        this.depth = depth;
    }
    int getDepth() {
        return depth;
    }
}
