/*
*
* Paros and its related class files.
* 
* Paros is an HTTP/HTTPS proxy for assessing web application security.
* Copyright (C) 2003-2004 Chinotec Technologies Company
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the Clarified Artistic License
* as published by the Free Software Foundation.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* Clarified Artistic License for more details.
* 
* You should have received a copy of the Clarified Artistic License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package org.parosproxy.paros.core.spider;

import java.util.regex.Pattern;

import org.parosproxy.paros.common.FileXML;


/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class SpiderParam extends FileXML {

	private static final String SPIDER = "spider";

	private static final String SPIDER_MAX_DEPTH = "maxDepth";
	private static final String SPIDER_THREAD = "thread";
	private static final String SPIDER_SCOPE = "scope";
	
	private static final String[] PATH_SPIDER_MAX_DEPTH = {SPIDER, SPIDER_MAX_DEPTH};
	private static final String[] PATH_SPIDER_THREAD = {SPIDER, SPIDER_THREAD};
	private static final String[] PATH_SPIDER_SCOPE = {SPIDER, SPIDER_SCOPE};
	
	private int maxDepth = 5;
	private int thread = 2;
	private String scope = "";
	
	private Pattern patternScope = null;
	
    /**
     * @param rootElementName
     */
    public SpiderParam() {
        super(SPIDER);
    }

    /* (non-Javadoc)
     * @see com.proofsecure.paros.common.FileXML#parse()
     */
    protected void parse() throws Exception {
        
		try {
			setThread(Integer.parseInt(getValue(SPIDER_THREAD)));
		} catch (Exception e) {}
		try {
			setMaxDepth(Integer.parseInt(getValue(SPIDER_MAX_DEPTH)));
		} catch (Exception e) {}
		setScope(getValue(SPIDER_SCOPE));

    }

    /**
     * @return Returns the maxDepth.
     */
    public int getMaxDepth() {
        return maxDepth;
    }
    /**
     * @param maxDepth The maxDepth to set.
     */
    public void setMaxDepth(int maxDepth) {
        this.maxDepth = maxDepth;
		setValue(PATH_SPIDER_MAX_DEPTH, Integer.toString(this.maxDepth));

    }
    /**
     * @return Returns the scope.
     */
    public String getScope() {
        return scope;
    }
    /**
     * @param scope The scope to set.
     */
    public void setScope(String scope) {
        this.scope = scope;
		setValue(PATH_SPIDER_SCOPE, this.scope);
		parseScope(this.scope);
    }
    /**
     * @return Returns the thread.
     */
    public int getThread() {
        return thread;
    }
    /**
     * @param thread The thread to set.
     */
    public void setThread(int thread) {
        this.thread = thread;
		setValue(PATH_SPIDER_THREAD, Integer.toString(this.thread));

    }
	
	/**
	Check if given host name need to send using proxy.
	@param	hostName	host name to be checked.
	@return	true = need to send via proxy.
	*/
	public boolean isInScope(String hostName) {
		if (patternScope == null || hostName == null) {
		    return false;
		}
		
		return patternScope.matcher(hostName).find();
	}
	
	/**
	Parse the proxy chain skip text string and build the regex pattern.
	*/
	private void parseScope(String scope) {
		patternScope = null;

		if (scope == null || scope.equals("")) {
			return;
		}
		
		scope = scope.replaceAll("\\.", "\\\\.");
		scope = scope.replaceAll("\\*",".*?").replaceAll("(;+$)|(^;+)", "");
		scope = "(" + scope.replaceAll(";+", "|") + ")$";
		patternScope = Pattern.compile(scope, Pattern.CASE_INSENSITIVE);
	}
}
