/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.extension.history;

import java.sql.SQLException;
import java.util.List;

import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;

import org.parosproxy.paros.db.RecordHistory;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.SessionListener;
import org.parosproxy.paros.model.HistoryList;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.view.HttpPanel;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ExtensionHistory extends ExtensionAdaptor implements SessionListener {

    private static final int FILTER_NONE = 0;
    private static final int FILTER_REQUEST = 1;
    private static final int FILTER_RESPONSE = 2;
    
	private LogPanel logPanel = null;  //  @jve:decl-index=0:visual-constraint="161,134"
	private ProxyListenerLog proxyListener = null;
	private HistoryList historyList = null;
    private String filter = "";
    	
	private HistoryFilterDialog filterDialog = null;
	private JCheckBoxMenuItem menuFilterHistoryByRequest = null;  //  @jve:decl-index=0:visual-constraint="68,100"
	private JCheckBoxMenuItem menuFilterHistoryByResponse = null;
	private int stateFilter = FILTER_NONE;

	
    /**
     * 
     */
    public ExtensionHistory() {
        super();
 		initialize();
    }

    /**
     * @param name
     */
    public ExtensionHistory(String name) {
        super(name);
    }

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
        this.setName("ExtensionHistory");
			
	}
	
	/**
	 * This method initializes logPanel	
	 * 	
	 * @return com.proofsecure.paros.extension.history.LogPanel	
	 */    
	private LogPanel getLogPanel() {
		if (logPanel == null) {
			logPanel = new LogPanel();
			logPanel.setName("History");
		}
		return logPanel;
	}
	public void hook(ExtensionHook extensionHook) {
	    super.hook(extensionHook);
	    ExtensionHookView pv = extensionHook.getHookView();
	    pv.addStatusPanel(getLogPanel());
	    //pv.addWorkPanel(getRequestPanel());
	    //pv.addWorkPanel(getResponsePanel());
	    getLogPanel().setDisplayPanel(getView().getRequestPanel(), getView().getResponsePanel());
	    
        extensionHook.addProxyListener(getProxyListenerLog());
        extensionHook.addSessionListener(this);
        
        extensionHook.getHookMenu().addViewMenuItem(getMenuFilterHistoryByRequest());
        extensionHook.getHookMenu().addViewMenuItem(getMenuFilterHistoryByResponse());

	}
	
	public void sessionChanged(Session session)  {
	    getHistoryList().clear();
	    getLogPanel().getListLog().setModel(getHistoryList());
		getView().getRequestPanel().setMessage("","", true);
		getView().getResponsePanel().setMessage("","", false);
		
		try {
		    List list = getModel().getDb().getTableHistory().getHistoryList(session.getSessionId(), HistoryReference.TYPE_MANUAL);
		    buildHistory(getHistoryList(), list);
		} catch (SQLException e) {}
	}
	
	private ProxyListenerLog getProxyListenerLog() {
        if (proxyListener == null) {
            proxyListener = new ProxyListenerLog(getModel(), getView(), getHistoryList());
        }
        return proxyListener;
	}
	
	private HistoryList getHistoryList() {
	    if (historyList == null) {
	        historyList = new HistoryList();
	    }
	    return historyList;
	}
	
	private void searchHistory(String filter, boolean isRequest) {
	    Session session = getModel().getSession();
	    synchronized (historyList) {
	        try {
	            List list = getModel().getDb().getTableHistory().getHistoryList(session.getSessionId(), HistoryReference.TYPE_MANUAL, filter, isRequest);
	            buildHistory(getHistoryList(), list);
	        } catch (SQLException e) {}
	    } 
	}
	
	private void buildHistory(HistoryList historyList, List dbList) {
	    
	    synchronized (historyList) {
	        historyList.clear();
	        HistoryReference historyRef = null;
	        
	        for (int i=0; i<dbList.size(); i++) {
	            int historyId = ((Integer) dbList.get(i)).intValue();
	            
	            try {
	                historyRef = new HistoryReference(historyId);
	                historyList.addElement(historyRef);
	                
	            } catch (Exception e) {};
	        }
	    }

   }
	/**
	 * This method initializes filterDialog	
	 * 	
	 * @return com.proofsecure.paros.extension.history.SearchDialog	
	 */    
	private HistoryFilterDialog getFilterDialog() {
		if (filterDialog == null) {
			filterDialog = new HistoryFilterDialog(getView().getMainFrame(), true);
		}
		return filterDialog;
	}
	/**
	 * This method initializes menuFilterHistoryByRequest	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */    
	private JCheckBoxMenuItem getMenuFilterHistoryByRequest() {
		if (menuFilterHistoryByRequest == null) {
			menuFilterHistoryByRequest = new JCheckBoxMenuItem();
			menuFilterHistoryByRequest.setText("Filter History by Request");
			menuFilterHistoryByRequest.addActionListener(new java.awt.event.ActionListener() { 

				public void actionPerformed(java.awt.event.ActionEvent e) {    

				    int result = showFilterDialog(true);
				    switch(result)
				    {
				    case -1:	menuFilterHistoryByRequest.setSelected(false);
				    			menuFilterHistoryByResponse.setSelected(false);
				    			stateFilter = FILTER_NONE;
				    			break;
				    case 0:		menuFilterHistoryByRequest.setSelected(false);
				    			menuFilterHistoryByResponse.setSelected(false);
				        		if (stateFilter == FILTER_REQUEST) {
				        			menuFilterHistoryByRequest.setSelected(true);
				        		} else if (stateFilter == FILTER_RESPONSE) {
				        		    menuFilterHistoryByResponse.setSelected(true);
				        		}
				        		break;
				    case 1:		menuFilterHistoryByRequest.setSelected(true);
				    			menuFilterHistoryByResponse.setSelected(false);
				    			stateFilter = FILTER_REQUEST;
				    			break;
				    }
				}
			});

		}
		return menuFilterHistoryByRequest;
	}
	
	private int showFilterDialog(boolean isRequest) {
		HistoryFilterDialog dialog = getFilterDialog();
		dialog.setModal(true);
		int exit = dialog.showDialog();
		int result = 0;		// cancel, state unchanged
		if (exit == JOptionPane.OK_OPTION) {
		    filter = dialog.getPattern();
		    getProxyListenerLog().setFilter(filter);
		    searchHistory(filter, isRequest);
		    result = 1;		// applied
		    
		} else if (exit == JOptionPane.NO_OPTION) {
		    filter = "";
		    getProxyListenerLog().setFilter(filter);
		    searchHistory(filter, isRequest);
		    result = -1;	// reset
		}
		
		return result;
	}
	
	/**
	 * This method initializes menuFilterHistoryByResponse	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */    
	private JCheckBoxMenuItem getMenuFilterHistoryByResponse() {
		if (menuFilterHistoryByResponse == null) {
			menuFilterHistoryByResponse = new JCheckBoxMenuItem();
			menuFilterHistoryByResponse.setText("Filter History by Response");
			menuFilterHistoryByResponse.addActionListener(new java.awt.event.ActionListener() { 
				public void actionPerformed(java.awt.event.ActionEvent e) {
				    int result = showFilterDialog(false);
				    switch(result) {
			    case -1:	menuFilterHistoryByRequest.setSelected(false);
			    			menuFilterHistoryByResponse.setSelected(false);
			    			stateFilter = FILTER_NONE;
			    			break;

			    case 0:		menuFilterHistoryByRequest.setSelected(false);
			    			menuFilterHistoryByResponse.setSelected(false);
			        		if (stateFilter == FILTER_REQUEST) {
			        			menuFilterHistoryByRequest.setSelected(true);
			        		} else if (stateFilter == FILTER_RESPONSE) {
			        		    menuFilterHistoryByResponse.setSelected(true);
			        		}
			        		break;
			    case 1:		menuFilterHistoryByRequest.setSelected(false);
			    			menuFilterHistoryByResponse.setSelected(true);
			    			stateFilter = FILTER_RESPONSE;
			    			break;
			    }

				}
			});
		}
		return menuFilterHistoryByResponse;
	}
   }
