/*
 * Created on 2004~74
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.extension.history;

import java.awt.BorderLayout;

import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.HttpPanel;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class LogPanel extends AbstractPanel {
	private javax.swing.JScrollPane scrollLog = null;
	private javax.swing.JList listLog = null;
	
	private HttpPanel requestPanel = null;
	private HttpPanel responsePanel = null;
	
	/**
	 * This is the default constructor
	 */
	public LogPanel() {
		super();
		initialize();
	}
	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private  void initialize() {
		this.setLayout(new BorderLayout());
		this.setSize(600, 200);
		this.add(getScrollLog(), java.awt.BorderLayout.CENTER);
	}
	/**

	 * This method initializes scrollLog	

	 * 	

	 * @return javax.swing.JScrollPane	

	 */    
	private javax.swing.JScrollPane getScrollLog() {
		if (scrollLog == null) {
			scrollLog = new javax.swing.JScrollPane();
			scrollLog.setViewportView(getListLog());
			scrollLog.setHorizontalScrollBarPolicy(javax.swing.JScrollPane.HORIZONTAL_SCROLLBAR_NEVER);
			scrollLog.setVerticalScrollBarPolicy(javax.swing.JScrollPane.VERTICAL_SCROLLBAR_ALWAYS);
			scrollLog.setPreferredSize(new java.awt.Dimension(800,200));
			scrollLog.setName("scrollLog");
		}
		return scrollLog;
	}

	/**

	 * This method initializes listLog	

	 * 	

	 * @return javax.swing.JList	

	 */    
	public javax.swing.JList getListLog() {
		if (listLog == null) {
			listLog = new javax.swing.JList();
			listLog.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
			listLog.addListSelectionListener(new javax.swing.event.ListSelectionListener() { 

				public void valueChanged(javax.swing.event.ListSelectionEvent e) {

					HistoryReference historyRef = (HistoryReference) listLog.getSelectedValue();
					HttpMessage msg = null;
					
					try {
						msg = historyRef.getHttpMessage();
						if (msg.getRequestHeader().isEmpty()) {
						    requestPanel.setMessage(null, true);
						} else {
				            requestPanel.setMessage(msg, true);
						}
						
				        if (msg.getResponseHeader().isEmpty()) {
				            responsePanel.setMessage(null, false);
				        } else {
				            responsePanel.setMessage(msg, false);
				        }
					} catch (Exception e1) {
						e1.printStackTrace();
					}
				}


			});

		}
		return listLog;
	}
	
	public void setDisplayPanel(HttpPanel requestPanel, HttpPanel responsePanel) {
		this.requestPanel = requestPanel;
		this.responsePanel = responsePanel;

	}

  }
