/*
 * Created on Jun 17, 2004
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.extension.history;
 
//import org.apache.commons.httpclient.HttpMethod;
//import org.apache.commons.httpclient.methods.EntityEnclosingMethod;
//import org.apache.commons.httpclient.methods.PostMethod;

import java.util.regex.Pattern;

import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.model.HistoryList;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpHeader;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpStatusCode;


/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ProxyListenerLog implements ProxyListener {
    
	private ViewDelegate view = null;
	private Model model = null;
	private HistoryList historyList = null;
	private Pattern pattern = null;
	
	
	public ProxyListenerLog(Model model, ViewDelegate view, HistoryList historyList) {
	    this.model = model;
	    this.view = view;
	    this.historyList = historyList;
	}

	public void setFilter(String filter) {
	    if (filter == null || filter.equals("")) {
	        pattern = null;
	    } else {
	        pattern = Pattern.compile(filter, Pattern.CASE_INSENSITIVE | Pattern.MULTILINE);
	    }
	}
	
	/* (non-Javadoc)
	 * @see com.proofsecure.paros.proxy.ProxyHandler#onHttpRequestReceived(org.apache.commons.httpclient.HttpMethod)
	 */
	public void onHttpRequestSend(HttpMessage msg) {
	    if (msg.getRequestHeader().isImage()) {
	        return;
	    }
	    
	    view.getSiteTreePanel().expandRoot();
	    
	    HttpMessage existingMsg = model.getSession().getSiteTree().pollPath(msg);

	    // check if a msg of the same type exist
	    if (existingMsg != null && !existingMsg.getResponseHeader().isEmpty()) {
	        if (HttpStatusCode.isSuccess(existingMsg.getResponseHeader().getStatusCode())) {
	            // exist, no modification necessary
	            return;
	        }
	    }

	    // if not, make sure a new copy will be obtained
	    if (msg.getRequestHeader().getHeader(HttpHeader.IF_MODIFIED_SINCE) != null) {
	        msg.getRequestHeader().setHeader(HttpHeader.IF_MODIFIED_SINCE, null);
	    }
	    
	    if (msg.getRequestHeader().getHeader(HttpHeader.IF_NONE_MATCH) != null) {
	        msg.getRequestHeader().setHeader(HttpHeader.IF_NONE_MATCH, null);
	    }

	}
	
	/* (non-Javadoc)
	 * @see com.proofsecure.paros.proxy.ProxyHandler#onHttpResponseSend(org.apache.commons.httpclient.HttpMethod, com.proofsecure.paros.proxy.HttpMessage)
	 */
	public void onHttpResponseReceive(HttpMessage msg) {

		if (isSkipImage(msg.getRequestHeader()) || isSkipImage(msg.getResponseHeader())) {
			return;
		}
				
		HistoryReference historyRef = null;
        try {
            historyRef = new HistoryReference(model.getSession(), HistoryReference.TYPE_MANUAL, msg);
        } catch (Exception e) {
            return;
        }
        synchronized(historyList) {
		    if (pattern == null) {
			    historyList.addElement(historyRef);		        
		    } else {
		        StringBuffer sb = new StringBuffer();
		        sb.append(msg.getRequestHeader().toString());
		        sb.append(msg.getRequestBody().toString());
		        if (!msg.getResponseHeader().isEmpty()) {
		            sb.append(msg.getResponseHeader().toString());
			        sb.append(msg.getResponseBody().toString());

		        }
		        if (pattern.matcher(sb.toString()).find()) {
				    historyList.addElement(historyRef);
		        }
		    }
		}

	    model.getSession().getSiteTree().addPath(historyRef);

	}
	    
    public boolean isSkipImage(HttpHeader header) {
		if (header.isImage() && !model.getOptionsParam().getViewParam().isProcessImages()) {
			return true;
		}
			
		return false;
				
	}
}
