/*
*
* Paros and its related class files.
* 
* Paros is an HTTP/HTTPS proxy for assessing web application security.
* Copyright (C) 2003-2004 Chinotec Technologies Company
* 
* This program is free software; you can redistribute it and/or
* modify it under the terms of the Clarified Artistic License
* as published by the Free Software Foundation.
* 
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
* Clarified Artistic License for more details.
* 
* You should have received a copy of the Clarified Artistic License
* along with this program; if not, write to the Free Software
* Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
*/

package org.parosproxy.paros.model;

import org.parosproxy.paros.common.FileXML;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class ViewParam extends FileXML {

	private static final String ROOT = "view";

	private static final String PROCESS_IMAGES = "processImages";
	
	private static final String[] PATH_PROCESS_IMAGES = {ROOT, PROCESS_IMAGES};

	private int processImages = 0;
		
	
    /**
     * @param rootElementName
     */
    public ViewParam() {
        super(ROOT);
    }

    /* (non-Javadoc)
     * @see com.proofsecure.paros.common.FileXML#parse()
     */
    protected void parse() throws Exception {
        

	    int tempProcessImages = 0;
	    
	    // use temp variable to check.  Exception will be flagged if any error.
		tempProcessImages = Integer.parseInt(getValue(PROCESS_IMAGES));

		// set member variable after here
		processImages = tempProcessImages;

		
    }

	/**
	 * @return Returns the skipImage.
	 */
	public int getProcessImages() {
		return processImages;
	}
	
	/**
	 * @param processImages 0 = not to process.  Other = process images
	 * 
	 */
	public void setProcessImages(int processImages) {
		this.processImages = processImages;
		setValue(PATH_PROCESS_IMAGES, Integer.toString(processImages));
	}
	
	public boolean isProcessImages() {
		return !(processImages == 0);
	}

	
}
