/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.view;

import java.awt.LayoutManager;

import javax.swing.JPanel;

import javax.swing.JLabel;
import javax.swing.ImageIcon;

import org.parosproxy.paros.Constant;

/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class AboutPanel extends JPanel {

    private static final String PRODUCT  = Constant.PROGRAM_NAME;
    private static final String VERSION = "Version " + Constant.PROGRAM_VERSION;
    private static final String COPYRIGHT = "Copyright (C) 2003-2004 Chinotec Technologies Company";
    private static final String LICENSE_DETAIL = 
        "<html><body><p>"
        + "This program is free software; you can redistribute it and/or "
        + "modify it under the terms of the Clarified Artistic License as published in the Free Software Foundation.  "
        + "This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; "
        + "without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. "
        + "See the Clarified Artistic License for more details."
        + "</p>"
        + "<p>For queries please send to <font color='blue'>contact@parosproxy.org</font></p>"
        + "</body></html>";
    
    private static final String OTHER_LICENSE =
        "<html><body>"
        
        + "<p>This product includes software developed by the Apache Software Foundation <A>http://www.apache.org</A> licensed under Apache License 2.0.</p>"
        + "<p>HSQLDB is licensed under BSD license.</p>"
        + "<p>The Copyrights of these softwares belong to their respective owners."
        + "</body></html>";
        
    
	private JLabel lblName = null;
    /**
     * 
     */
    public AboutPanel() {
        super();
        // TODO Auto-generated constructor stub
   
		initialize();
 }

    /**
     * @param arg0
     */
    public AboutPanel(boolean arg0) {
        super(arg0);
        // TODO Auto-generated constructor stub
   
		initialize();
 }

    /**
     * @param arg0
     */
    public AboutPanel(LayoutManager arg0) {
        super(arg0);
        // TODO Auto-generated constructor stub
   
		initialize();
 }

    /**
     * @param arg0
     * @param arg1
     */
    public AboutPanel(LayoutManager arg0, boolean arg1) {
        super(arg0, arg1);
        // TODO Auto-generated constructor stub
   
		initialize();
 }

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private  void initialize() {
		lblName = new JLabel();
		javax.swing.JLabel lblCopyright = new JLabel();

		javax.swing.JLabel lblOtherCopyright = new JLabel();

		javax.swing.JLabel lblVersion = new JLabel();

		javax.swing.JLabel lblProgramName = new JLabel();

		javax.swing.JLabel lblCopyrightDetail = new JLabel();

		javax.swing.JLabel lblLogo = new JLabel();

		this.setLayout(null);
		this.setSize(402, 310);
		this.setBackground(java.awt.Color.white);
		this.setBorder(javax.swing.BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.RAISED));
		lblLogo.setText("");
		lblLogo.setIcon(new ImageIcon(getClass().getResource("/resource/paros_logo64x64.gif")));
		lblLogo.setBounds(16, 10, 86, 64);
		lblCopyrightDetail.setBounds(10, 120, 385, 116);
		lblCopyrightDetail.setText(LICENSE_DETAIL);
		lblProgramName.setBounds(357, 11, 32, 38);
		lblProgramName.setText(PRODUCT);
		lblProgramName.setFont(new java.awt.Font("Default", java.awt.Font.BOLD, 36));
		lblVersion.setBounds(110, 75, 288, 20);
		lblVersion.setText(VERSION);
		lblVersion.setFont(new java.awt.Font("Default", java.awt.Font.PLAIN, 18));
		lblOtherCopyright.setBounds(10, 239, 385, 63);
		lblOtherCopyright.setText(OTHER_LICENSE);
		lblCopyright.setBounds(110, 100, 289, 17);
		lblCopyright.setText(COPYRIGHT);
		lblName.setBounds(110, 11, 137, 60);
		lblName.setIcon(new ImageIcon(getClass().getResource("/resource/paros_name.gif")));
		lblName.setText("");
		this.add(lblLogo, null);
		this.add(lblName, null);
		this.add(lblProgramName, null);
		this.add(lblVersion, null);
		this.add(lblCopyright, null);
		this.add(lblCopyrightDetail, null);
		this.add(lblOtherCopyright, null);
		lblProgramName.setVisible(false);
	}
}  //  @jve:decl-index=0:visual-constraint="7,0"
