/*
 *
 * Paros and its related class files.
 * 
 * Paros is an HTTP/HTTPS proxy for assessing web application security.
 * Copyright (C) 2003-2004 Chinotec Technologies Company
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the Clarified Artistic License
 * as published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * Clarified Artistic License for more details.
 * 
 * You should have received a copy of the Clarified Artistic License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */
package org.parosproxy.paros.view;

import java.awt.Component;
import java.util.List;

import javax.swing.JPopupMenu;

import javax.swing.JMenuItem;

import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.extension.ExtensionPopupMenu;
/**
 *
 * To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Generation - Code and Comments
 */
public class MainPopupMenu extends JPopupMenu {

    private List itemList = null;
	private PopupFindMenu popupFindMenu = null;  //  @jve:decl-index=0:visual-constraint="125,151"
	private PopupDeleteMenu popupDeleteMenu = null;
    /**
     * 
     */
    public MainPopupMenu() {
        super();
 		initialize();
   }

    /**
     * @param arg0
     */
    public MainPopupMenu(String arg0) {
        super(arg0);
    }
    
    public MainPopupMenu(List itemList) {
        this();
        this.itemList = itemList;
    }
    

	/**
	 * This method initializes this
	 * 
	 * @return void
	 */
	private void initialize() {
        //this.setVisible(true);
        
	    // added pre-set popup menu here
        this.add(getPopupFindMenu());
        this.add(getPopupDeleteMenu());
	}
	
	public synchronized void show(Component invoker, int x, int y) {
	    
	    boolean isFirst = true;
	    ExtensionPopupMenu menu = null;
	    
	    for (int i=0; i<getComponentCount(); i++) {
	        if (getComponent(i) != null && getComponent(i) instanceof ExtensionPopupMenu) {
	            menu = (ExtensionPopupMenu) getComponent(i);
	            menu.setEnabled(menu.isEnableForComponent(invoker) && menu.isEnabled());
	        }
	    }
	    
	    for (int i=0; i<itemList.size(); i++) {
	        menu = (ExtensionPopupMenu) itemList.get(i);
	        if (menu.isEnableForComponent(invoker)) {
	            this.add(menu);
	            isFirst = false;
	        }
	    }
	    super.show(invoker, x, y);
	}
	/**
	 * This method initializes popupFindMenu	
	 * 	
	 * @return com.proofsecure.paros.view.PopupFindMenu	
	 */    
	private PopupFindMenu getPopupFindMenu() {
		if (popupFindMenu == null) {
			popupFindMenu = new PopupFindMenu();
		}
		return popupFindMenu;
	}
	/**
	 * This method initializes popupDeleteMenu	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */    
	private JMenuItem getPopupDeleteMenu() {
		if (popupDeleteMenu == null) {
			popupDeleteMenu = new PopupDeleteMenu();
		}
		return popupDeleteMenu;
	}
   }

