/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.IOException;
import org.hsqldb.CachedRow;
import org.hsqldb.HsqlException;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Trace;
import org.hsqldb.lib.DoubleIntTable;
import org.hsqldb.rowio.RowInputInterface;
import org.hsqldb.rowio.RowOutputInterface;

class DiskNode
extends Node {
    protected Row rData;
    private int iLeft = -1;
    private int iRight = -1;
    private int iParent = -1;
    private int iId;

    DiskNode(CachedRow cachedRow, RowInputInterface rowInputInterface, int n) throws IOException, HsqlException {
        this.iId = n;
        this.rData = cachedRow;
        this.iBalance = rowInputInterface.readIntData();
        this.iLeft = rowInputInterface.readIntData();
        if (this.iLeft <= 0) {
            this.iLeft = -1;
        }
        this.iRight = rowInputInterface.readIntData();
        if (this.iRight <= 0) {
            this.iRight = -1;
        }
        this.iParent = rowInputInterface.readIntData();
        if (this.iParent <= 0) {
            this.iParent = -1;
        }
    }

    DiskNode(CachedRow cachedRow, int n) {
        this.iId = n;
        this.rData = cachedRow;
    }

    void delete() {
        this.iBalance = -2;
    }

    int getKey() {
        if (this.rData != null) {
            return ((CachedRow)this.rData).iPos;
        }
        return -1;
    }

    Row getRow() throws HsqlException {
        Trace.doAssert(this.rData != null);
        return this.rData;
    }

    private Node findNode(int n) throws HsqlException {
        Node node = null;
        CachedRow cachedRow = ((CachedRow)this.rData).getTable().getRow(n, null);
        if (cachedRow != null) {
            node = cachedRow.getNode(this.iId);
        }
        return node;
    }

    Node getLeft() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        if (this.iLeft == -1) {
            return null;
        }
        return this.findNode(this.iLeft);
    }

    void setLeft(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        ((CachedRow)this.rData).setChanged();
        this.iLeft = -1;
        if (node != null) {
            this.iLeft = node.getKey();
        }
    }

    Node getRight() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        if (this.iRight == -1) {
            return null;
        }
        return this.findNode(this.iRight);
    }

    void setRight(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        ((CachedRow)this.rData).setChanged();
        this.iRight = -1;
        if (node != null) {
            this.iRight = node.getKey();
        }
    }

    Node getParent() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        if (this.iParent == -1) {
            return null;
        }
        return this.findNode(this.iParent);
    }

    boolean isRoot() {
        return this.iParent == -1;
    }

    void setParent(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        ((CachedRow)this.rData).setChanged();
        this.iParent = -1;
        if (node != null) {
            this.iParent = node.getKey();
        }
    }

    void setBalance(int n) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        if (this.iBalance != n) {
            ((CachedRow)this.rData).setChanged();
            this.iBalance = n;
        }
    }

    boolean isFromLeft() throws HsqlException {
        if (this.isRoot()) {
            return true;
        }
        Trace.doAssert(this.getParent() != null);
        DiskNode diskNode = (DiskNode)this.getParent();
        if (diskNode.iLeft != -1) {
            return this.getKey() == diskNode.iLeft;
        }
        return this.equals(diskNode.getLeft());
    }

    Object[] getData() throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        return this.rData.getData();
    }

    boolean equals(Node node) throws HsqlException {
        Trace.doAssert(this.iBalance != -2);
        if (node != this) {
            boolean bl;
            boolean bl2 = bl = this.getKey() == -1 || node == null || node.getKey() != this.getKey();
            if (!bl) {
                boolean bl3 = bl = this.iParent == ((DiskNode)node).iParent && this.iLeft == ((DiskNode)node).iLeft && this.iRight == ((DiskNode)node).iRight;
                if (!bl) {
                    int n = ((CachedRow)this.getRow()).iLastAccess;
                    int n2 = ((CachedRow)node.getRow()).iLastAccess;
                    Trace.doAssert(bl, "a: " + n + ", " + this.iParent + ", " + this.iLeft + ", " + this.iRight + " b: " + n2 + ", " + ((DiskNode)node).iParent + ", " + ((DiskNode)node).iLeft + ", " + ((DiskNode)node).iRight);
                }
            }
        }
        return this == node || node != null && this.getKey() == ((DiskNode)node).getKey();
    }

    void write(RowOutputInterface rowOutputInterface) throws IOException, HsqlException {
        rowOutputInterface.writeIntData(this.iBalance);
        rowOutputInterface.writeIntData(this.iLeft == -1 ? 0 : this.iLeft);
        rowOutputInterface.writeIntData(this.iRight == -1 ? 0 : this.iRight);
        rowOutputInterface.writeIntData(this.iParent == -1 ? 0 : this.iParent);
    }

    Node getUpdatedNode() throws HsqlException {
        Row row = this.rData.getUpdatedRow();
        return row == null ? null : row.getNode(this.iId);
    }

    void writeTranslate(RowOutputInterface rowOutputInterface, DoubleIntTable doubleIntTable) throws IOException, HsqlException {
        rowOutputInterface.writeIntData(this.iBalance);
        this.writeTranslatePointer(this.iLeft, rowOutputInterface, doubleIntTable);
        this.writeTranslatePointer(this.iRight, rowOutputInterface, doubleIntTable);
        this.writeTranslatePointer(this.iParent, rowOutputInterface, doubleIntTable);
    }

    private void writeTranslatePointer(int n, RowOutputInterface rowOutputInterface, DoubleIntTable doubleIntTable) throws IOException, HsqlException {
        int n2 = 0;
        if (n != -1) {
            int n3 = doubleIntTable.find(0, n);
            if (n3 == -1) {
                throw Trace.error(130);
            }
            n2 = doubleIntTable.get(n3, 1);
        }
        rowOutputInterface.writeIntData(n2);
    }
}

