/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Locale;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.CommandLine;
import org.parosproxy.paros.control.Control;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.view.AboutWindow;
import org.parosproxy.paros.view.LicenseFrame;
import org.parosproxy.paros.view.View;

public class Paros {
    private static Log log;
    private CommandLine cmdLine = null;
    static /* synthetic */ Class class$org$parosproxy$paros$Paros;

    public static void main(String[] stringArray) throws Exception {
        Paros paros = new Paros();
        paros.init(stringArray);
        log.info("Paros 3.2.0alpha started.");
        paros.showLicense();
        try {
            paros.run();
        }
        catch (Exception exception) {
            log.fatal(exception.getStackTrace());
            throw exception;
        }
    }

    private void run() throws Exception {
        AboutWindow aboutWindow = null;
        if (this.cmdLine.isGUI()) {
            aboutWindow = new AboutWindow();
            aboutWindow.show();
        }
        Model.getSingleton().init();
        if (this.cmdLine.isGUI()) {
            this.runGUI();
            aboutWindow.dispose();
        } else {
            this.runCommandLine();
            log.info("Paros 3.2.0alpha terminated.");
        }
    }

    private void runGUI() throws ClassNotFoundException, Exception {
        Control control = Control.getSingleton();
        View view = View.getSingleton();
        view.postInit();
        view.getMainFrame().show();
        view.setStatus("");
        control.getMenuFileControl().newSession(false);
    }

    private void runCommandLine() {
    }

    private void init(String[] stringArray) {
        HttpSender.setUserAgent("Paros/3.2.0alpha");
        try {
            this.cmdLine = new CommandLine(stringArray);
        }
        catch (Exception exception) {
            Paros.displayHelp();
            System.exit(1);
        }
        Locale.setDefault(Locale.ENGLISH);
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void displayHelp() {
        String string = "\r\n";
        String string2 = "Usage:" + string + "javaw paros.jar" + string + "java -jar paros.jar" + string + "java -jar paros.jar [-session session_xml] [-policy policy_xml] [-scan] [-spider] [-report output_report]";
        System.out.println(string2);
    }

    private void showLicense() {
        Object object;
        if (!new File("license/AcceptedLicense").exists()) {
            object = new LicenseFrame();
            ((LicenseFrame)object).show();
            while (!((LicenseFrame)object).isAccepted()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        try {
            object = new FileWriter("license/AcceptedLicense");
            ((OutputStreamWriter)object).close();
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(new JFrame(), "Unknown Error. Please report to the author.");
            System.exit(0);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        System.setProperty("log4j.configuration", "xml/log4j.properties");
        log = LogFactory.getLog(class$org$parosproxy$paros$Paros == null ? (class$org$parosproxy$paros$Paros = Paros.class$("org.parosproxy.paros.Paros")) : class$org$parosproxy$paros$Paros);
    }
}

