/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.proxy;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyParam;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.proxy.ProxyThreadSSL;
import org.parosproxy.paros.network.ConnectionParam;
import org.parosproxy.paros.network.HttpBody;
import org.parosproxy.paros.network.HttpInputStream;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.network.HttpOutputStream;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.HttpSender;
import org.parosproxy.paros.network.HttpUtil;

class ProxyThread
implements Runnable {
    private static final int BUFFEREDSTREAM_SIZE = 8192;
    private static final String CONNECT_HTTP_200 = "HTTP/1.0 200 Connection established\r\nProxy-connection: Keep-alive\r\n\r\n";
    private static ArrayList processForwardList = new ArrayList();
    protected ProxyServer parentServer = null;
    protected ProxyParam proxyParam = null;
    protected ConnectionParam connectionParam = null;
    protected Thread thread = null;
    protected Socket inSocket = null;
    protected Socket outSocket = null;
    protected HttpInputStream httpIn = null;
    protected HttpOutputStream httpOut = null;
    protected ProxyThread originProcess = this;
    protected HttpSender httpSender = null;
    private BufferedOutputStream forwardOut = null;
    private BufferedInputStream forwardIn = null;
    private boolean disconnect = false;
    private Object semaphore = this;
    private static Object semaphoreSingleton = new Object();
    private boolean isForwardInputBufferEmpty = true;

    ProxyThread(ProxyServer proxyServer, Socket socket) {
        this.inSocket = socket;
        try {
            this.inSocket.setTcpNoDelay(true);
            this.inSocket.setSoTimeout(60000);
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        this.thread = new Thread(this);
        this.thread.setDaemon(true);
        this.parentServer = proxyServer;
        this.proxyParam = this.parentServer.getProxyParam();
        this.connectionParam = this.parentServer.getConnectionParam();
        this.httpSender = new HttpSender(this.connectionParam);
    }

    public void start() {
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = this instanceof ProxyThreadSSL;
        HttpRequestHeader httpRequestHeader = null;
        try {
            this.httpIn = new HttpInputStream(this.inSocket);
            this.httpOut = new HttpOutputStream(this.inSocket.getOutputStream());
            httpRequestHeader = this.httpIn.readRequestHeader(bl);
            if (httpRequestHeader.getMethod().equalsIgnoreCase("CONNECT")) {
                this.httpOut.write(CONNECT_HTTP_200);
                this.processForwardPort();
            } else {
                this.processHttp(httpRequestHeader);
            }
        }
        catch (IOException iOException) {
        }
        finally {
            this.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processHttp(HttpRequestHeader httpRequestHeader) throws IOException {
        HttpBody httpBody = null;
        boolean bl = true;
        boolean bl2 = this instanceof ProxyThreadSSL;
        long l = System.currentTimeMillis();
        int n = -1;
        HttpMessage httpMessage = null;
        do {
            if (bl) {
                bl = false;
            } else if (this.httpIn.available() > 0) {
                httpRequestHeader = this.httpIn.readRequestHeader(bl2);
            } else {
                HttpUtil.sleep(30);
                continue;
            }
            httpMessage = new HttpMessage();
            httpMessage.setRequestHeader(httpRequestHeader);
            if (httpMessage.getRequestHeader().getContentLength() > 0) {
                httpBody = this.httpIn.readBody(httpRequestHeader);
                httpMessage.setRequestBody(httpBody);
                l = System.currentTimeMillis();
            }
            this.modifyHeader(httpMessage);
            this.semaphore = this.parentServer.isSerialize() ? semaphoreSingleton : this;
            Object object = this.semaphore;
            synchronized (object) {
                this.notifyListenerRequestSend(httpMessage);
                this.httpSender.sendAndReceive(httpMessage);
                l = System.currentTimeMillis();
                this.notifyListenerResponseReceive(httpMessage);
                this.httpOut.write(httpMessage.getResponseHeader());
                l = System.currentTimeMillis();
                if (httpMessage.getResponseBody().length() > 0) {
                    this.httpOut.write(httpMessage.getResponseBody().getBytes());
                    this.httpOut.flush();
                    l = System.currentTimeMillis();
                }
                this.notifyWrittenToForwardProxy();
            }
        } while (!this.isResponseConnectionClose(httpMessage) && !this.inSocket.isClosed() && System.currentTimeMillis() - l < 3000L);
    }

    private boolean isResponseConnectionClose(HttpMessage httpMessage) {
        boolean bl = true;
        if (httpMessage == null || httpMessage.getResponseHeader().isEmpty()) {
            return bl;
        }
        if (httpMessage.getResponseHeader().isConnectionClose()) {
            bl = true;
        }
        return bl;
    }

    protected void disconnect() {
        try {
            this.httpIn.close();
            this.httpOut.close();
            HttpUtil.closeSocket(this.inSocket);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.httpSender.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processForwardPort() {
        Object object;
        int n = 0;
        byte[] byArray = new byte[8192];
        boolean bl = false;
        long l = System.currentTimeMillis();
        this.setDisconnect(false);
        try {
            object = processForwardList;
            synchronized (object) {
                this.outSocket = new Socket(this.proxyParam.getProxySSLIp(), this.proxyParam.getProxySSLPort());
                this.outSocket.setTcpNoDelay(true);
                processForwardList.add(this);
                this.forwardOut = new BufferedOutputStream(this.outSocket.getOutputStream());
                this.forwardIn = new BufferedInputStream(this.outSocket.getInputStream());
            }
        }
        catch (Exception exception) {
            bl = true;
        }
        try {
            while (!bl) {
                for (int i = 0; i < 2 && this.httpIn.available() > 0; ++i) {
                    n = this.httpIn.read(byArray);
                    if (n <= -1) continue;
                    this.forwardOut.write(byArray, 0, n);
                    this.forwardOut.flush();
                    l = System.currentTimeMillis();
                }
                Thread.yield();
                object = this;
                synchronized (object) {
                    try {
                        if (this.forwardIn.available() == 0) {
                            this.wait(20L);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (int i = 0; i < 5 && this.forwardIn.available() > 0; ++i) {
                        n = this.forwardIn.read(byArray);
                        if (n <= -1) continue;
                        this.httpOut.write(byArray, 0, n);
                        this.httpOut.flush();
                        l = System.currentTimeMillis();
                    }
                    if (this.forwardIn.available() == 0) {
                        this.setForwardInputBufferEmpty(true);
                    }
                }
                if ((!this.isDisconnect() || !this.isForwardInputBufferEmpty()) && System.currentTimeMillis() - l < 60000L) continue;
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.removeFromList();
        HttpUtil.closeInputStream(this.forwardIn);
        HttpUtil.closeOutputStream(this.forwardOut);
        HttpUtil.closeSocket(this.outSocket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromList() {
        ArrayList arrayList = processForwardList;
        synchronized (arrayList) {
            processForwardList.remove(this);
        }
    }

    protected synchronized boolean isDisconnect() {
        return this.disconnect;
    }

    protected synchronized void setDisconnect(boolean bl) {
        this.disconnect = bl;
    }

    protected synchronized void setForwardInputBufferEmpty(boolean bl) {
        this.isForwardInputBufferEmpty = bl;
    }

    protected synchronized boolean isForwardInputBufferEmpty() {
        try {
            if (this.forwardIn.available() > 0) {
                this.setForwardInputBufferEmpty(false);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.isForwardInputBufferEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static ProxyThread getOriginatingProcess(int n) {
        ProxyThread proxyThread = null;
        ArrayList arrayList = processForwardList;
        synchronized (arrayList) {
            for (int i = 0; i < processForwardList.size(); ++i) {
                proxyThread = (ProxyThread)processForwardList.get(i);
                if (proxyThread.outSocket.getLocalPort() != n) continue;
                return proxyThread;
            }
        }
        return null;
    }

    public Thread getThread() {
        return this.thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWrittenToForwardProxy() {
        ProxyThread proxyThread = this.originProcess;
        synchronized (proxyThread) {
            this.originProcess.setForwardInputBufferEmpty(false);
            this.originProcess.notify();
        }
    }

    private void notifyListenerRequestSend(HttpMessage httpMessage) {
        ProxyListener proxyListener = null;
        List list = this.parentServer.getListenerList();
        for (int i = 0; i < list.size(); ++i) {
            proxyListener = (ProxyListener)list.get(i);
            try {
                proxyListener.onHttpRequestSend(httpMessage);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void notifyListenerResponseReceive(HttpMessage httpMessage) {
        ProxyListener proxyListener = null;
        List list = this.parentServer.getListenerList();
        for (int i = 0; i < list.size(); ++i) {
            proxyListener = (ProxyListener)list.get(i);
            try {
                proxyListener.onHttpResponseReceive(httpMessage);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private boolean isRecursive(HttpRequestHeader httpRequestHeader) {
        boolean bl = false;
        try {
            if (httpRequestHeader.getURI().getHost().equals(this.proxyParam.getProxyIp()) && httpRequestHeader.getURI().getPort() == this.proxyParam.getProxyPort()) {
                bl = true;
            }
        }
        catch (URIException uRIException) {
            // empty catch block
        }
        return true;
    }

    private void modifyHeader(HttpMessage httpMessage) {
        httpMessage.getRequestHeader().setHeader("Accept-Encoding", null);
    }
}

