/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.URIException;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestInfoSessionIdURL
extends AbstractAppPlugin {
    private static Pattern staticSessionIDPHP1 = Pattern.compile("(PHPSESSION)=\\w+", 10);
    private static Pattern staticSessionIDPHP2 = Pattern.compile("(PHPSESSID)=\\w+", 10);
    private static Pattern staticSessionIDJava = Pattern.compile("(JSESSIONID)=\\w+", 10);
    private static Pattern staticSessionIDASP = Pattern.compile("(ASPSESSIONID)=\\w+", 10);
    private static Pattern staticSessionIDColdFusion = Pattern.compile("(CFTOKEN)=\\w+", 10);
    private static Pattern staticSessionIDApache = Pattern.compile("(SESSIONID)=\\w+", 10);
    private static Pattern staticSessionIDJW = Pattern.compile("(JWSESSIONID)=\\w+", 10);
    private static Pattern[] staticSessionIDList = new Pattern[]{staticSessionIDPHP1, staticSessionIDPHP2, staticSessionIDJava, staticSessionIDColdFusion, staticSessionIDASP, staticSessionIDApache, staticSessionIDJW};
    private static final String paramHostHttp = "http://([\\w\\.\\-_]+)";
    private static final String paramHostHttps = "https://([\\w\\.\\-_]+)";
    private static final Pattern[] staticLinkCheck = new Pattern[]{Pattern.compile("src\\s*=\\s*\"?http://([\\w\\.\\-_]+)", 10), Pattern.compile("href\\s*=\\s*\"?http://([\\w\\.\\-_]+)", 10), Pattern.compile("src\\s*=\\s*\"?https://([\\w\\.\\-_]+)", 10), Pattern.compile("href\\s*=\\s*\"?https://([\\w\\.\\-_]+)", 10)};
    private static final String alertReferer = "Referer expose session ID";
    private static final String descReferer = "Hyperlink to other host name is found.  As session ID URL rewrite is used, it may be disclosed in referer header to external host.";
    private static final String solutionReferer = "This is a risk if the session ID is sensitive and the hyperlink refer to an external host.  For secure content, put session ID in secured session cookie.";

    public int getId() {
        return 4;
    }

    public String getName() {
        return "Session ID in URL rewrite";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        return "URL rewrite is used to track user session ID.  The session ID may be disclosed in referer header.  Besides, the session ID can be stored in browser history or server logs.";
    }

    public int getCategory() {
        return 0;
    }

    public String getSolution() {
        return "For secure content, put session ID in cookie.  To be even more secure consider to use a combination of cookie and URL rewrite.";
    }

    public String getReference() {
        return "http://seclists.org/lists/webappsec/2002/Oct-Dec/0111.html";
    }

    public void init() {
    }

    public void scan() {
        HttpMessage httpMessage = this.getBaseMsg();
        String string = httpMessage.getRequestHeader().getURI().toString();
        Matcher matcher = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < staticSessionIDList.length; ++i) {
            matcher = staticSessionIDList[i].matcher(string);
            if (!matcher.find()) continue;
            string2 = matcher.group(0);
            string3 = matcher.group(1);
            String string4 = this.getKb().getString("sessionId/nameValue");
            if (string4 == null || !string4.equals(string2)) {
                this.getKb().add("sessionId/nameValue", string2);
                this.bingo(1, 1, null, "", string2, httpMessage);
            }
            string4 = this.getKb().getString("sessionId/name");
            this.getKb().add("sessionId/name", string3);
            try {
                this.checkSessionIDExposure(httpMessage);
            }
            catch (URIException uRIException) {}
            break;
        }
    }

    private void checkSessionIDExposure(HttpMessage httpMessage) throws URIException {
        String string = httpMessage.getResponseBody().toString();
        int n = httpMessage.getRequestHeader().getSecure() ? 2 : 0;
        String string2 = null;
        Matcher matcher = null;
        for (int i = 0; i < staticLinkCheck.length; ++i) {
            matcher = staticLinkCheck[i].matcher(string);
            while (matcher.find()) {
                string2 = matcher.group(1);
                String string3 = httpMessage.getRequestHeader().getURI().getHost();
                if (string3.compareToIgnoreCase(string2) == 0) continue;
                this.bingo(n, 1, alertReferer, descReferer, null, null, string2, solutionReferer, httpMessage);
            }
        }
    }
}

