/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.history;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import java.util.List;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookView;
import org.parosproxy.paros.extension.SessionListener;
import org.parosproxy.paros.extension.history.HistoryFilterDialog;
import org.parosproxy.paros.extension.history.LogPanel;
import org.parosproxy.paros.extension.history.ProxyListenerLog;
import org.parosproxy.paros.model.HistoryList;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;

public class ExtensionHistory
extends ExtensionAdaptor
implements SessionListener {
    private static final int FILTER_NONE = 0;
    private static final int FILTER_REQUEST = 1;
    private static final int FILTER_RESPONSE = 2;
    private LogPanel logPanel = null;
    private ProxyListenerLog proxyListener = null;
    private HistoryList historyList = null;
    private String filter = "";
    private HistoryFilterDialog filterDialog = null;
    private JCheckBoxMenuItem menuFilterHistoryByRequest = null;
    private JCheckBoxMenuItem menuFilterHistoryByResponse = null;
    private int stateFilter = 0;

    public ExtensionHistory() {
        this.initialize();
    }

    public ExtensionHistory(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionHistory");
    }

    private LogPanel getLogPanel() {
        if (this.logPanel == null) {
            this.logPanel = new LogPanel();
            this.logPanel.setName("History");
        }
        return this.logPanel;
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        ExtensionHookView extensionHookView = extensionHook.getHookView();
        extensionHookView.addStatusPanel(this.getLogPanel());
        this.getLogPanel().setDisplayPanel(this.getView().getRequestPanel(), this.getView().getResponsePanel());
        extensionHook.addProxyListener(this.getProxyListenerLog());
        extensionHook.addSessionListener(this);
        extensionHook.getHookMenu().addViewMenuItem(this.getMenuFilterHistoryByRequest());
        extensionHook.getHookMenu().addViewMenuItem(this.getMenuFilterHistoryByResponse());
    }

    public void sessionChanged(Session session) {
        this.getHistoryList().clear();
        this.getLogPanel().getListLog().setModel(this.getHistoryList());
        this.getView().getRequestPanel().setMessage("", "", true);
        this.getView().getResponsePanel().setMessage("", "", false);
        try {
            Vector vector = this.getModel().getDb().getTableHistory().getHistoryList(session.getSessionId(), 1);
            this.buildHistory(this.getHistoryList(), vector);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ProxyListenerLog getProxyListenerLog() {
        if (this.proxyListener == null) {
            this.proxyListener = new ProxyListenerLog(this.getModel(), this.getView(), this.getHistoryList());
        }
        return this.proxyListener;
    }

    private HistoryList getHistoryList() {
        if (this.historyList == null) {
            this.historyList = new HistoryList();
        }
        return this.historyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void searchHistory(String string, boolean bl) {
        Session session = this.getModel().getSession();
        HistoryList historyList = this.historyList;
        synchronized (historyList) {
            try {
                List list = this.getModel().getDb().getTableHistory().getHistoryList(session.getSessionId(), 1, string, bl);
                this.buildHistory(this.getHistoryList(), list);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHistory(HistoryList historyList, List list) {
        HistoryList historyList2 = historyList;
        synchronized (historyList2) {
            historyList.clear();
            HistoryReference historyReference = null;
            for (int i = 0; i < list.size(); ++i) {
                int n = (Integer)list.get(i);
                try {
                    historyReference = new HistoryReference(n);
                    historyList.addElement(historyReference);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private HistoryFilterDialog getFilterDialog() {
        if (this.filterDialog == null) {
            this.filterDialog = new HistoryFilterDialog((Frame)this.getView().getMainFrame(), true);
        }
        return this.filterDialog;
    }

    private JCheckBoxMenuItem getMenuFilterHistoryByRequest() {
        if (this.menuFilterHistoryByRequest == null) {
            this.menuFilterHistoryByRequest = new JCheckBoxMenuItem();
            this.menuFilterHistoryByRequest.setText("Filter History by Request");
            this.menuFilterHistoryByRequest.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ExtensionHistory.this.showFilterDialog(true);
                    switch (n) {
                        case -1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            ExtensionHistory.this.stateFilter = 0;
                            break;
                        }
                        case 0: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            if (ExtensionHistory.this.stateFilter == 1) {
                                ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(true);
                                break;
                            }
                            if (ExtensionHistory.this.stateFilter != 2) break;
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(true);
                            break;
                        }
                        case 1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(true);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            ExtensionHistory.this.stateFilter = 1;
                        }
                    }
                }
            });
        }
        return this.menuFilterHistoryByRequest;
    }

    private int showFilterDialog(boolean bl) {
        HistoryFilterDialog historyFilterDialog = this.getFilterDialog();
        historyFilterDialog.setModal(true);
        int n = historyFilterDialog.showDialog();
        int n2 = 0;
        if (n == 0) {
            this.filter = historyFilterDialog.getPattern();
            this.getProxyListenerLog().setFilter(this.filter);
            this.searchHistory(this.filter, bl);
            n2 = 1;
        } else if (n == 1) {
            this.filter = "";
            this.getProxyListenerLog().setFilter(this.filter);
            this.searchHistory(this.filter, bl);
            n2 = -1;
        }
        return n2;
    }

    private JCheckBoxMenuItem getMenuFilterHistoryByResponse() {
        if (this.menuFilterHistoryByResponse == null) {
            this.menuFilterHistoryByResponse = new JCheckBoxMenuItem();
            this.menuFilterHistoryByResponse.setText("Filter History by Response");
            this.menuFilterHistoryByResponse.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    int n = ExtensionHistory.this.showFilterDialog(false);
                    switch (n) {
                        case -1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            ExtensionHistory.this.stateFilter = 0;
                            break;
                        }
                        case 0: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(false);
                            if (ExtensionHistory.this.stateFilter == 1) {
                                ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(true);
                                break;
                            }
                            if (ExtensionHistory.this.stateFilter != 2) break;
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(true);
                            break;
                        }
                        case 1: {
                            ExtensionHistory.this.menuFilterHistoryByRequest.setSelected(false);
                            ExtensionHistory.this.menuFilterHistoryByResponse.setSelected(true);
                            ExtensionHistory.this.stateFilter = 2;
                        }
                    }
                }
            });
        }
        return this.menuFilterHistoryByResponse;
    }
}

