/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.scanner;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.extension.AbstractPanel;
import org.parosproxy.paros.extension.ViewDelegate;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.HttpPanel;

public class AlertPanel
extends AbstractPanel {
    private ViewDelegate view = null;
    private JTree treeAlert = null;
    private TreePath rootTreePath = null;
    private DefaultTreeModel treeModel = null;
    private JScrollPane paneScroll = null;

    public AlertPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(474, 251);
        this.setName("Alerts");
        this.add((Component)this.getPaneScroll(), this.getPaneScroll().getName());
    }

    JTree getTreeAlert() {
        if (this.treeAlert == null) {
            this.treeAlert = new JTree();
            this.treeAlert.setName("treeAlert");
            this.treeAlert.setShowsRootHandles(true);
            this.treeAlert.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.treeAlert.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    Object object;
                    DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)AlertPanel.this.treeAlert.getLastSelectedPathComponent();
                    if (defaultMutableTreeNode.getUserObject() != null && (object = defaultMutableTreeNode.getUserObject()) instanceof Alert) {
                        Alert alert = (Alert)object;
                        AlertPanel.this.setMessage(alert.getMessage());
                    }
                }
            });
        }
        return this.treeAlert;
    }

    private JScrollPane getPaneScroll() {
        if (this.paneScroll == null) {
            this.paneScroll = new JScrollPane();
            this.paneScroll.setName("paneScroll");
            this.paneScroll.setViewportView(this.getTreeAlert());
        }
        return this.paneScroll;
    }

    void setView(ViewDelegate viewDelegate) {
        this.view = viewDelegate;
    }

    private ViewDelegate getView() {
        return this.view;
    }

    public void expandRoot() {
        TreeNode treeNode = (TreeNode)this.getTreeAlert().getModel().getRoot();
        if (this.rootTreePath == null || treeNode != this.rootTreePath.getPathComponent(0)) {
            this.rootTreePath = new TreePath(treeNode);
        }
        if (EventQueue.isDispatchThread()) {
            this.getTreeAlert().expandPath(this.rootTreePath);
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    AlertPanel.this.getTreeAlert().expandPath(AlertPanel.this.rootTreePath);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void setMessage(HttpMessage httpMessage) {
        HttpPanel httpPanel = this.getView().getRequestPanel();
        HttpPanel httpPanel2 = this.getView().getResponsePanel();
        httpPanel.setMessage("", "", true);
        if (!httpMessage.getRequestHeader().isEmpty()) {
            httpPanel.setMessage(httpMessage.getRequestHeader().toString(), httpMessage.getRequestBody().toString(), true);
        }
        httpPanel2.setMessage("", "", false);
        if (!httpMessage.getResponseHeader().isEmpty()) {
            httpPanel2.setMessage(httpMessage.getResponseHeader().toString(), httpMessage.getResponseBody().toString(), false);
        }
    }
}

