/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.scanner;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.SQLException;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.Scanner;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.db.RecordAlert;
import org.parosproxy.paros.db.RecordScan;
import org.parosproxy.paros.db.TableAlert;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.SessionListener;
import org.parosproxy.paros.extension.scanner.AlertPanel;
import org.parosproxy.paros.extension.scanner.AlertTreeModel;
import org.parosproxy.paros.extension.scanner.PolicyDialog;
import org.parosproxy.paros.extension.scanner.ProgressDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.Session;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMalformedHeaderException;

public class ExtensionScanner
extends ExtensionAdaptor
implements ScannerListener,
SessionListener {
    private JMenuItem menuItemScanAll = null;
    private ExtensionHookMenu pluginMenu = null;
    private Scanner scanner = null;
    private SiteMap siteTree = null;
    private SiteNode startNode = null;
    private AlertTreeModel treeAlert = null;
    private JMenu menuScanner = null;
    private JMenuItem menuItemPolicy = null;
    private ProgressDialog progressDialog = null;
    private JMenuItem menuItemScan = null;
    private AlertPanel alertPanel = null;
    private RecordScan recordScan = null;

    public ExtensionScanner() {
        this.initialize();
    }

    public ExtensionScanner(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionScanner");
    }

    private JMenuItem getMenuItemScanAll() {
        if (this.menuItemScanAll == null) {
            this.menuItemScanAll = new JMenuItem();
            this.menuItemScanAll.setText("Scan All");
            this.menuItemScanAll.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ExtensionScanner.this.menuItemScanAll.setEnabled(false);
                    ExtensionScanner.this.getAlertPanel().setTabFocus();
                    ExtensionScanner.this.startScan();
                }
            });
        }
        return this.menuItemScanAll;
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.getHookMenu().addNewMenu(this.getMenuScanner());
        extensionHook.getHookView().addStatusPanel(this.getAlertPanel());
        extensionHook.addSessionListener(this);
    }

    public void startScan() {
        this.siteTree = this.getModel().getSession().getSiteTree();
        if (this.startNode == null) {
            this.startNode = (SiteNode)this.siteTree.getRoot();
        }
        this.startScan(this.startNode);
    }

    private void startScan(SiteNode siteNode) {
        this.scanner = new Scanner(this.getModel().getOptionsParam().getScannerParam(), this.getModel().getOptionsParam().getConnectionParam());
        this.scanner.addScannerListener(this);
        this.getProgressDialog().show();
        this.getProgressDialog().setPluginScanner(this);
        try {
            this.recordScan = this.getModel().getDb().getTableScan().insert(this.getModel().getSession().getSessionId(), this.getModel().getSession().getSessionName());
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
        this.scanner.start(siteNode);
    }

    public SiteNode getStartNode() {
        return this.startNode;
    }

    private JMenu getMenuScanner() {
        if (this.menuScanner == null) {
            this.menuScanner = new JMenu();
            this.menuScanner.setText("Scanner");
            this.menuScanner.add(this.getMenuItemScanAll());
            this.menuScanner.add(this.getMenuItemScan());
            this.menuScanner.addSeparator();
            this.menuScanner.add(this.getMenuItemPolicy());
        }
        return this.menuScanner;
    }

    public void scannerComplete() {
        try {
            Thread.sleep(1000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.menuItemScanAll.setEnabled(true);
        this.menuItemScan.setEnabled(true);
        if (this.progressDialog != null) {
            if (EventQueue.isDispatchThread()) {
                this.progressDialog.dispose();
                this.progressDialog = null;
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ExtensionScanner.this.progressDialog.dispose();
                        ExtensionScanner.this.progressDialog = null;
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private JMenuItem getMenuItemPolicy() {
        if (this.menuItemPolicy == null) {
            this.menuItemPolicy = new JMenuItem();
            this.menuItemPolicy.setText("Policy...");
            this.menuItemPolicy.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PolicyDialog policyDialog = new PolicyDialog(ExtensionScanner.this.getView().getMainFrame());
                    policyDialog.showDialog(true);
                }
            });
        }
        return this.menuItemPolicy;
    }

    public void hostProgress(String string, String string2, int n) {
        this.getProgressDialog().updateHostProgress(string, string2, n);
    }

    public void hostComplete(String string) {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.getProgressDialog().removeHostProgress(string);
    }

    public void hostNewScan(String string, HostProcess hostProcess) {
        this.getProgressDialog().addHostProgress(string, hostProcess);
    }

    public void alertFound(Alert alert) {
        try {
            this.writeAlertToDB(alert);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.treeAlert.addPath(alert);
        if (this.getView() != null) {
            this.getAlertPanel().expandRoot();
        }
    }

    private ProgressDialog getProgressDialog() {
        if (this.progressDialog == null) {
            this.progressDialog = new ProgressDialog((Frame)this.getView().getMainFrame(), false);
            this.progressDialog.setSize(500, 460);
        }
        return this.progressDialog;
    }

    public Scanner getScanner() {
        return this.scanner;
    }

    private JMenuItem getMenuItemScan() {
        if (this.menuItemScan == null) {
            this.menuItemScan = new JMenuItem();
            this.menuItemScan.setText("Scan");
            this.menuItemScan.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTree jTree = ExtensionScanner.this.getView().getSiteTreePanel().getTreeSite();
                    SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
                    if (siteNode == null) {
                        ExtensionScanner.this.getView().showWarningDialog("Please select a site/folder/URL in Sites panel.");
                        return;
                    }
                    ExtensionScanner.this.menuItemScan.setEnabled(false);
                    ExtensionScanner.this.getAlertPanel().setTabFocus();
                    ExtensionScanner.this.startScan(siteNode);
                }
            });
        }
        return this.menuItemScan;
    }

    private AlertPanel getAlertPanel() {
        if (this.alertPanel == null) {
            this.alertPanel = new AlertPanel();
            this.alertPanel.setView(this.getView());
            this.alertPanel.setSize(345, 122);
            this.alertPanel.getTreeAlert().setModel(this.getTreeModel());
        }
        return this.alertPanel;
    }

    private DefaultTreeModel getTreeModel() {
        if (this.treeAlert == null) {
            this.treeAlert = new AlertTreeModel();
        }
        return this.treeAlert;
    }

    private void writeAlertToDB(Alert alert) throws HttpMalformedHeaderException, SQLException {
        TableAlert tableAlert = this.getModel().getDb().getTableAlert();
        HistoryReference historyReference = new HistoryReference(this.getModel().getSession(), 3, alert.getMessage());
        RecordAlert recordAlert = tableAlert.write(this.recordScan.getScanId(), alert.getPluginId(), alert.getAlert(), alert.getRisk(), alert.getReliability(), alert.getDescription(), alert.getUri(), alert.getParam(), alert.getOtherInfo(), alert.getSolution(), alert.getReference(), historyReference.getHistoryId());
        alert.setAlertId(recordAlert.getAlertId());
    }

    public void sessionChanged(Session session) {
        AlertTreeModel alertTreeModel = (AlertTreeModel)this.getAlertPanel().getTreeAlert().getModel();
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)alertTreeModel.getRoot();
        for (int i = 0; i < defaultMutableTreeNode.getChildCount(); ++i) {
            alertTreeModel.removeNodeFromParent((MutableTreeNode)defaultMutableTreeNode.getChildAt(i));
        }
    }
}

