/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.spider;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import org.apache.commons.httpclient.URI;
import org.parosproxy.paros.core.spider.Spider;
import org.parosproxy.paros.core.spider.SpiderListener;
import org.parosproxy.paros.extension.ExtensionAdaptor;
import org.parosproxy.paros.extension.ExtensionHook;
import org.parosproxy.paros.extension.ExtensionHookMenu;
import org.parosproxy.paros.extension.spider.PopupMenuSpider;
import org.parosproxy.paros.extension.spider.SpiderDialog;
import org.parosproxy.paros.model.HistoryReference;
import org.parosproxy.paros.model.SiteMap;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;

public class ExtensionSpider
extends ExtensionAdaptor
implements SpiderListener {
    private JMenuItem menuItemSpider = null;
    private ExtensionHookMenu extensionMenu = null;
    private SpiderDialog dialog = null;
    private Spider spider = null;
    private SiteMap siteTree = null;
    private SiteNode startNode = null;
    private PopupMenuSpider popupMenuSpider = null;

    public ExtensionSpider() {
        this.initialize();
    }

    public ExtensionSpider(String string) {
        super(string);
    }

    private void initialize() {
        this.setName("ExtensionSpider");
    }

    JMenuItem getMenuItemSpider() {
        if (this.menuItemSpider == null) {
            this.menuItemSpider = new JMenuItem();
            this.menuItemSpider.setText("Spider...");
            this.menuItemSpider.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    JTree jTree = ExtensionSpider.this.getView().getSiteTreePanel().getTreeSite();
                    SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
                    HttpMessage httpMessage = null;
                    if (siteNode == null) {
                        ExtensionSpider.this.getView().showWarningDialog("Please select a site/folder/URL in Sites panel.");
                        return;
                    }
                    ExtensionSpider.this.setStartNode(siteNode);
                    if (siteNode.isRoot()) {
                        ExtensionSpider.this.showDialog("All sites will be crawled");
                    } else {
                        try {
                            httpMessage = siteNode.getHistoryReference().getHttpMessage();
                        }
                        catch (Exception exception) {
                            return;
                        }
                        String string = httpMessage.getRequestHeader().getURI().toString();
                        ExtensionSpider.this.showDialog(string);
                    }
                }
            });
        }
        return this.menuItemSpider;
    }

    public void hook(ExtensionHook extensionHook) {
        super.hook(extensionHook);
        extensionHook.getHookMenu().addToolsMenuItem(this.getMenuItemSpider());
        extensionHook.getHookMenu().addPopupMenuItem(this.getPopupMenuSpider());
    }

    public void startSpider() {
        this.siteTree = this.getModel().getSession().getSiteTree();
        if (this.startNode == null) {
            this.startNode = (SiteNode)this.siteTree.getRoot();
        }
        this.startSpider(this.startNode);
    }

    private void startSpider(SiteNode siteNode) {
        if (this.spider == null) {
            this.spider = new Spider(this.getModel().getOptionsParam().getSpiderParam(), this.getModel().getOptionsParam().getConnectionParam());
            this.spider.addSpiderListener(this);
            this.inOrderSeed(this.spider, siteNode);
        }
        try {
            this.spider.start();
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
        }
    }

    private void inOrderSeed(Spider spider, SiteNode siteNode) {
        try {
            HttpMessage httpMessage;
            if (!siteNode.isRoot() && (httpMessage = siteNode.getHistoryReference().getHttpMessage()) != null && !httpMessage.getResponseHeader().isImage()) {
                spider.addSeed(httpMessage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (!siteNode.isLeaf()) {
                for (int i = 0; i < siteNode.getChildCount(); ++i) {
                    this.inOrderSeed(spider, (SiteNode)siteNode.getChildAt(i));
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void spiderComplete() {
        this.getMenuItemSpider().setEnabled(true);
        this.getPopupMenuSpider().setEnabled(true);
        try {
            Thread.sleep(3000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.dialog != null) {
            if (EventQueue.isDispatchThread()) {
                this.dialog.dispose();
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        ExtensionSpider.this.dialog.dispose();
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void foundURI(HttpMessage httpMessage) {
        if (this.getView() != null) {
            this.getView().getOutputPanel().append(httpMessage.getRequestHeader().getURI().toString() + "\n");
        }
    }

    public void readURI(HttpMessage httpMessage) {
        HttpMessage httpMessage2 = this.siteTree.pollPath(httpMessage);
        if (httpMessage2 != null) {
            return;
        }
        HistoryReference historyReference = null;
        try {
            historyReference = new HistoryReference(this.getModel().getSession(), 2, httpMessage);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.siteTree.addPath(historyReference);
    }

    public Spider getSpider() {
        return this.spider;
    }

    public void spiderProgress(final URI uRI, final int n) {
        String string = "";
        if (this.dialog != null) {
            if (EventQueue.isDispatchThread()) {
                this.dialog.getProgressBar().setValue(n);
                string = "";
                if (uRI != null) {
                    string = uRI.toString();
                }
                this.dialog.getTxtDisplay().setText(string);
                this.dialog.getTxtDisplay().setCaretPosition(0);
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        String string = "";
                        ExtensionSpider.this.dialog.getProgressBar().setValue(n);
                        if (uRI != null) {
                            string = uRI.toString();
                        }
                        ExtensionSpider.this.dialog.getTxtDisplay().setText(string);
                        ExtensionSpider.this.dialog.getTxtDisplay().setCaretPosition(0);
                    }
                });
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SiteNode getStartNode() {
        return this.startNode;
    }

    public void setStartNode(SiteNode siteNode) {
        this.startNode = siteNode;
    }

    void showDialog(String string) {
        this.dialog = new SpiderDialog((Frame)this.getView().getMainFrame(), false);
        this.dialog.setPlugin(this);
        this.dialog.show();
        this.dialog.getTxtDisplay().setText(string);
        this.spider = null;
    }

    PopupMenuSpider getPopupMenuSpider() {
        if (this.popupMenuSpider == null) {
            this.popupMenuSpider = new PopupMenuSpider();
            this.popupMenuSpider.setExtension(this);
        }
        return this.popupMenuSpider;
    }
}

