/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.extension.spider;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.parosproxy.paros.extension.AbstractDialog;
import org.parosproxy.paros.extension.spider.ExtensionSpider;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;

public class SpiderDialog
extends AbstractDialog
implements TreeSelectionListener {
    private JPanel jPanel = null;
    private JTextField txtDisplay = null;
    private JButton btnStart = null;
    private JButton btnStop = null;
    private ExtensionSpider extension = null;
    private JProgressBar progressBar = null;

    public SpiderDialog() throws HeadlessException {
        this.initialize();
    }

    public SpiderDialog(Frame frame, boolean bl) throws HeadlessException {
        super(frame, bl);
        this.initialize();
    }

    private void initialize() {
        this.setTitle("Spider");
        this.setContentPane(this.getJPanel());
        this.setSize(397, 223);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent windowEvent) {
                SpiderDialog.this.extension.getMenuItemSpider().setEnabled(false);
                SpiderDialog.this.extension.getPopupMenuSpider().setEnabled(false);
            }

            public void windowClosing(WindowEvent windowEvent) {
                SpiderDialog.this.btnStop.doClick();
                SpiderDialog.this.extension.getView().getSiteTreePanel().getTreeSite().removeTreeSelectionListener(SpiderDialog.this);
                SpiderDialog.this.extension.getMenuItemSpider().setEnabled(true);
                SpiderDialog.this.extension.getPopupMenuSpider().setEnabled(true);
            }
        });
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            JLabel jLabel = new JLabel();
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            JLabel jLabel2 = new JLabel();
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            JLabel jLabel3 = new JLabel();
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 1;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.insets = new Insets(2, 5, 5, 5);
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.gridwidth = 3;
            gridBagConstraints7.ipadx = 3;
            gridBagConstraints7.ipady = 15;
            gridBagConstraints6.gridx = 1;
            gridBagConstraints6.gridy = 4;
            gridBagConstraints6.insets = new Insets(2, 2, 2, 2);
            gridBagConstraints6.anchor = 13;
            gridBagConstraints5.gridx = 2;
            gridBagConstraints5.gridy = 4;
            gridBagConstraints5.insets = new Insets(2, 2, 2, 5);
            gridBagConstraints5.anchor = 13;
            jLabel3.setText("<html><body><p>The site/folder/URL chosen will be crawled.  You may press stop and resume the crawl afterwards.  The spider will crawl hyperlinks and attempt to submit forms.</p></body></html>");
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.gridy = 3;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints4.gridwidth = 3;
            gridBagConstraints4.ipady = 10;
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 2;
            gridBagConstraints3.insets = new Insets(2, 5, 10, 5);
            gridBagConstraints3.gridwidth = 3;
            jLabel2.setText("URL crawling:");
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(2, 5, 2, 5);
            gridBagConstraints2.weightx = 2.0;
            gridBagConstraints2.gridwidth = 3;
            gridBagConstraints2.ipadx = 0;
            gridBagConstraints2.ipady = 0;
            jLabel.setText(" ");
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(2, 5, 2, 5);
            this.jPanel.add((Component)jLabel2, gridBagConstraints2);
            this.jPanel.add((Component)this.getTxtDisplay(), gridBagConstraints7);
            this.jPanel.add((Component)this.getProgressBar(), gridBagConstraints3);
            this.jPanel.add((Component)jLabel3, gridBagConstraints4);
            this.jPanel.add((Component)jLabel, gridBagConstraints);
            this.jPanel.add((Component)this.getBtnStart(), gridBagConstraints6);
            this.jPanel.add((Component)this.getBtnStop(), gridBagConstraints5);
        }
        return this.jPanel;
    }

    JTextField getTxtDisplay() {
        if (this.txtDisplay == null) {
            this.txtDisplay = new JTextField();
            this.txtDisplay.setEditable(false);
            this.txtDisplay.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.txtDisplay.setHorizontalAlignment(2);
            this.txtDisplay.setAlignmentX(0.0f);
            this.txtDisplay.setPreferredSize(new Dimension(0, 26));
        }
        return this.txtDisplay;
    }

    private JButton getBtnStart() {
        if (this.btnStart == null) {
            this.btnStart = new JButton();
            this.btnStart.setText("Start");
            this.btnStart.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    SpiderDialog.this.extension.getView().getSiteTreePanel().getTreeSite().removeTreeSelectionListener(SpiderDialog.this);
                    SpiderDialog.this.btnStart.setEnabled(false);
                    SpiderDialog.this.btnStop.setEnabled(true);
                    SpiderDialog.this.extension.startSpider();
                }
            });
        }
        return this.btnStart;
    }

    private JButton getBtnStop() {
        if (this.btnStop == null) {
            this.btnStop = new JButton();
            this.btnStop.setText("Stop");
            this.btnStop.setEnabled(false);
            this.btnStop.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (SpiderDialog.this.extension.getSpider() != null) {
                        SpiderDialog.this.extension.getSpider().stop();
                    }
                    SpiderDialog.this.btnStop.setEnabled(false);
                    SpiderDialog.this.btnStart.setText("Resume");
                    SpiderDialog.this.btnStart.setEnabled(true);
                }
            });
        }
        return this.btnStop;
    }

    void setPlugin(ExtensionSpider extensionSpider) {
        this.extension = extensionSpider;
        extensionSpider.getView().getSiteTreePanel().getTreeSite().addTreeSelectionListener(this);
    }

    JProgressBar getProgressBar() {
        if (this.progressBar == null) {
            this.progressBar = new JProgressBar();
            this.progressBar.setStringPainted(true);
        }
        return this.progressBar;
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        JTree jTree = this.extension.getView().getSiteTreePanel().getTreeSite();
        SiteNode siteNode = (SiteNode)jTree.getLastSelectedPathComponent();
        this.extension.setStartNode(siteNode);
        if (siteNode.isRoot()) {
            this.getTxtDisplay().setText("All sites will be crawled");
        } else {
            HttpMessage httpMessage = (HttpMessage)siteNode.getUserObject();
            if (httpMessage != null) {
                String string = httpMessage.getRequestHeader().getURI().toString();
                this.getTxtDisplay().setText(string);
                this.getTxtDisplay().setCaretPosition(0);
            }
        }
    }
}

