/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.util.Vector;
import java.util.regex.Pattern;
import org.parosproxy.paros.common.FileXML;
import org.parosproxy.paros.network.HostAuthentication;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConnectionParam
extends FileXML {
    private static final String CONNECTION = "connection";
    private static final String PROXY_CHAIN_NAME = "proxyChainName";
    private static final String PROXY_CHAIN_PORT = "proxyChainPort";
    private static final String PROXY_CHAIN_SKIP_NAME = "proxyChainSkipName";
    private static final String PROXY_CHAIN_REALM = "proxyChainRealm";
    private static final String PROXY_CHAIN_USER_NAME = "proxyChainUserName";
    private static final String PROXY_CHAIN_PASSWORD = "proxyChainPassword";
    private static final String[] PATH_PROXY_CHAIN_NAME = new String[]{"connection", "proxyChainName"};
    private static final String[] PATH_PROXY_CHAIN_PORT = new String[]{"connection", "proxyChainPort"};
    private static final String[] PATH_PROXY_CHAIN_SKIP_NAME = new String[]{"connection", "proxyChainSkipName"};
    private static final String[] PATH_PROXY_CHAIN_REALM = new String[]{"connection", "proxyChainRealm"};
    private static final String[] PATH_PROXY_CHAIN_USER_NAME = new String[]{"connection", "proxyChainUserName"};
    private static final String[] PATH_PROXY_CHAIN_PASSWORD = new String[]{"connection", "proxyChainPassword"};
    private String proxyChainName = "";
    private int proxyChainPort = 8080;
    private String proxyChainSkipName = "";
    private String proxyChainRealm = "";
    private String proxyChainUserName = "";
    private String proxyChainPassword = "";
    private Vector listAuth = new Vector();
    private Pattern patternSkip = null;
    private Document mDoc = null;
    private static final String AUTH = "auth";
    private static final String AUTH_HOST_NAME = "authHostName";
    private static final String AUTH_PORT = "authPort";
    private static final String AUTH_USER_NAME = "authUserName";
    private static final String AUTH_PASSWORD = "authPassword";
    private static final String AUTH_REALM = "authRealm";

    public ConnectionParam() {
        super(CONNECTION);
    }

    protected void parse() {
        this.setProxyChainName(this.getValue(PROXY_CHAIN_NAME));
        try {
            this.setProxyChainPort(Integer.parseInt(this.getValue(PROXY_CHAIN_PORT)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setProxyChainSkipName(this.getValue(PROXY_CHAIN_SKIP_NAME));
        this.setProxyChainUserName(this.getValue(PROXY_CHAIN_USER_NAME));
        this.setProxyChainPassword(this.getValue(PROXY_CHAIN_PASSWORD));
        this.parseAuthentication();
    }

    public String getProxyChainName() {
        return this.proxyChainName;
    }

    public void setProxyChainName(String string) {
        this.proxyChainName = string.trim();
        this.setValue(PATH_PROXY_CHAIN_NAME, this.proxyChainName);
    }

    public int getProxyChainPort() {
        return this.proxyChainPort;
    }

    public void setProxyChainPort(int n) {
        this.proxyChainPort = n;
        this.setValue(PATH_PROXY_CHAIN_PORT, Integer.toString(this.proxyChainPort));
    }

    public String getProxyChainSkipName() {
        return this.proxyChainSkipName;
    }

    public void setProxyChainSkipName(String string) {
        this.proxyChainSkipName = string.trim();
        this.setValue(PATH_PROXY_CHAIN_SKIP_NAME, this.proxyChainSkipName);
        this.parseProxyChainSkip(this.proxyChainSkipName);
    }

    public String getProxyChainRealm() {
        return this.proxyChainRealm;
    }

    public void setProxyChainRealm(String string) {
        this.proxyChainRealm = string.trim();
        this.setValue(PATH_PROXY_CHAIN_REALM, this.proxyChainRealm);
    }

    public String getProxyChainUserName() {
        return this.proxyChainUserName;
    }

    public void setProxyChainUserName(String string) {
        this.proxyChainUserName = string.trim();
        this.setValue(PATH_PROXY_CHAIN_USER_NAME, this.proxyChainUserName);
    }

    public String getProxyChainPassword() {
        return this.proxyChainPassword.trim();
    }

    public void setProxyChainPassword(String string) {
        this.proxyChainPassword = string;
        this.setValue(PATH_PROXY_CHAIN_PASSWORD, this.proxyChainPassword);
    }

    private boolean isUseProxyChain() {
        return !this.getProxyChainName().equals("");
    }

    private boolean isSkipProxyChain(String string) {
        if (this.patternSkip == null || string == null) {
            return false;
        }
        return this.patternSkip.matcher(string).find();
    }

    public boolean isUseProxy(String string) {
        return this.isUseProxyChain() && !this.isSkipProxyChain(string);
    }

    private void parseProxyChainSkip(String string) {
        this.patternSkip = null;
        if (string == null || string.equals("")) {
            return;
        }
        string = string.replaceAll("\\.", "\\\\.");
        string = string.replaceAll("\\*", ".*?").replaceAll("(;+$)|(^;+)", "");
        string = "(" + string.replaceAll(";+", "|") + ")$";
        this.patternSkip = Pattern.compile(string, 2);
    }

    public Vector getListAuth() {
        return this.listAuth;
    }

    public void setListAuth(Vector vector) {
        this.listAuth = vector;
        HostAuthentication hostAuthentication = null;
        Element element = this.getElement(CONNECTION);
        this.removeElement(element, AUTH);
        for (int i = 0; i < vector.size(); ++i) {
            hostAuthentication = (HostAuthentication)vector.get(i);
            Element element2 = this.addElement(element, AUTH);
            this.addElement(element2, AUTH_HOST_NAME, hostAuthentication.getHostName());
            this.addElement(element2, AUTH_PORT, Integer.toString(hostAuthentication.getPort()));
            this.addElement(element2, AUTH_USER_NAME, hostAuthentication.getUserName());
            this.addElement(element2, AUTH_PASSWORD, hostAuthentication.getPassword());
            this.addElement(element2, AUTH_REALM, hostAuthentication.getRealm());
        }
    }

    private void parseAuthentication() {
        this.listAuth.clear();
        Element[] elementArray = this.getElements(AUTH);
        Element element = null;
        if (elementArray == null || elementArray.length == 0) {
            return;
        }
        for (int i = 0; i < elementArray.length; ++i) {
            element = elementArray[i];
            if (this.getValue(element, AUTH_HOST_NAME).equals("")) continue;
            HostAuthentication hostAuthentication = new HostAuthentication(this.getValue(element, AUTH_HOST_NAME), Integer.parseInt(this.getValue(element, AUTH_PORT)), this.getValue(element, AUTH_USER_NAME), this.getValue(element, AUTH_PASSWORD), this.getValue(element, AUTH_REALM));
            this.listAuth.add(hostAuthentication);
        }
    }
}

