/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.view;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.HttpMessage;
import org.parosproxy.paros.view.HttpPanel;
import org.parosproxy.paros.view.View;

public class SiteMapPanel
extends JPanel {
    private JScrollPane jScrollPane = null;
    private JTree treeSite = null;
    private TreePath rootTreePath = null;
    private View view = null;

    public SiteMapPanel() {
        this.initialize();
    }

    private View getView() {
        if (this.view == null) {
            this.view = View.getSingleton();
        }
        return this.view;
    }

    private void initialize() {
        this.setLayout(new CardLayout());
        this.setSize(300, 200);
        this.add((Component)this.getJScrollPane(), this.getJScrollPane().getName());
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTreeSite());
            this.jScrollPane.setPreferredSize(new Dimension(200, 400));
            this.jScrollPane.setName("jScrollPane");
        }
        return this.jScrollPane;
    }

    public JTree getTreeSite() {
        if (this.treeSite == null) {
            this.treeSite = new JTree();
            this.treeSite.setShowsRootHandles(true);
            this.treeSite.setName("treeSite");
            this.treeSite.setToggleClickCount(1);
            this.treeSite.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent mouseEvent) {
                    if ((mouseEvent.getModifiers() & 4) != 0) {
                        View.getSingleton().getPopupMenu().show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
            this.treeSite.addTreeSelectionListener(new TreeSelectionListener(){

                public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                    HttpMessage httpMessage = null;
                    SiteNode siteNode = (SiteNode)SiteMapPanel.this.treeSite.getLastSelectedPathComponent();
                    if (siteNode == null) {
                        return;
                    }
                    if (!siteNode.isRoot()) {
                        try {
                            httpMessage = siteNode.getHistoryReference().getHttpMessage();
                        }
                        catch (Exception exception) {
                            return;
                        }
                        HttpPanel httpPanel = SiteMapPanel.this.getView().getRequestPanel();
                        HttpPanel httpPanel2 = SiteMapPanel.this.getView().getResponsePanel();
                        httpPanel.setMessage(httpMessage, true);
                        httpPanel2.setMessage(httpMessage, false);
                    }
                }
            });
        }
        return this.treeSite;
    }

    public void expandRoot() {
        TreeNode treeNode = (TreeNode)this.treeSite.getModel().getRoot();
        if (this.rootTreePath == null || treeNode != this.rootTreePath.getPathComponent(0)) {
            this.rootTreePath = new TreePath(treeNode);
        }
        if (EventQueue.isDispatchThread()) {
            this.getTreeSite().expandPath(this.rootTreePath);
            return;
        }
        try {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SiteMapPanel.this.getTreeSite().expandPath(SiteMapPanel.this.rootTreePath);
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

