/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import org.parosproxy.paros.control.AbstractControl;
import org.parosproxy.paros.control.MenuEditControl;
import org.parosproxy.paros.control.MenuFileControl;
import org.parosproxy.paros.control.MenuToolsControl;
import org.parosproxy.paros.control.Proxy;
import org.parosproxy.paros.core.scanner.PluginFactory;
import org.parosproxy.paros.extension.encoder.ExtensionEncoder;
import org.parosproxy.paros.extension.filter.ExtensionFilter;
import org.parosproxy.paros.extension.history.ExtensionHistory;
import org.parosproxy.paros.extension.report.ExtensionReport;
import org.parosproxy.paros.extension.scanner.ExtensionScanner;
import org.parosproxy.paros.extension.spider.ExtensionSpider;
import org.parosproxy.paros.extension.viewOption.ExtensionViewOption;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;

public class Control
extends AbstractControl {
    private static Control control = null;
    private Proxy proxy = null;
    private MenuFileControl menuFileControl = null;
    private MenuEditControl menuEditControl = null;
    private MenuToolsControl menuToolsControl = null;

    private Control(Model model, View view) {
        super(model, view);
        this.init();
    }

    private void init() {
        PluginFactory.loadAllPlugin();
        this.getProxy();
        this.loadExtension();
        this.getExtensionLoader().hookProxyListener(this.getProxy());
        this.getProxy().startServer();
    }

    public Proxy getProxy() {
        if (this.proxy == null) {
            this.proxy = new Proxy(this.model, this.view);
        }
        return this.proxy;
    }

    protected void addExtension() {
        this.getExtensionLoader().addExtension(new ExtensionFilter());
        this.getExtensionLoader().addExtension(new ExtensionHistory());
        this.getExtensionLoader().addExtension(new ExtensionSpider());
        this.getExtensionLoader().addExtension(new ExtensionEncoder());
        this.getExtensionLoader().addExtension(new ExtensionScanner());
        this.getExtensionLoader().addExtension(new ExtensionViewOption());
        this.getExtensionLoader().addExtension(new ExtensionReport());
    }

    public MenuFileControl getMenuFileControl() {
        if (this.menuFileControl == null) {
            this.menuFileControl = new MenuFileControl(this.model, this.view, this);
        }
        return this.menuFileControl;
    }

    public MenuEditControl getMenuEditControl() {
        if (this.menuEditControl == null) {
            this.menuEditControl = new MenuEditControl(this.model, this.view);
        }
        return this.menuEditControl;
    }

    public MenuToolsControl getMenuToolsControl() {
        if (this.menuToolsControl == null) {
            this.menuToolsControl = new MenuToolsControl(this.model, this.view, this);
        }
        return this.menuToolsControl;
    }

    public static Control getSingleton() {
        if (control == null) {
            control = new Control(Model.getSingleton(), View.getSingleton());
        }
        return control;
    }
}

