/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.control;

import org.parosproxy.paros.control.ProxyListenerTrap;
import org.parosproxy.paros.core.proxy.ProxyListener;
import org.parosproxy.paros.core.proxy.ProxyServer;
import org.parosproxy.paros.core.proxy.ProxyServerSSL;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.View;

public class Proxy {
    private View view = null;
    private Model model = null;
    private ProxyServer proxyServer = null;
    private ProxyServerSSL proxyServerSSL = null;

    public Proxy(Model model, View view) {
        this.model = model;
        this.view = view;
        this.proxyServer = new ProxyServer();
        this.proxyServerSSL = new ProxyServerSSL();
        if (view != null) {
            ProxyListenerTrap proxyListenerTrap = new ProxyListenerTrap();
            proxyListenerTrap.setTrapPanel(view.getTrapPanel());
            this.addProxyListener(proxyListenerTrap);
        }
    }

    public void startServer() {
        this.proxyServer.setProxyParam(this.model.getOptionsParam().getProxyParam());
        this.proxyServer.setConnectionParam(this.model.getOptionsParam().getConnectionParam());
        this.proxyServerSSL.setProxyParam(this.model.getOptionsParam().getProxyParam());
        this.proxyServerSSL.setConnectionParam(this.model.getOptionsParam().getConnectionParam());
        this.proxyServer.startServer();
        this.proxyServerSSL.startServer();
    }

    public void stopServer() {
        this.proxyServer.stopServer();
        this.proxyServerSSL.stopServer();
    }

    public void setSerialize(boolean bl) {
        this.proxyServer.setSerialize(bl);
        this.proxyServerSSL.setSerialize(bl);
    }

    public void addProxyListener(ProxyListener proxyListener) {
        this.proxyServer.addProxyListener(proxyListener);
        this.proxyServerSSL.addProxyListener(proxyListener);
    }

    public void removeProxyListener(ProxyListener proxyListener) {
        this.proxyServer.removeProxyListener(proxyListener);
        this.proxyServerSSL.removeProxyListener(proxyListener);
    }
}

