/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.text.DecimalFormat;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.parosproxy.paros.common.ThreadPool;
import org.parosproxy.paros.core.scanner.Alert;
import org.parosproxy.paros.core.scanner.Analyser;
import org.parosproxy.paros.core.scanner.HostProcess;
import org.parosproxy.paros.core.scanner.ScannerListener;
import org.parosproxy.paros.core.scanner.ScannerParam;
import org.parosproxy.paros.core.scanner.Util;
import org.parosproxy.paros.model.SiteNode;
import org.parosproxy.paros.network.ConnectionParam;

public class Scanner
implements Runnable {
    private static Log log = LogFactory.getLog(class$org$parosproxy$paros$core$scanner$Scanner == null ? (class$org$parosproxy$paros$core$scanner$Scanner = Scanner.class$("org.parosproxy.paros.core.scanner.Scanner")) : class$org$parosproxy$paros$core$scanner$Scanner);
    private static DecimalFormat decimalFormat = new DecimalFormat("###0.###");
    private Vector listenerList = new Vector();
    private ScannerParam scannerParam = null;
    private ConnectionParam connectionParam = null;
    private boolean isStop = false;
    private ThreadPool pool = null;
    private SiteNode startNode = null;
    private Analyser analyser = null;
    private long startTimeMillis = 0L;
    static /* synthetic */ Class class$org$parosproxy$paros$core$scanner$Scanner;

    public Scanner(ScannerParam scannerParam, ConnectionParam connectionParam) {
        this.connectionParam = connectionParam;
        this.scannerParam = scannerParam;
        this.pool = new ThreadPool(scannerParam.getHostPerScan());
    }

    public void start(SiteNode siteNode) {
        log.info("scanner started");
        this.startTimeMillis = System.currentTimeMillis();
        this.startNode = siteNode;
        Thread thread = new Thread(this);
        thread.start();
    }

    public void stop() {
        log.info("scanner stopped");
        this.isStop = true;
    }

    public void addScannerListener(ScannerListener scannerListener) {
        this.listenerList.add(scannerListener);
    }

    public void removeScannerListener(ScannerListener scannerListener) {
        this.listenerList.remove(scannerListener);
    }

    public void run() {
        this.scan(this.startNode);
        this.pool.waitAllThreadComplete(600000);
        this.notifyScannerComplete();
    }

    public void scan(SiteNode siteNode) {
        HostProcess hostProcess = null;
        Thread thread = null;
        if (siteNode.isRoot()) {
            for (int i = 0; i < siteNode.getChildCount() && !this.isStop(); ++i) {
                SiteNode siteNode2 = (SiteNode)siteNode.getChildAt(i);
                String string = this.getHostAndPort(siteNode2);
                hostProcess = new HostProcess(string, this, this.scannerParam, this.connectionParam);
                hostProcess.setStartNode(siteNode2);
                do {
                    if ((thread = this.pool.getFreeThread(hostProcess)) != null) continue;
                    Util.sleep(500);
                } while (thread == null && !this.isStop());
                if (thread == null) continue;
                this.notifyHostNewScan(string, hostProcess);
                thread.start();
            }
        } else {
            String string = this.getHostAndPort(siteNode);
            hostProcess = new HostProcess(string, this, this.scannerParam, this.connectionParam);
            hostProcess.setStartNode(siteNode);
            thread = this.pool.getFreeThread(hostProcess);
            this.notifyHostNewScan(string, hostProcess);
            thread.start();
        }
    }

    public boolean isStop() {
        return this.isStop;
    }

    private String getHostAndPort(SiteNode siteNode) {
        String string = "";
        SiteNode siteNode2 = null;
        if (siteNode == null || siteNode.isRoot()) {
            string = "";
        } else {
            SiteNode siteNode3 = siteNode;
            siteNode2 = (SiteNode)siteNode.getParent();
            while (!siteNode2.isRoot()) {
                siteNode3 = siteNode2;
                siteNode2 = (SiteNode)siteNode3.getParent();
            }
            string = siteNode3.toString();
        }
        return string;
    }

    void notifyHostComplete(String string) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = (ScannerListener)this.listenerList.get(i);
            scannerListener.hostComplete(string);
        }
    }

    void notifyHostProgress(String string, String string2, int n) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = (ScannerListener)this.listenerList.get(i);
            scannerListener.hostProgress(string, string2, n);
        }
    }

    void notifyScannerComplete() {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = (ScannerListener)this.listenerList.get(i);
            scannerListener.scannerComplete();
        }
        long l = System.currentTimeMillis() - this.startTimeMillis;
        String string = decimalFormat.format((double)l / 1000.0) + "s";
        log.info("scanner completed in " + string);
    }

    void notifyAlertFound(Alert alert) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = (ScannerListener)this.listenerList.get(i);
            scannerListener.alertFound(alert);
        }
    }

    void notifyHostNewScan(String string, HostProcess hostProcess) {
        for (int i = 0; i < this.listenerList.size(); ++i) {
            ScannerListener scannerListener = (ScannerListener)this.listenerList.get(i);
            scannerListener.hostNewScan(string, hostProcess);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

