/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner.plugin;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.parosproxy.paros.core.scanner.AbstractAppPlugin;
import org.parosproxy.paros.network.HttpMessage;

public class TestClientAutocomplete
extends AbstractAppPlugin {
    public static final Pattern patternAutocomplete = Pattern.compile("AUTOCOMPLETE\\s*=[^>]*OFF[^>]*", 10);
    public static final Pattern patternForm = Pattern.compile("(<FORM\\s*[^>]+\\s*>).*?(<INPUT\\s*[^>]+type=[\"']?PASSWORD[\"']?[^>]+\\s*>).*?</FORM>", 42);

    public int getId() {
        return 10001;
    }

    public String getName() {
        return "Password Autocomplete in browser";
    }

    public String[] getDependency() {
        return null;
    }

    public String getDescription() {
        return "AUTOCOMPLETE attribute is not disabled in HTML FORM/INPUT element containing password type input.  Passwords may be stored in browsers and retrieved.";
    }

    public int getCategory() {
        return 1;
    }

    public String getSolution() {
        String string = "Turn off AUTOCOMPLETE attribute in form or individual input elements containing password:\r\nAUTOCOMPLETE='OFF'\r\n";
        return string;
    }

    public String getReference() {
        return "http://msdn.microsoft.com/library/default.asp?url=/workshop/author/forms/autocomplete_ovr.asp";
    }

    public void init() {
    }

    public void scan() {
        HttpMessage httpMessage = this.getBaseMsg();
        String string = httpMessage.getResponseBody().toString();
        String string2 = null;
        String string3 = null;
        Matcher matcher = patternForm.matcher(string);
        Matcher matcher2 = null;
        boolean bl = false;
        while (matcher.find()) {
            string2 = matcher.group(1);
            string3 = matcher.group(2);
            if (string2 == null || string3 == null || (matcher2 = patternAutocomplete.matcher(string2)).find() || (matcher2 = patternAutocomplete.matcher(string3)).find()) continue;
            this.bingo(2, 1, null, "", string3, httpMessage);
        }
    }
}

